<?php

namespace Drupal\commerce_log\EventSubscriber;

use Drupal\commerce_checkout\Event\CheckoutEvents;
use Drupal\commerce_order\Event\OrderEvent;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class CheckoutEventSubscriber implements EventSubscriberInterface {

  /**
   * The log storage.
   *
   * @var \Drupal\commerce_log\LogStorageInterface
   */
  protected $logStorage;

  /**
   * Constructs a new CheckoutEventSubscriber object.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The entity type manager.
   */
  public function __construct(EntityTypeManagerInterface $entity_type_manager) {
    $this->logStorage = $entity_type_manager->getStorage('commerce_log');
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    return [
      CheckoutEvents::COMPLETION => ['onCheckoutCompletion', -100],
    ];
  }

  /**
   * Creates a log when the customer completes checkout.
   *
   * @param \Drupal\commerce_order\Event\OrderEvent $event
   *   The order event.
   */
  public function onCheckoutCompletion(OrderEvent $event) {
    $order = $event->getOrder();
    $this->logStorage->generate($order, 'checkout_complete')->save();
    if ($comments = $order->getCustomerComments()) {
      $this->logStorage->generate($order, 'commerce_order_from_customer_comment', [
        'comment' => $comments,
      ])->save();
    }
  }

}
