/**
 * @file
 * Control recenter.
 */

(function ($, Drupal) {

  'use strict';

  /**
   * Recenter control.
   *
   * @type {Drupal~behavior}
   *
   * @prop {Drupal~behaviorAttach} attach
   *   Attaches common map recenter functionality to relevant elements.
   */
  Drupal.behaviors.leafletControlRecenter = {
    attach: function (context, drupalSettings) {
      Drupal.geolocation.executeFeatureOnAllMaps(
        'leaflet_control_recenter',

        /**
         * @param {GeolocationLeafletMap} map - Current map.
         * @param {GeolocationMapFeatureSettings} featureSettings - Settings for current feature.
         */
        function (map, featureSettings) {
          map.addInitializedCallback(function (map) {
            jQuery.each(map.leafletMap.controls, function (index, control) {
              var currentControlContainer = control.getContainer();
              if (!currentControlContainer.classList.contains('leaflet_control_recenter')) {
                return;
              }
              map.leafletMap.removeControl(control);
              map.leafletMap.addControl(control);
            });
            var recenterButton = $('.geolocation-map-control .recenter', map.wrapper);
            recenterButton.click(function (e) {
              map.setCenter();
              e.preventDefault();
            });
          });

          return true;
        },
        drupalSettings
      );
    },
    detach: function (context, drupalSettings) {}
  };

})(jQuery, Drupal);
