<?php
// @codingStandardsIgnoreFile
/**
 * @file
 * A database agnostic dump for testing purposes.
 *
 * This file was generated by the Drupal 9.0.6 db-tools.php script.
 */

use Drupal\Core\Database\Database;

$connection = Database::getConnection();

$connection->schema()->createTable('actions', array(
  'fields' => array(
    'aid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '0',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'parameters' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('actions')
->fields(array(
  'aid',
  'type',
  'callback',
  'parameters',
  'label',
))
->values(array(
  'aid' => 'node_make_sticky_action',
  'type' => 'node',
  'callback' => 'node_make_sticky_action',
  'parameters' => '',
  'label' => 'Make content sticky',
))
->values(array(
  'aid' => 'node_make_unsticky_action',
  'type' => 'node',
  'callback' => 'node_make_unsticky_action',
  'parameters' => '',
  'label' => 'Make content unsticky',
))
->values(array(
  'aid' => 'node_promote_action',
  'type' => 'node',
  'callback' => 'node_promote_action',
  'parameters' => '',
  'label' => 'Promote content to front page',
))
->values(array(
  'aid' => 'node_publish_action',
  'type' => 'node',
  'callback' => 'node_publish_action',
  'parameters' => '',
  'label' => 'Publish content',
))
->values(array(
  'aid' => 'node_save_action',
  'type' => 'node',
  'callback' => 'node_save_action',
  'parameters' => '',
  'label' => 'Save content',
))
->values(array(
  'aid' => 'node_unpromote_action',
  'type' => 'node',
  'callback' => 'node_unpromote_action',
  'parameters' => '',
  'label' => 'Remove content from front page',
))
->values(array(
  'aid' => 'node_unpublish_action',
  'type' => 'node',
  'callback' => 'node_unpublish_action',
  'parameters' => '',
  'label' => 'Unpublish content',
))
->values(array(
  'aid' => 'system_block_ip_action',
  'type' => 'user',
  'callback' => 'system_block_ip_action',
  'parameters' => '',
  'label' => 'Ban IP address of current user',
))
->values(array(
  'aid' => 'user_block_user_action',
  'type' => 'user',
  'callback' => 'user_block_user_action',
  'parameters' => '',
  'label' => 'Block current user',
))
->execute();
$connection->schema()->createTable('authmap', array(
  'fields' => array(
    'aid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'authname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'unique keys' => array(
    'authname' => array(
      'authname',
    ),
  ),
  'indexes' => array(
    'uid_module' => array(
      'uid',
      'module',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('batch', array(
  'fields' => array(
    'bid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'token' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'batch' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'indexes' => array(
    'token' => array(
      'token',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('block', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '0',
    ),
    'theme' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'region' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'custom' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'visibility' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'pages' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '1',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'unique keys' => array(
    'tmd' => array(
      'theme',
      'module',
      'delta',
    ),
  ),
  'indexes' => array(
    'list' => array(
      'theme',
      'status',
      'region',
      'weight',
      'module',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('block')
->fields(array(
  'bid',
  'module',
  'delta',
  'theme',
  'status',
  'weight',
  'region',
  'custom',
  'visibility',
  'pages',
  'title',
  'cache',
))
->values(array(
  'bid' => '1',
  'module' => 'system',
  'delta' => 'main',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'content',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '2',
  'module' => 'user',
  'delta' => 'login',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'sidebar_first',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '3',
  'module' => 'system',
  'delta' => 'navigation',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'sidebar_first',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '4',
  'module' => 'system',
  'delta' => 'management',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '1',
  'region' => 'sidebar_first',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '5',
  'module' => 'system',
  'delta' => 'help',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'help',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '6',
  'module' => 'node',
  'delta' => 'syndicate',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '7',
  'module' => 'node',
  'delta' => 'recent',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '8',
  'module' => 'system',
  'delta' => 'powered-by',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '-7',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '9',
  'module' => 'system',
  'delta' => 'user-menu',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '10',
  'module' => 'system',
  'delta' => 'main-menu',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '11',
  'module' => 'user',
  'delta' => 'new',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '12',
  'module' => 'user',
  'delta' => 'online',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '13',
  'module' => 'webform',
  'delta' => 'client-block-4',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'highlighted',
  'custom' => '0',
  'visibility' => '0',
  'pages' => "node/*\r\nadmin/*",
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '14',
  'module' => 'system',
  'delta' => 'main',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '0',
  'region' => 'content',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '15',
  'module' => 'user',
  'delta' => 'login',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '0',
  'region' => 'sidebar_first',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '16',
  'module' => 'system',
  'delta' => 'navigation',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '0',
  'region' => 'sidebar_first',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '17',
  'module' => 'system',
  'delta' => 'management',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '1',
  'region' => 'sidebar_first',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '18',
  'module' => 'system',
  'delta' => 'help',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '0',
  'region' => 'help',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '19',
  'module' => 'node',
  'delta' => 'syndicate',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '20',
  'module' => 'node',
  'delta' => 'recent',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '21',
  'module' => 'system',
  'delta' => 'powered-by',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-7',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '22',
  'module' => 'system',
  'delta' => 'user-menu',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '23',
  'module' => 'system',
  'delta' => 'main-menu',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '24',
  'module' => 'user',
  'delta' => 'new',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '25',
  'module' => 'user',
  'delta' => 'online',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '26',
  'module' => 'webform',
  'delta' => 'client-block-4',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '0',
  'region' => 'highlighted',
  'custom' => '0',
  'visibility' => '0',
  'pages' => "node/*\r\nadmin/*",
  'title' => '',
  'cache' => '-1',
))
->execute();
$connection->schema()->createTable('block_custom', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'body' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'info' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'unique keys' => array(
    'info' => array(
      'info',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('block_node_type', array(
  'fields' => array(
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'delta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
  ),
  'primary key' => array(
    'module',
    'delta',
    'type',
  ),
  'indexes' => array(
    'type' => array(
      'type',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('block_role', array(
  'fields' => array(
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'delta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'rid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'module',
    'delta',
    'rid',
  ),
  'indexes' => array(
    'rid' => array(
      'rid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('blocked_ips', array(
  'fields' => array(
    'iid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'ip' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '40',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'iid',
  ),
  'indexes' => array(
    'blocked_ip' => array(
      'ip',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_block', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_bootstrap', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_field', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_filter', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_form', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_image', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_menu', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_page', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_path', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_views', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_views_data', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '1',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('ctools_css_cache', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ),
    'filename' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'css' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'filter' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('ctools_object_cache', array(
  'fields' => array(
    'sid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ),
    'obj' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ),
    'updated' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'sid',
    'obj',
    'name',
  ),
  'indexes' => array(
    'updated' => array(
      'updated',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('date_format_locale', array(
  'fields' => array(
    'format' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
      'binary' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
    ),
  ),
  'primary key' => array(
    'type',
    'language',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('date_format_type', array(
  'fields' => array(
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'type',
  ),
  'indexes' => array(
    'title' => array(
      'title',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('date_format_type')
->fields(array(
  'type',
  'title',
  'locked',
))
->values(array(
  'type' => 'long',
  'title' => 'Long',
  'locked' => '1',
))
->values(array(
  'type' => 'medium',
  'title' => 'Medium',
  'locked' => '1',
))
->values(array(
  'type' => 'short',
  'title' => 'Short',
  'locked' => '1',
))
->execute();
$connection->schema()->createTable('date_formats', array(
  'fields' => array(
    'dfid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'format' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
      'binary' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'dfid',
  ),
  'unique keys' => array(
    'formats' => array(
      'format',
      'type',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('date_formats')
->fields(array(
  'dfid',
  'format',
  'type',
  'locked',
))
->values(array(
  'dfid' => '1',
  'format' => 'm/d/Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '2',
  'format' => 'd/m/Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '3',
  'format' => 'Y/m/d - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '4',
  'format' => 'd.m.Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '5',
  'format' => 'Y-m-d H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '6',
  'format' => 'm/d/Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '7',
  'format' => 'd/m/Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '8',
  'format' => 'Y/m/d - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '9',
  'format' => 'M j Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '10',
  'format' => 'j M Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '11',
  'format' => 'Y M j - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '12',
  'format' => 'M j Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '13',
  'format' => 'j M Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '14',
  'format' => 'Y M j - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '15',
  'format' => 'D, m/d/Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '16',
  'format' => 'D, d/m/Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '17',
  'format' => 'D, Y/m/d - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '18',
  'format' => 'D, Y-m-d H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '19',
  'format' => 'F j, Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '20',
  'format' => 'j F, Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '21',
  'format' => 'Y, F j - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '22',
  'format' => 'D, m/d/Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '23',
  'format' => 'D, d/m/Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '24',
  'format' => 'D, Y/m/d - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '25',
  'format' => 'F j, Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '26',
  'format' => 'j F Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '27',
  'format' => 'Y, F j - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '28',
  'format' => 'j. F Y - G:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '29',
  'format' => 'l, F j, Y - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '30',
  'format' => 'l, j F, Y - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '31',
  'format' => 'l, Y,  F j - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '32',
  'format' => 'l, F j, Y - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '33',
  'format' => 'l, j F Y - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '34',
  'format' => 'l, Y,  F j - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '35',
  'format' => 'l, j. F Y - G:i',
  'type' => 'long',
  'locked' => '1',
))
->execute();
$connection->schema()->createTable('field_config', array(
  'fields' => array(
    'id' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'field_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'active' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'storage_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ),
    'storage_module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'storage_active' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'cardinality' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'translatable' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'id',
  ),
  'indexes' => array(
    'field_name' => array(
      'field_name',
    ),
    'active' => array(
      'active',
    ),
    'storage_active' => array(
      'storage_active',
    ),
    'deleted' => array(
      'deleted',
    ),
    'module' => array(
      'module',
    ),
    'storage_module' => array(
      'storage_module',
    ),
    'type' => array(
      'type',
    ),
    'storage_type' => array(
      'storage_type',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_config')
->fields(array(
  'id',
  'field_name',
  'type',
  'module',
  'active',
  'storage_type',
  'storage_module',
  'storage_active',
  'locked',
  'data',
  'cardinality',
  'translatable',
  'deleted',
))
->values(array(
  'id' => '1',
  'field_name' => 'body',
  'type' => 'text_with_summary',
  'module' => 'text',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:6:{s:12:"entity_types";a:1:{i:0;s:4:"node";}s:12:"translatable";b:0;s:8:"settings";a:0:{}s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"foreign keys";a:1:{s:6:"format";a:2:{s:5:"table";s:13:"filter_format";s:7:"columns";a:1:{s:6:"format";s:6:"format";}}}s:7:"indexes";a:1:{s:6:"format";a:1:{i:0;s:6:"format";}}}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '2',
  'field_name' => 'field_summary',
  'type' => 'text_long',
  'module' => 'text',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";s:1:"0";s:12:"entity_types";a:0:{}s:8:"settings";a:0:{}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:24:"field_data_field_summary";a:2:{s:5:"value";s:19:"field_summary_value";s:6:"format";s:20:"field_summary_format";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:28:"field_revision_field_summary";a:2:{s:5:"value";s:19:"field_summary_value";s:6:"format";s:20:"field_summary_format";}}}}}s:12:"foreign keys";a:1:{s:6:"format";a:2:{s:5:"table";s:13:"filter_format";s:7:"columns";a:1:{s:6:"format";s:6:"format";}}}s:7:"indexes";a:1:{s:6:"format";a:1:{i:0;s:6:"format";}}s:2:"id";s:1:"2";}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->execute();
$connection->schema()->createTable('field_config_instance', array(
  'fields' => array(
    'id' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'field_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'field_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'id',
  ),
  'indexes' => array(
    'field_name_bundle' => array(
      'field_name',
      'entity_type',
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_config_instance')
->fields(array(
  'id',
  'field_id',
  'field_name',
  'entity_type',
  'bundle',
  'data',
  'deleted',
))
->values(array(
  'id' => '2',
  'field_id' => '1',
  'field_name' => 'body',
  'entity_type' => 'node',
  'bundle' => 'page',
  'data' => 'a:6:{s:5:"label";s:4:"Body";s:6:"widget";a:4:{s:4:"type";s:26:"text_textarea_with_summary";s:8:"settings";a:2:{s:4:"rows";i:20;s:12:"summary_rows";i:5;}s:6:"weight";i:-4;s:6:"module";s:4:"text";}s:8:"settings";a:3:{s:15:"display_summary";b:1;s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"weight";i:0;}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:0;}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '3',
  'field_id' => '2',
  'field_name' => 'field_summary',
  'entity_type' => 'node',
  'bundle' => 'webform_custom',
  'data' => 'a:7:{s:5:"label";s:7:"Summary";s:6:"widget";a:5:{s:6:"weight";s:2:"-4";s:4:"type";s:13:"text_textarea";s:6:"module";s:4:"text";s:6:"active";i:1;s:8:"settings";a:1:{s:4:"rows";s:1:"5";}}s:8:"settings";a:2:{s:15:"text_processing";s:1:"0";s:18:"user_register_form";b:0;}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"weight";i:0;}s:6:"teaser";a:5:{s:5:"label";s:5:"above";s:4:"type";s:12:"text_trimmed";s:6:"weight";s:1:"0";s:8:"settings";a:1:{s:11:"trim_length";s:3:"600";}s:6:"module";s:4:"text";}}s:8:"required";i:0;s:11:"description";s:0:"";s:13:"default_value";N;}',
  'deleted' => '0',
))
->execute();
$connection->schema()->createTable('field_data_body', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'body_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'body_summary' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'body_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'body_format' => array(
      'body_format',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_data_body')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'body_value',
  'body_summary',
  'body_format',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'page',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '0',
  'body_value' => "In faucibus ante nisi, in molestie justo congue a. Mauris metus mauris, sodales sed pharetra vitae, porta ac nibh. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse eget convallis felis. Sed faucibus libero nunc, eu venenatis elit aliquet vitae.\r\n\r\nEtiam sagittis, urna sodales ornare molestie, turpis augue vehicula ante, eu fermentum magna mi ac turpis. Etiam erat nulla, tempus at eros id, lobortis volutpat arcu. Aliquam eu lobortis lectus. Etiam enim mi, condimentum vel porttitor at, egestas non leo. Vivamus eget ipsum et purus scelerisque gravida quis et lorem. Proin tempor, lacus vel bibendum facilisis, nisl nulla bibendum quam, eget maximus orci sem eu ligula. Maecenas tristique sodales justo, vel iaculis nisl iaculis sed. Proin auctor, arcu ut tempus maximus, velit lacus tincidunt turpis, at accumsan elit lectus sit amet justo. Nunc lectus lorem, scelerisque id sollicitudin sit amet, blandit a ex.",
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'page',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '2',
  'language' => 'und',
  'delta' => '0',
  'body_value' => 'Curabitur id diam arcu. Quisque in eros ac magna malesuada maximus et vel quam. Ut faucibus nibh ac justo viverra euismod. Duis mi sem, iaculis ac facilisis ac, lacinia nec ante. Vivamus sit amet porttitor tellus, in facilisis ligula. Etiam dolor justo, volutpat congue dolor sit amet, fermentum luctus est. Aliquam non maximus ante.',
  'body_summary' => 'Iaculis ac facilisis ac, lacinia nec ante.',
  'body_format' => 'filtered_html',
))
->execute();
$connection->schema()->createTable('field_data_field_summary', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_summary_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'field_summary_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'field_summary_format' => array(
      'field_summary_format',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_data_field_summary')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'field_summary_value',
  'field_summary_format',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'webform_custom',
  'deleted' => '0',
  'entity_id' => '3',
  'revision_id' => '3',
  'language' => 'und',
  'delta' => '0',
  'field_summary_value' => 'This is a summary text for "webform custom host node #1"',
  'field_summary_format' => NULL,
))
->execute();
$connection->schema()->createTable('field_revision_body', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'body_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'body_summary' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'body_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'body_format' => array(
      'body_format',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_revision_body')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'body_value',
  'body_summary',
  'body_format',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'page',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '0',
  'body_value' => "In faucibus ante nisi, in molestie justo congue a. Mauris metus mauris, sodales sed pharetra vitae, porta ac nibh. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse eget convallis felis. Sed faucibus libero nunc, eu venenatis elit aliquet vitae.\r\n\r\nEtiam sagittis, urna sodales ornare molestie, turpis augue vehicula ante, eu fermentum magna mi ac turpis. Etiam erat nulla, tempus at eros id, lobortis volutpat arcu. Aliquam eu lobortis lectus. Etiam enim mi, condimentum vel porttitor at, egestas non leo. Vivamus eget ipsum et purus scelerisque gravida quis et lorem. Proin tempor, lacus vel bibendum facilisis, nisl nulla bibendum quam, eget maximus orci sem eu ligula. Maecenas tristique sodales justo, vel iaculis nisl iaculis sed. Proin auctor, arcu ut tempus maximus, velit lacus tincidunt turpis, at accumsan elit lectus sit amet justo. Nunc lectus lorem, scelerisque id sollicitudin sit amet, blandit a ex.",
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'page',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '2',
  'language' => 'und',
  'delta' => '0',
  'body_value' => 'Curabitur id diam arcu. Quisque in eros ac magna malesuada maximus et vel quam. Ut faucibus nibh ac justo viverra euismod. Duis mi sem, iaculis ac facilisis ac, lacinia nec ante. Vivamus sit amet porttitor tellus, in facilisis ligula. Etiam dolor justo, volutpat congue dolor sit amet, fermentum luctus est. Aliquam non maximus ante.',
  'body_summary' => 'Iaculis ac facilisis ac, lacinia nec ante.',
  'body_format' => 'filtered_html',
))
->execute();
$connection->schema()->createTable('field_revision_field_summary', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_summary_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'field_summary_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'field_summary_format' => array(
      'field_summary_format',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_revision_field_summary')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'field_summary_value',
  'field_summary_format',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'webform_custom',
  'deleted' => '0',
  'entity_id' => '3',
  'revision_id' => '3',
  'language' => 'und',
  'delta' => '0',
  'field_summary_value' => 'This is a summary text for "webform custom host node #1"',
  'field_summary_format' => NULL,
))
->execute();
$connection->schema()->createTable('file_managed', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'filename' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'uri' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
      'binary' => TRUE,
    ),
    'filemime' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'filesize' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'big',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'unique keys' => array(
    'uri' => array(
      'uri',
    ),
  ),
  'indexes' => array(
    'uid' => array(
      'uid',
    ),
    'status' => array(
      'status',
    ),
    'timestamp' => array(
      'timestamp',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('file_managed')
->fields(array(
  'fid',
  'uid',
  'filename',
  'uri',
  'filemime',
  'filesize',
  'status',
  'timestamp',
))
->values(array(
  'fid' => '1',
  'uid' => '0',
  'filename' => 'LICENSE.txt',
  'uri' => 'public://webform/LICENSE.txt',
  'filemime' => 'text/plain',
  'filesize' => '18002',
  'status' => '1',
  'timestamp' => '1600263958',
))
->values(array(
  'fid' => '2',
  'uid' => '0',
  'filename' => 'document.odt',
  'uri' => 'public://webform/document.odt',
  'filemime' => 'application/vnd.oasis.opendocument.text',
  'filesize' => '8089',
  'status' => '1',
  'timestamp' => '1600264081',
))
->values(array(
  'fid' => '3',
  'uid' => '0',
  'filename' => 'blue.png',
  'uri' => 'public://webform/blue.png',
  'filemime' => 'image/png',
  'filesize' => '9061',
  'status' => '1',
  'timestamp' => '1600327212',
))
->execute();
$connection->schema()->createTable('file_usage', array(
  'fields' => array(
    'fid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'count' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'fid',
    'type',
    'id',
    'module',
  ),
  'indexes' => array(
    'type_id' => array(
      'type',
      'id',
    ),
    'fid_count' => array(
      'fid',
      'count',
    ),
    'fid_module' => array(
      'fid',
      'module',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('file_usage')
->fields(array(
  'fid',
  'module',
  'type',
  'id',
  'count',
))
->values(array(
  'fid' => '1',
  'module' => 'webform',
  'type' => 'submission',
  'id' => '1',
  'count' => '1',
))
->values(array(
  'fid' => '2',
  'module' => 'webform',
  'type' => 'submission',
  'id' => '2',
  'count' => '1',
))
->values(array(
  'fid' => '3',
  'module' => 'webform',
  'type' => 'submission',
  'id' => '3',
  'count' => '1',
))
->execute();
$connection->schema()->createTable('filter', array(
  'fields' => array(
    'format' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'settings' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'format',
    'name',
  ),
  'indexes' => array(
    'list' => array(
      'weight',
      'module',
      'name',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('filter')
->fields(array(
  'format',
  'module',
  'name',
  'weight',
  'status',
  'settings',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_autop',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_html',
  'weight' => '-10',
  'status' => '1',
  'settings' => 'a:3:{s:12:"allowed_html";s:74:"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>";s:16:"filter_html_help";i:1;s:20:"filter_html_nofollow";i:0;}',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_htmlcorrector',
  'weight' => '10',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_html_escape',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_url',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:1:{s:17:"filter_url_length";s:2:"72";}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_autop',
  'weight' => '2',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_html',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:3:{s:12:"allowed_html";s:74:"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>";s:16:"filter_html_help";i:1;s:20:"filter_html_nofollow";i:0;}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_htmlcorrector',
  'weight' => '10',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_html_escape',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_url',
  'weight' => '1',
  'status' => '1',
  'settings' => 'a:1:{s:17:"filter_url_length";i:72;}',
))
->execute();
$connection->schema()->createTable('filter_format', array(
  'fields' => array(
    'format' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '1',
      'unsigned' => TRUE,
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'format',
  ),
  'unique keys' => array(
    'name' => array(
      'name',
    ),
  ),
  'indexes' => array(
    'status_weight' => array(
      'status',
      'weight',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('filter_format')
->fields(array(
  'format',
  'name',
  'cache',
  'status',
  'weight',
))
->values(array(
  'format' => 'filtered_html',
  'name' => 'Filtered HTML',
  'cache' => '1',
  'status' => '1',
  'weight' => '0',
))
->values(array(
  'format' => 'plain_text',
  'name' => 'Plain text',
  'cache' => '1',
  'status' => '1',
  'weight' => '10',
))
->execute();
$connection->schema()->createTable('flood', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'event' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'identifier' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'expiration' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'indexes' => array(
    'allow' => array(
      'event',
      'identifier',
      'timestamp',
    ),
    'purge' => array(
      'expiration',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('history', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'uid',
    'nid',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('history')
->fields(array(
  'uid',
  'nid',
  'timestamp',
))
->values(array(
  'uid' => '1',
  'nid' => '4',
  'timestamp' => '1600328877',
))
->values(array(
  'uid' => '1',
  'nid' => '5',
  'timestamp' => '1600335188',
))
->values(array(
  'uid' => '2',
  'nid' => '1',
  'timestamp' => '1600260167',
))
->values(array(
  'uid' => '2',
  'nid' => '2',
  'timestamp' => '1600260211',
))
->values(array(
  'uid' => '2',
  'nid' => '3',
  'timestamp' => '1600325002',
))
->values(array(
  'uid' => '2',
  'nid' => '4',
  'timestamp' => '1600328931',
))
->values(array(
  'uid' => '3',
  'nid' => '3',
  'timestamp' => '1600327500',
))
->values(array(
  'uid' => '3',
  'nid' => '4',
  'timestamp' => '1600327417',
))
->values(array(
  'uid' => '3',
  'nid' => '5',
  'timestamp' => '1600327423',
))
->execute();
$connection->schema()->createTable('image_effects', array(
  'fields' => array(
    'ieid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'isid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'ieid',
  ),
  'indexes' => array(
    'isid' => array(
      'isid',
    ),
    'weight' => array(
      'weight',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('image_styles', array(
  'fields' => array(
    'isid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'isid',
  ),
  'unique keys' => array(
    'name' => array(
      'name',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('menu_links', array(
  'fields' => array(
    'menu_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'mlid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'plid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'link_path' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'router_path' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'link_title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'options' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => 'system',
    ),
    'hidden' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'external' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'has_children' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'expanded' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'depth' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'customized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'p1' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p2' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p3' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p4' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p5' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p6' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p7' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p8' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p9' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'updated' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'mlid',
  ),
  'indexes' => array(
    'path_menu' => array(
      array(
        'link_path',
        '128',
      ),
      'menu_name',
    ),
    'menu_plid_expand_child' => array(
      'menu_name',
      'plid',
      'expanded',
      'has_children',
    ),
    'menu_parents' => array(
      'menu_name',
      'p1',
      'p2',
      'p3',
      'p4',
      'p5',
      'p6',
      'p7',
      'p8',
      'p9',
    ),
    'router_path' => array(
      array(
        'router_path',
        '128',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('menu_links')
->fields(array(
  'menu_name',
  'mlid',
  'plid',
  'link_path',
  'router_path',
  'link_title',
  'options',
  'module',
  'hidden',
  'external',
  'has_children',
  'expanded',
  'weight',
  'depth',
  'customized',
  'p1',
  'p2',
  'p3',
  'p4',
  'p5',
  'p6',
  'p7',
  'p8',
  'p9',
  'updated',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '1',
  'plid' => '0',
  'link_path' => 'admin',
  'router_path' => 'admin',
  'link_title' => 'Administration',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '9',
  'depth' => '1',
  'customized' => '0',
  'p1' => '1',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '2',
  'plid' => '0',
  'link_path' => 'user',
  'router_path' => 'user',
  'link_title' => 'User account',
  'options' => 'a:1:{s:5:"alter";b:1;}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '1',
  'customized' => '0',
  'p1' => '2',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '3',
  'plid' => '0',
  'link_path' => 'filter/tips',
  'router_path' => 'filter/tips',
  'link_title' => 'Compose tips',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '3',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '4',
  'plid' => '0',
  'link_path' => 'node/%',
  'router_path' => 'node/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '4',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '5',
  'plid' => '0',
  'link_path' => 'node/add',
  'router_path' => 'node/add',
  'link_title' => 'Add content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '5',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '6',
  'plid' => '1',
  'link_path' => 'admin/appearance',
  'router_path' => 'admin/appearance',
  'link_title' => 'Appearance',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:33:"Select and configure your themes.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-6',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '6',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '7',
  'plid' => '1',
  'link_path' => 'admin/config',
  'router_path' => 'admin/config',
  'link_title' => 'Configuration',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:20:"Administer settings.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '8',
  'plid' => '1',
  'link_path' => 'admin/content',
  'router_path' => 'admin/content',
  'link_title' => 'Content',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:24:"Find and manage content.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '9',
  'plid' => '2',
  'link_path' => 'user/register',
  'router_path' => 'user/register',
  'link_title' => 'Create new account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '9',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '10',
  'plid' => '1',
  'link_path' => 'admin/index',
  'router_path' => 'admin/index',
  'link_title' => 'Index',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-18',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '10',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '11',
  'plid' => '2',
  'link_path' => 'user/login',
  'router_path' => 'user/login',
  'link_title' => 'Log in',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '11',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '12',
  'plid' => '0',
  'link_path' => 'user/logout',
  'router_path' => 'user/logout',
  'link_title' => 'Log out',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '1',
  'customized' => '0',
  'p1' => '12',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '13',
  'plid' => '1',
  'link_path' => 'admin/modules',
  'router_path' => 'admin/modules',
  'link_title' => 'Modules',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:26:"Extend site functionality.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '13',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '14',
  'plid' => '0',
  'link_path' => 'user/%',
  'router_path' => 'user/%',
  'link_title' => 'My account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '14',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '15',
  'plid' => '1',
  'link_path' => 'admin/people',
  'router_path' => 'admin/people',
  'link_title' => 'People',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Manage user accounts, roles, and permissions.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-4',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '16',
  'plid' => '1',
  'link_path' => 'admin/reports',
  'router_path' => 'admin/reports',
  'link_title' => 'Reports',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:34:"View reports, updates, and errors.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '16',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '17',
  'plid' => '2',
  'link_path' => 'user/password',
  'router_path' => 'user/password',
  'link_title' => 'Request new password',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '17',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '18',
  'plid' => '1',
  'link_path' => 'admin/structure',
  'router_path' => 'admin/structure',
  'link_title' => 'Structure',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Administer blocks, content types, menus, etc.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-8',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '19',
  'plid' => '1',
  'link_path' => 'admin/tasks',
  'router_path' => 'admin/tasks',
  'link_title' => 'Tasks',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '19',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '20',
  'plid' => '3',
  'link_path' => 'filter/tips/%',
  'router_path' => 'filter/tips/%',
  'link_title' => 'Compose tips',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '3',
  'p2' => '20',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '21',
  'plid' => '15',
  'link_path' => 'admin/people/create',
  'router_path' => 'admin/people/create',
  'link_title' => 'Add user',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '21',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '22',
  'plid' => '18',
  'link_path' => 'admin/structure/block',
  'router_path' => 'admin/structure/block',
  'link_title' => 'Blocks',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:79:\"Configure what block content appears in your site's sidebars and other regions.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '23',
  'plid' => '14',
  'link_path' => 'user/%/cancel',
  'router_path' => 'user/%/cancel',
  'link_title' => 'Cancel account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '14',
  'p2' => '23',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '24',
  'plid' => '8',
  'link_path' => 'admin/content/node',
  'router_path' => 'admin/content/node',
  'link_title' => 'Content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '24',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '25',
  'plid' => '7',
  'link_path' => 'admin/config/content',
  'router_path' => 'admin/config/content',
  'link_title' => 'Content authoring',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:53:"Settings related to formatting and authoring content.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '25',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '26',
  'plid' => '18',
  'link_path' => 'admin/structure/types',
  'router_path' => 'admin/structure/types',
  'link_title' => 'Content types',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:92:"Manage content types, including default status, front page promotion, comment settings, etc.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '27',
  'plid' => '4',
  'link_path' => 'node/%/delete',
  'router_path' => 'node/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '2',
  'customized' => '0',
  'p1' => '4',
  'p2' => '27',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '28',
  'plid' => '7',
  'link_path' => 'admin/config/development',
  'router_path' => 'admin/config/development',
  'link_title' => 'Development',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:18:"Development tools.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '28',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '29',
  'plid' => '14',
  'link_path' => 'user/%/edit',
  'router_path' => 'user/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '14',
  'p2' => '29',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '30',
  'plid' => '4',
  'link_path' => 'node/%/edit',
  'router_path' => 'node/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '4',
  'p2' => '30',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '31',
  'plid' => '13',
  'link_path' => 'admin/modules/list',
  'router_path' => 'admin/modules/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '13',
  'p3' => '31',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '32',
  'plid' => '15',
  'link_path' => 'admin/people/people',
  'router_path' => 'admin/people/people',
  'link_title' => 'List',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:50:"Find and manage people interacting with your site.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '32',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '33',
  'plid' => '6',
  'link_path' => 'admin/appearance/list',
  'router_path' => 'admin/appearance/list',
  'link_title' => 'List',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:31:"Select and configure your theme";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-1',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '6',
  'p3' => '33',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '34',
  'plid' => '7',
  'link_path' => 'admin/config/media',
  'router_path' => 'admin/config/media',
  'link_title' => 'Media',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:12:"Media tools.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '35',
  'plid' => '7',
  'link_path' => 'admin/config/people',
  'router_path' => 'admin/config/people',
  'link_title' => 'People',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:24:"Configure user accounts.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '36',
  'plid' => '15',
  'link_path' => 'admin/people/permissions',
  'router_path' => 'admin/people/permissions',
  'link_title' => 'Permissions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:64:"Determine access to features by selecting permissions for roles.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '36',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '37',
  'plid' => '16',
  'link_path' => 'admin/reports/dblog',
  'router_path' => 'admin/reports/dblog',
  'link_title' => 'Recent log messages',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"View events that have recently been logged.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-1',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '16',
  'p3' => '37',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '38',
  'plid' => '7',
  'link_path' => 'admin/config/regional',
  'router_path' => 'admin/config/regional',
  'link_title' => 'Regional and language',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:48:"Regional settings, localization and translation.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '38',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '39',
  'plid' => '4',
  'link_path' => 'node/%/revisions',
  'router_path' => 'node/%/revisions',
  'link_title' => 'Revisions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '4',
  'p2' => '39',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '40',
  'plid' => '7',
  'link_path' => 'admin/config/search',
  'router_path' => 'admin/config/search',
  'link_title' => 'Search and metadata',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:36:"Local site search, metadata and SEO.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '40',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '41',
  'plid' => '6',
  'link_path' => 'admin/appearance/settings',
  'router_path' => 'admin/appearance/settings',
  'link_title' => 'Settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:46:"Configure default and theme specific settings.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '6',
  'p3' => '41',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '42',
  'plid' => '16',
  'link_path' => 'admin/reports/status',
  'router_path' => 'admin/reports/status',
  'link_title' => 'Status report',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:74:\"Get a status report about your site's operation and any detected problems.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-60',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '16',
  'p3' => '42',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '43',
  'plid' => '7',
  'link_path' => 'admin/config/system',
  'router_path' => 'admin/config/system',
  'link_title' => 'System',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:37:"General system related configuration.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '43',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '44',
  'plid' => '16',
  'link_path' => 'admin/reports/access-denied',
  'router_path' => 'admin/reports/access-denied',
  'link_title' => "Top 'access denied' errors",
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:35:\"View 'access denied' errors (403s).\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '16',
  'p3' => '44',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '45',
  'plid' => '16',
  'link_path' => 'admin/reports/page-not-found',
  'router_path' => 'admin/reports/page-not-found',
  'link_title' => "Top 'page not found' errors",
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:36:\"View 'page not found' errors (404s).\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '16',
  'p3' => '45',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '46',
  'plid' => '13',
  'link_path' => 'admin/modules/uninstall',
  'router_path' => 'admin/modules/uninstall',
  'link_title' => 'Uninstall',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '13',
  'p3' => '46',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '47',
  'plid' => '7',
  'link_path' => 'admin/config/user-interface',
  'router_path' => 'admin/config/user-interface',
  'link_title' => 'User interface',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:38:"Tools that enhance the user interface.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '47',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '48',
  'plid' => '4',
  'link_path' => 'node/%/view',
  'router_path' => 'node/%/view',
  'link_title' => 'View',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '4',
  'p2' => '48',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '49',
  'plid' => '14',
  'link_path' => 'user/%/view',
  'router_path' => 'user/%/view',
  'link_title' => 'View',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '14',
  'p2' => '49',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '50',
  'plid' => '7',
  'link_path' => 'admin/config/services',
  'router_path' => 'admin/config/services',
  'link_title' => 'Web services',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:30:"Tools related to web services.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '50',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '51',
  'plid' => '7',
  'link_path' => 'admin/config/workflow',
  'router_path' => 'admin/config/workflow',
  'link_title' => 'Workflow',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Content workflow, editorial workflow tools.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '51',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '52',
  'plid' => '35',
  'link_path' => 'admin/config/people/accounts',
  'router_path' => 'admin/config/people/accounts',
  'link_title' => 'Account settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:109:"Configure default behavior of users, including registration requirements, e-mails, fields, and user pictures.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '52',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '53',
  'plid' => '43',
  'link_path' => 'admin/config/system/actions',
  'router_path' => 'admin/config/system/actions',
  'link_title' => 'Actions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"Manage the actions defined for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '43',
  'p4' => '53',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '54',
  'plid' => '22',
  'link_path' => 'admin/structure/block/add',
  'router_path' => 'admin/structure/block/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '54',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '55',
  'plid' => '26',
  'link_path' => 'admin/structure/types/add',
  'router_path' => 'admin/structure/types/add',
  'link_title' => 'Add content type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '55',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '56',
  'plid' => '41',
  'link_path' => 'admin/appearance/settings/bartik',
  'router_path' => 'admin/appearance/settings/bartik',
  'link_title' => 'Bartik',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '6',
  'p3' => '41',
  'p4' => '56',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '57',
  'plid' => '40',
  'link_path' => 'admin/config/search/clean-urls',
  'router_path' => 'admin/config/search/clean-urls',
  'link_title' => 'Clean URLs',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Enable or disable clean URLs for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '40',
  'p4' => '57',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '58',
  'plid' => '43',
  'link_path' => 'admin/config/system/cron',
  'router_path' => 'admin/config/system/cron',
  'link_title' => 'Cron',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:40:"Manage automatic site maintenance tasks.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '43',
  'p4' => '58',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '59',
  'plid' => '38',
  'link_path' => 'admin/config/regional/date-time',
  'router_path' => 'admin/config/regional/date-time',
  'link_title' => 'Date and time',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:44:"Configure display formats for date and time.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '38',
  'p4' => '59',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '60',
  'plid' => '16',
  'link_path' => 'admin/reports/event/%',
  'router_path' => 'admin/reports/event/%',
  'link_title' => 'Details',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '16',
  'p3' => '60',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '61',
  'plid' => '34',
  'link_path' => 'admin/config/media/file-system',
  'router_path' => 'admin/config/media/file-system',
  'link_title' => 'File system',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:68:"Tell Drupal where to store uploaded files and how they are accessed.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '61',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '62',
  'plid' => '41',
  'link_path' => 'admin/appearance/settings/garland',
  'router_path' => 'admin/appearance/settings/garland',
  'link_title' => 'Garland',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '6',
  'p3' => '41',
  'p4' => '62',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '63',
  'plid' => '41',
  'link_path' => 'admin/appearance/settings/global',
  'router_path' => 'admin/appearance/settings/global',
  'link_title' => 'Global settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-1',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '6',
  'p3' => '41',
  'p4' => '63',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '64',
  'plid' => '35',
  'link_path' => 'admin/config/people/ip-blocking',
  'router_path' => 'admin/config/people/ip-blocking',
  'link_title' => 'IP address blocking',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:28:"Manage blocked IP addresses.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '64',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '65',
  'plid' => '34',
  'link_path' => 'admin/config/media/image-toolkit',
  'router_path' => 'admin/config/media/image-toolkit',
  'link_title' => 'Image toolkit',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:74:"Choose which image toolkit to use if you have installed optional toolkits.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '65',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '66',
  'plid' => '26',
  'link_path' => 'admin/structure/types/list',
  'router_path' => 'admin/structure/types/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '66',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '67',
  'plid' => '31',
  'link_path' => 'admin/modules/list/confirm',
  'router_path' => 'admin/modules/list/confirm',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '13',
  'p3' => '31',
  'p4' => '67',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '68',
  'plid' => '28',
  'link_path' => 'admin/config/development/logging',
  'router_path' => 'admin/config/development/logging',
  'link_title' => 'Logging and errors',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:154:\"Settings for logging and alerts modules. Various modules can route Drupal's system events to different destinations, such as syslog, database, email, etc.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '28',
  'p4' => '68',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '69',
  'plid' => '28',
  'link_path' => 'admin/config/development/maintenance',
  'router_path' => 'admin/config/development/maintenance',
  'link_title' => 'Maintenance mode',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:62:"Take the site offline for maintenance or bring it back online.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '28',
  'p4' => '69',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '70',
  'plid' => '28',
  'link_path' => 'admin/config/development/performance',
  'router_path' => 'admin/config/development/performance',
  'link_title' => 'Performance',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:101:"Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '28',
  'p4' => '70',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '71',
  'plid' => '36',
  'link_path' => 'admin/people/permissions/list',
  'router_path' => 'admin/people/permissions/list',
  'link_title' => 'Permissions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:64:"Determine access to features by selecting permissions for roles.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-8',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '36',
  'p4' => '71',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '72',
  'plid' => '50',
  'link_path' => 'admin/config/services/rss-publishing',
  'router_path' => 'admin/config/services/rss-publishing',
  'link_title' => 'RSS publishing',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:114:"Configure the site description, the number of items per feed and whether feeds should be titles/teasers/full-text.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '50',
  'p4' => '72',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '73',
  'plid' => '38',
  'link_path' => 'admin/config/regional/settings',
  'router_path' => 'admin/config/regional/settings',
  'link_title' => 'Regional settings',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:54:\"Settings for the site's default time zone and country.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '38',
  'p4' => '73',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '74',
  'plid' => '36',
  'link_path' => 'admin/people/permissions/roles',
  'router_path' => 'admin/people/permissions/roles',
  'link_title' => 'Roles',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:30:"List, edit, or add user roles.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '36',
  'p4' => '74',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '75',
  'plid' => '41',
  'link_path' => 'admin/appearance/settings/seven',
  'router_path' => 'admin/appearance/settings/seven',
  'link_title' => 'Seven',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '6',
  'p3' => '41',
  'p4' => '75',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '76',
  'plid' => '43',
  'link_path' => 'admin/config/system/site-information',
  'router_path' => 'admin/config/system/site-information',
  'link_title' => 'Site information',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:104:"Change site name, e-mail address, slogan, default front page, and number of posts per page, error pages.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '43',
  'p4' => '76',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '77',
  'plid' => '41',
  'link_path' => 'admin/appearance/settings/stark',
  'router_path' => 'admin/appearance/settings/stark',
  'link_title' => 'Stark',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '6',
  'p3' => '41',
  'p4' => '77',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '78',
  'plid' => '25',
  'link_path' => 'admin/config/content/formats',
  'router_path' => 'admin/config/content/formats',
  'link_title' => 'Text formats',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:127:"Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '25',
  'p4' => '78',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '79',
  'plid' => '46',
  'link_path' => 'admin/modules/uninstall/confirm',
  'router_path' => 'admin/modules/uninstall/confirm',
  'link_title' => 'Uninstall',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '13',
  'p3' => '46',
  'p4' => '79',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '80',
  'plid' => '29',
  'link_path' => 'user/%/edit/account',
  'router_path' => 'user/%/edit/account',
  'link_title' => 'Account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '14',
  'p2' => '29',
  'p3' => '80',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '81',
  'plid' => '78',
  'link_path' => 'admin/config/content/formats/%',
  'router_path' => 'admin/config/content/formats/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '25',
  'p4' => '78',
  'p5' => '81',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '82',
  'plid' => '78',
  'link_path' => 'admin/config/content/formats/add',
  'router_path' => 'admin/config/content/formats/add',
  'link_title' => 'Add text format',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '25',
  'p4' => '78',
  'p5' => '82',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '83',
  'plid' => '22',
  'link_path' => 'admin/structure/block/list/bartik',
  'router_path' => 'admin/structure/block/list/bartik',
  'link_title' => 'Bartik',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '83',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '84',
  'plid' => '53',
  'link_path' => 'admin/config/system/actions/configure',
  'router_path' => 'admin/config/system/actions/configure',
  'link_title' => 'Configure an advanced action',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '43',
  'p4' => '53',
  'p5' => '84',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '85',
  'plid' => '26',
  'link_path' => 'admin/structure/types/manage/%',
  'router_path' => 'admin/structure/types/manage/%',
  'link_title' => 'Edit content type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '86',
  'plid' => '59',
  'link_path' => 'admin/config/regional/date-time/formats',
  'router_path' => 'admin/config/regional/date-time/formats',
  'link_title' => 'Formats',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:51:"Configure display format strings for date and time.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-9',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '38',
  'p4' => '59',
  'p5' => '86',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '87',
  'plid' => '22',
  'link_path' => 'admin/structure/block/list/garland',
  'router_path' => 'admin/structure/block/list/garland',
  'link_title' => 'Garland',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '87',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '88',
  'plid' => '78',
  'link_path' => 'admin/config/content/formats/list',
  'router_path' => 'admin/config/content/formats/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '25',
  'p4' => '78',
  'p5' => '88',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '89',
  'plid' => '53',
  'link_path' => 'admin/config/system/actions/manage',
  'router_path' => 'admin/config/system/actions/manage',
  'link_title' => 'Manage actions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"Manage the actions defined for your site.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '43',
  'p4' => '53',
  'p5' => '89',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '90',
  'plid' => '52',
  'link_path' => 'admin/config/people/accounts/settings',
  'router_path' => 'admin/config/people/accounts/settings',
  'link_title' => 'Settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '52',
  'p5' => '90',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '91',
  'plid' => '22',
  'link_path' => 'admin/structure/block/list/seven',
  'router_path' => 'admin/structure/block/list/seven',
  'link_title' => 'Seven',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '91',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '92',
  'plid' => '22',
  'link_path' => 'admin/structure/block/list/stark',
  'router_path' => 'admin/structure/block/list/stark',
  'link_title' => 'Stark',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '92',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '93',
  'plid' => '59',
  'link_path' => 'admin/config/regional/date-time/types',
  'router_path' => 'admin/config/regional/date-time/types',
  'link_title' => 'Types',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:44:"Configure display formats for date and time.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '38',
  'p4' => '59',
  'p5' => '93',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '94',
  'plid' => '39',
  'link_path' => 'node/%/revisions/%/delete',
  'router_path' => 'node/%/revisions/%/delete',
  'link_title' => 'Delete earlier revision',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '4',
  'p2' => '39',
  'p3' => '94',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '95',
  'plid' => '39',
  'link_path' => 'node/%/revisions/%/revert',
  'router_path' => 'node/%/revisions/%/revert',
  'link_title' => 'Revert to earlier revision',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '4',
  'p2' => '39',
  'p3' => '95',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '96',
  'plid' => '39',
  'link_path' => 'node/%/revisions/%/view',
  'router_path' => 'node/%/revisions/%/view',
  'link_title' => 'Revisions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '4',
  'p2' => '39',
  'p3' => '96',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '98',
  'plid' => '91',
  'link_path' => 'admin/structure/block/list/seven/add',
  'router_path' => 'admin/structure/block/list/seven/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '91',
  'p5' => '98',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '99',
  'plid' => '92',
  'link_path' => 'admin/structure/block/list/stark/add',
  'router_path' => 'admin/structure/block/list/stark/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '92',
  'p5' => '99',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '100',
  'plid' => '93',
  'link_path' => 'admin/config/regional/date-time/types/add',
  'router_path' => 'admin/config/regional/date-time/types/add',
  'link_title' => 'Add date type',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:18:"Add new date type.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '38',
  'p4' => '59',
  'p5' => '93',
  'p6' => '100',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '101',
  'plid' => '86',
  'link_path' => 'admin/config/regional/date-time/formats/add',
  'router_path' => 'admin/config/regional/date-time/formats/add',
  'link_title' => 'Add format',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Allow users to add additional date formats.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '38',
  'p4' => '59',
  'p5' => '86',
  'p6' => '101',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '102',
  'plid' => '22',
  'link_path' => 'admin/structure/block/manage/%/%',
  'router_path' => 'admin/structure/block/manage/%/%',
  'link_title' => 'Configure block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '102',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '103',
  'plid' => '23',
  'link_path' => 'user/%/cancel/confirm/%/%',
  'router_path' => 'user/%/cancel/confirm/%/%',
  'link_title' => 'Confirm account cancellation',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '14',
  'p2' => '23',
  'p3' => '103',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '104',
  'plid' => '85',
  'link_path' => 'admin/structure/types/manage/%/delete',
  'router_path' => 'admin/structure/types/manage/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '104',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '105',
  'plid' => '64',
  'link_path' => 'admin/config/people/ip-blocking/delete/%',
  'router_path' => 'admin/config/people/ip-blocking/delete/%',
  'link_title' => 'Delete IP address',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '64',
  'p5' => '105',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '106',
  'plid' => '53',
  'link_path' => 'admin/config/system/actions/delete/%',
  'router_path' => 'admin/config/system/actions/delete/%',
  'link_title' => 'Delete action',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:17:"Delete an action.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '43',
  'p4' => '53',
  'p5' => '106',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '107',
  'plid' => '74',
  'link_path' => 'admin/people/permissions/roles/delete/%',
  'router_path' => 'admin/people/permissions/roles/delete/%',
  'link_title' => 'Delete role',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '36',
  'p4' => '74',
  'p5' => '107',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '108',
  'plid' => '81',
  'link_path' => 'admin/config/content/formats/%/disable',
  'router_path' => 'admin/config/content/formats/%/disable',
  'link_title' => 'Disable text format',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '25',
  'p4' => '78',
  'p5' => '81',
  'p6' => '108',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '109',
  'plid' => '85',
  'link_path' => 'admin/structure/types/manage/%/edit',
  'router_path' => 'admin/structure/types/manage/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '109',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '110',
  'plid' => '74',
  'link_path' => 'admin/people/permissions/roles/edit/%',
  'router_path' => 'admin/people/permissions/roles/edit/%',
  'link_title' => 'Edit role',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '36',
  'p4' => '74',
  'p5' => '110',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '111',
  'plid' => '102',
  'link_path' => 'admin/structure/block/manage/%/%/configure',
  'router_path' => 'admin/structure/block/manage/%/%/configure',
  'link_title' => 'Configure block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '102',
  'p5' => '111',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '112',
  'plid' => '102',
  'link_path' => 'admin/structure/block/manage/%/%/delete',
  'router_path' => 'admin/structure/block/manage/%/%/delete',
  'link_title' => 'Delete block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '102',
  'p5' => '112',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '113',
  'plid' => '86',
  'link_path' => 'admin/config/regional/date-time/formats/%/delete',
  'router_path' => 'admin/config/regional/date-time/formats/%/delete',
  'link_title' => 'Delete date format',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:47:"Allow users to delete a configured date format.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '38',
  'p4' => '59',
  'p5' => '86',
  'p6' => '113',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '114',
  'plid' => '93',
  'link_path' => 'admin/config/regional/date-time/types/%/delete',
  'router_path' => 'admin/config/regional/date-time/types/%/delete',
  'link_title' => 'Delete date type',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Allow users to delete a configured date type.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '38',
  'p4' => '59',
  'p5' => '93',
  'p6' => '114',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '115',
  'plid' => '86',
  'link_path' => 'admin/config/regional/date-time/formats/%/edit',
  'router_path' => 'admin/config/regional/date-time/formats/%/edit',
  'link_title' => 'Edit date format',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Allow users to edit a configured date format.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '38',
  'p4' => '59',
  'p5' => '86',
  'p6' => '115',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '116',
  'plid' => '4',
  'link_path' => 'node/%/webform-results',
  'router_path' => 'node/%/webform-results',
  'link_title' => 'Results',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '4',
  'p2' => '116',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '117',
  'plid' => '5',
  'link_path' => 'node/add/webform',
  'router_path' => 'node/add/webform',
  'link_title' => 'Webform',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:138:"Create a new form or questionnaire accessible to users. Submission results and statistics are recorded and accessible to privileged users.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '117',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '118',
  'plid' => '4',
  'link_path' => 'node/%/webform',
  'router_path' => 'node/%/webform',
  'link_title' => 'Webform',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '2',
  'customized' => '0',
  'p1' => '4',
  'p2' => '118',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '119',
  'plid' => '8',
  'link_path' => 'admin/content/webform',
  'router_path' => 'admin/content/webform',
  'link_title' => 'Webforms',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:54:"View and edit all the available webforms on your site.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '119',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '120',
  'plid' => '116',
  'link_path' => 'node/%/webform-results/analysis',
  'router_path' => 'node/%/webform-results/analysis',
  'link_title' => 'Analysis',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '3',
  'customized' => '0',
  'p1' => '4',
  'p2' => '116',
  'p3' => '120',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '121',
  'plid' => '116',
  'link_path' => 'node/%/webform-results/clear',
  'router_path' => 'node/%/webform-results/clear',
  'link_title' => 'Clear',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '8',
  'depth' => '3',
  'customized' => '0',
  'p1' => '4',
  'p2' => '116',
  'p3' => '121',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '122',
  'plid' => '118',
  'link_path' => 'node/%/webform/conditionals',
  'router_path' => 'node/%/webform/conditionals',
  'link_title' => 'Conditionals',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '3',
  'customized' => '0',
  'p1' => '4',
  'p2' => '118',
  'p3' => '122',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '123',
  'plid' => '116',
  'link_path' => 'node/%/webform-results/download',
  'router_path' => 'node/%/webform-results/download',
  'link_title' => 'Download',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '7',
  'depth' => '3',
  'customized' => '0',
  'p1' => '4',
  'p2' => '116',
  'p3' => '123',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '124',
  'plid' => '118',
  'link_path' => 'node/%/webform/emails',
  'router_path' => 'node/%/webform/emails',
  'link_title' => 'E-mails',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '4',
  'depth' => '3',
  'customized' => '0',
  'p1' => '4',
  'p2' => '118',
  'p3' => '124',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '125',
  'plid' => '118',
  'link_path' => 'node/%/webform/components',
  'router_path' => 'node/%/webform/components',
  'link_title' => 'Form components',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '4',
  'p2' => '118',
  'p3' => '125',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '126',
  'plid' => '118',
  'link_path' => 'node/%/webform/configure',
  'router_path' => 'node/%/webform/configure',
  'link_title' => 'Form settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '3',
  'customized' => '0',
  'p1' => '4',
  'p2' => '118',
  'p3' => '126',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '127',
  'plid' => '116',
  'link_path' => 'node/%/webform-results/submissions',
  'router_path' => 'node/%/webform-results/submissions',
  'link_title' => 'Submissions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '4',
  'depth' => '3',
  'customized' => '0',
  'p1' => '4',
  'p2' => '116',
  'p3' => '127',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '128',
  'plid' => '116',
  'link_path' => 'node/%/webform-results/table',
  'router_path' => 'node/%/webform-results/table',
  'link_title' => 'Table',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '6',
  'depth' => '3',
  'customized' => '0',
  'p1' => '4',
  'p2' => '116',
  'p3' => '128',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '129',
  'plid' => '25',
  'link_path' => 'admin/config/content/webform',
  'router_path' => 'admin/config/content/webform',
  'link_title' => 'Webform settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:46:"Global configuration of webform functionality.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '25',
  'p4' => '129',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '130',
  'plid' => '124',
  'link_path' => 'node/%/webform/emails/%',
  'router_path' => 'node/%/webform/emails/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '4',
  'p2' => '118',
  'p3' => '124',
  'p4' => '130',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '131',
  'plid' => '120',
  'link_path' => 'node/%/webform-results/analysis/%',
  'router_path' => 'node/%/webform-results/analysis/%',
  'link_title' => 'Analysis',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '4',
  'p2' => '116',
  'p3' => '120',
  'p4' => '131',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '132',
  'plid' => '4',
  'link_path' => 'node/%/submission/%/delete',
  'router_path' => 'node/%/submission/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '4',
  'p2' => '132',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '133',
  'plid' => '4',
  'link_path' => 'node/%/submission/%/edit',
  'router_path' => 'node/%/submission/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '2',
  'customized' => '0',
  'p1' => '4',
  'p2' => '133',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '134',
  'plid' => '125',
  'link_path' => 'node/%/webform/components/%',
  'router_path' => 'node/%/webform/components/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '4',
  'p2' => '118',
  'p3' => '125',
  'p4' => '134',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '135',
  'plid' => '4',
  'link_path' => 'node/%/submission/%/view',
  'router_path' => 'node/%/submission/%/view',
  'link_title' => 'View',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '4',
  'p2' => '135',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '136',
  'plid' => '131',
  'link_path' => 'node/%/webform-results/analysis/%/more',
  'router_path' => 'node/%/webform-results/analysis/%/more',
  'link_title' => 'In-depth analysis',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '4',
  'p2' => '116',
  'p3' => '120',
  'p4' => '131',
  'p5' => '136',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '137',
  'plid' => '130',
  'link_path' => 'node/%/webform/emails/%/delete',
  'router_path' => 'node/%/webform/emails/%/delete',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '4',
  'p2' => '118',
  'p3' => '124',
  'p4' => '130',
  'p5' => '137',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '138',
  'plid' => '130',
  'link_path' => 'node/%/webform/emails/%/clone',
  'router_path' => 'node/%/webform/emails/%/clone',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '4',
  'p2' => '118',
  'p3' => '124',
  'p4' => '130',
  'p5' => '138',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '139',
  'plid' => '134',
  'link_path' => 'node/%/webform/components/%/delete',
  'router_path' => 'node/%/webform/components/%/delete',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '4',
  'p2' => '118',
  'p3' => '125',
  'p4' => '134',
  'p5' => '139',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '140',
  'plid' => '134',
  'link_path' => 'node/%/webform/components/%/clone',
  'router_path' => 'node/%/webform/components/%/clone',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '4',
  'p2' => '118',
  'p3' => '125',
  'p4' => '134',
  'p5' => '140',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '141',
  'plid' => '5',
  'link_path' => 'node/add/webform-custom',
  'router_path' => 'node/add/webform-custom',
  'link_title' => 'Custom webform host node',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:34:"A custom content type for webforms";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '141',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '142',
  'plid' => '5',
  'link_path' => 'node/add/page',
  'router_path' => 'node/add/page',
  'link_title' => 'Basic page',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:49:"A simple content type without webform integration";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '142',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '143',
  'plid' => '16',
  'link_path' => 'admin/reports/fields',
  'router_path' => 'admin/reports/fields',
  'link_title' => 'Field list',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:39:"Overview of fields on all entity types.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '16',
  'p3' => '143',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '144',
  'plid' => '34',
  'link_path' => 'admin/config/media/image-styles',
  'router_path' => 'admin/config/media/image-styles',
  'link_title' => 'Image styles',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:78:"Configure styles that can be used for resizing or adjusting images on display.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '144',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '145',
  'plid' => '144',
  'link_path' => 'admin/config/media/image-styles/add',
  'router_path' => 'admin/config/media/image-styles/add',
  'link_title' => 'Add style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:22:"Add a new image style.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '144',
  'p5' => '145',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '146',
  'plid' => '144',
  'link_path' => 'admin/config/media/image-styles/list',
  'router_path' => 'admin/config/media/image-styles/list',
  'link_title' => 'List',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:42:"List the current image styles on the site.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '144',
  'p5' => '146',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '147',
  'plid' => '52',
  'link_path' => 'admin/config/people/accounts/display',
  'router_path' => 'admin/config/people/accounts/display',
  'link_title' => 'Manage display',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '52',
  'p5' => '147',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '148',
  'plid' => '52',
  'link_path' => 'admin/config/people/accounts/fields',
  'router_path' => 'admin/config/people/accounts/fields',
  'link_title' => 'Manage fields',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '52',
  'p5' => '148',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '149',
  'plid' => '147',
  'link_path' => 'admin/config/people/accounts/display/default',
  'router_path' => 'admin/config/people/accounts/display/default',
  'link_title' => 'Default',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '52',
  'p5' => '147',
  'p6' => '149',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '150',
  'plid' => '144',
  'link_path' => 'admin/config/media/image-styles/edit/%',
  'router_path' => 'admin/config/media/image-styles/edit/%',
  'link_title' => 'Edit style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:25:"Configure an image style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '144',
  'p5' => '150',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '151',
  'plid' => '85',
  'link_path' => 'admin/structure/types/manage/%/display',
  'router_path' => 'admin/structure/types/manage/%/display',
  'link_title' => 'Manage display',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '151',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '152',
  'plid' => '85',
  'link_path' => 'admin/structure/types/manage/%/fields',
  'router_path' => 'admin/structure/types/manage/%/fields',
  'link_title' => 'Manage fields',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '152',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '153',
  'plid' => '147',
  'link_path' => 'admin/config/people/accounts/display/full',
  'router_path' => 'admin/config/people/accounts/display/full',
  'link_title' => 'User account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '52',
  'p5' => '147',
  'p6' => '153',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '154',
  'plid' => '144',
  'link_path' => 'admin/config/media/image-styles/delete/%',
  'router_path' => 'admin/config/media/image-styles/delete/%',
  'link_title' => 'Delete style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:22:"Delete an image style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '144',
  'p5' => '154',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '155',
  'plid' => '144',
  'link_path' => 'admin/config/media/image-styles/revert/%',
  'router_path' => 'admin/config/media/image-styles/revert/%',
  'link_title' => 'Revert style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:22:"Revert an image style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '144',
  'p5' => '155',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '156',
  'plid' => '148',
  'link_path' => 'admin/config/people/accounts/fields/%',
  'router_path' => 'admin/config/people/accounts/fields/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '52',
  'p5' => '148',
  'p6' => '156',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '157',
  'plid' => '151',
  'link_path' => 'admin/structure/types/manage/%/display/default',
  'router_path' => 'admin/structure/types/manage/%/display/default',
  'link_title' => 'Default',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '151',
  'p6' => '157',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '158',
  'plid' => '151',
  'link_path' => 'admin/structure/types/manage/%/display/full',
  'router_path' => 'admin/structure/types/manage/%/display/full',
  'link_title' => 'Full content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '151',
  'p6' => '158',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '159',
  'plid' => '151',
  'link_path' => 'admin/structure/types/manage/%/display/rss',
  'router_path' => 'admin/structure/types/manage/%/display/rss',
  'link_title' => 'RSS',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '151',
  'p6' => '159',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '160',
  'plid' => '151',
  'link_path' => 'admin/structure/types/manage/%/display/teaser',
  'router_path' => 'admin/structure/types/manage/%/display/teaser',
  'link_title' => 'Teaser',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '151',
  'p6' => '160',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '161',
  'plid' => '152',
  'link_path' => 'admin/structure/types/manage/%/fields/%',
  'router_path' => 'admin/structure/types/manage/%/fields/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '152',
  'p6' => '161',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '162',
  'plid' => '156',
  'link_path' => 'admin/config/people/accounts/fields/%/delete',
  'router_path' => 'admin/config/people/accounts/fields/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '52',
  'p5' => '148',
  'p6' => '156',
  'p7' => '162',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '163',
  'plid' => '156',
  'link_path' => 'admin/config/people/accounts/fields/%/edit',
  'router_path' => 'admin/config/people/accounts/fields/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '52',
  'p5' => '148',
  'p6' => '156',
  'p7' => '163',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '164',
  'plid' => '156',
  'link_path' => 'admin/config/people/accounts/fields/%/field-settings',
  'router_path' => 'admin/config/people/accounts/fields/%/field-settings',
  'link_title' => 'Field settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '52',
  'p5' => '148',
  'p6' => '156',
  'p7' => '164',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '165',
  'plid' => '156',
  'link_path' => 'admin/config/people/accounts/fields/%/widget-type',
  'router_path' => 'admin/config/people/accounts/fields/%/widget-type',
  'link_title' => 'Widget type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '35',
  'p4' => '52',
  'p5' => '148',
  'p6' => '156',
  'p7' => '165',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '166',
  'plid' => '150',
  'link_path' => 'admin/config/media/image-styles/edit/%/add/%',
  'router_path' => 'admin/config/media/image-styles/edit/%/add/%',
  'link_title' => 'Add image effect',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:28:"Add a new effect to a style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '144',
  'p5' => '150',
  'p6' => '166',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '167',
  'plid' => '161',
  'link_path' => 'admin/structure/types/manage/%/fields/%/delete',
  'router_path' => 'admin/structure/types/manage/%/fields/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '152',
  'p6' => '161',
  'p7' => '167',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '168',
  'plid' => '161',
  'link_path' => 'admin/structure/types/manage/%/fields/%/edit',
  'router_path' => 'admin/structure/types/manage/%/fields/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '152',
  'p6' => '161',
  'p7' => '168',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '169',
  'plid' => '150',
  'link_path' => 'admin/config/media/image-styles/edit/%/effects/%',
  'router_path' => 'admin/config/media/image-styles/edit/%/effects/%',
  'link_title' => 'Edit image effect',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:39:"Edit an existing effect within a style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '144',
  'p5' => '150',
  'p6' => '169',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '170',
  'plid' => '161',
  'link_path' => 'admin/structure/types/manage/%/fields/%/field-settings',
  'router_path' => 'admin/structure/types/manage/%/fields/%/field-settings',
  'link_title' => 'Field settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '152',
  'p6' => '161',
  'p7' => '170',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '171',
  'plid' => '161',
  'link_path' => 'admin/structure/types/manage/%/fields/%/widget-type',
  'router_path' => 'admin/structure/types/manage/%/fields/%/widget-type',
  'link_title' => 'Widget type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '26',
  'p4' => '85',
  'p5' => '152',
  'p6' => '161',
  'p7' => '171',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '172',
  'plid' => '169',
  'link_path' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'router_path' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'link_title' => 'Delete image effect',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:39:"Delete an existing effect from a style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '34',
  'p4' => '144',
  'p5' => '150',
  'p6' => '169',
  'p7' => '172',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '173',
  'plid' => '83',
  'link_path' => 'admin/structure/block/list/bartik/add',
  'router_path' => 'admin/structure/block/list/bartik/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '22',
  'p4' => '83',
  'p5' => '173',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->execute();
$connection->schema()->createTable('menu_router', array(
  'fields' => array(
    'path' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'load_functions' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'to_arg_functions' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'access_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'access_arguments' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'page_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'page_arguments' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'delivery_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'fit' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'number_parts' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'context' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'tab_parent' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'tab_root' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title_arguments' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'theme_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'theme_arguments' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'position' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'include_file' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'medium',
    ),
  ),
  'primary key' => array(
    'path',
  ),
  'indexes' => array(
    'fit' => array(
      'fit',
    ),
    'tab_parent' => array(
      array(
        'tab_parent',
        '64',
      ),
      'weight',
      'title',
    ),
    'tab_root_weight_title' => array(
      array(
        'tab_root',
        '64',
      ),
      'weight',
      'title',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('menu_router')
->fields(array(
  'path',
  'load_functions',
  'to_arg_functions',
  'access_callback',
  'access_arguments',
  'page_callback',
  'page_arguments',
  'delivery_callback',
  'fit',
  'number_parts',
  'context',
  'tab_parent',
  'tab_root',
  'title',
  'title_callback',
  'title_arguments',
  'theme_callback',
  'theme_arguments',
  'type',
  'description',
  'position',
  'weight',
  'include_file',
))
->values(array(
  'path' => 'admin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin',
  'title' => 'Administration',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '9',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_themes_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance',
  'title' => 'Appearance',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Select and configure your themes.',
  'position' => 'left',
  'weight' => '-6',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/default',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_theme_default',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance/default',
  'title' => 'Set default theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/disable',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_theme_disable',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance/disable',
  'title' => 'Disable theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/enable',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_theme_enable',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance/enable',
  'title' => 'Enable theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_themes_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/appearance',
  'tab_root' => 'admin/appearance',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Select and configure your theme',
  'position' => '',
  'weight' => '-1',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"system_theme_settings";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/appearance',
  'tab_root' => 'admin/appearance',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Configure default and theme specific settings.',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/bartik',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:25:"themes/bartik/bartik.info";s:4:"name";s:6:"bartik";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:17:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:17:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1592419104;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Bartik',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:17:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:9:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1592419104;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:7:"garland";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/global',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"system_theme_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Global settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-1',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/seven',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:23:"themes/seven/seven.info";s:4:"name";s:5:"seven";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:17:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:5:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1592419104;}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:5:"seven";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Seven',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/stark',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => "a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:23:\"themes/stark/stark.info\";s:4:\"name\";s:5:\"stark\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:16:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.72\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1592419104\";s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:9:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1592419104;s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}",
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:5:"stark";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Stark',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/compact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_compact_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/compact',
  'title' => 'Compact mode',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_config_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config',
  'title' => 'Configuration',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Administer settings.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/content',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content',
  'title' => 'Content authoring',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Settings related to formatting and authoring content.',
  'position' => 'left',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"filter_admin_overview";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content/formats',
  'title' => 'Text formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats/%',
  'load_functions' => 'a:1:{i:4;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content/formats/%',
  'title' => '',
  'title_callback' => 'filter_admin_format_title',
  'title_arguments' => 'a:1:{i:0;i:4;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats/%/disable',
  'load_functions' => 'a:1:{i:4;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_filter_disable_format_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:20:"filter_admin_disable";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content/formats/%/disable',
  'title' => 'Disable text format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/content/formats',
  'tab_root' => 'admin/config/content/formats',
  'title' => 'Add text format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"filter_admin_overview";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/content/formats',
  'tab_root' => 'admin/config/content/formats',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/webform',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:22:"webform_admin_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content/webform',
  'title' => 'Webform settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Global configuration of webform functionality.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/webform/includes/webform.admin.inc',
))
->values(array(
  'path' => 'admin/config/development',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development',
  'title' => 'Development',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Development tools.',
  'position' => 'right',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/development/logging',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:23:"system_logging_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development/logging',
  'title' => 'Logging and errors',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Settings for logging and alerts modules. Various modules can route Drupal's system events to different destinations, such as syslog, database, email, etc.",
  'position' => '',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/development/maintenance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:28:"system_site_maintenance_mode";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development/maintenance',
  'title' => 'Maintenance mode',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Take the site offline for maintenance or bring it back online.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/development/performance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_performance_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development/performance',
  'title' => 'Performance',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/media',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media',
  'title' => 'Media',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Media tools.',
  'position' => 'left',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/file-system',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_file_system_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/file-system',
  'title' => 'File system',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Tell Drupal where to store uploaded files and how they are accessed.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'image_style_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles',
  'title' => 'Image styles',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure styles that can be used for resizing or adjusting images on display.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"image_style_add_form";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/media/image-styles',
  'tab_root' => 'admin/config/media/image-styles',
  'title' => 'Add style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => 'Add a new image style.',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/delete/%',
  'load_functions' => 'a:1:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;N;i:1;s:1:"1";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"image_style_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/delete/%',
  'title' => 'Delete style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Delete an image style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/edit/%',
  'load_functions' => 'a:1:{i:5;s:16:"image_style_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:16:"image_style_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%',
  'title' => 'Edit style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure an image style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/edit/%/add/%',
  'load_functions' => 'a:2:{i:5;a:1:{s:16:"image_style_load";a:1:{i:0;i:5;}}i:7;a:1:{s:28:"image_effect_definition_load";a:1:{i:0;i:5;}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:17:"image_effect_form";i:1;i:5;i:2;i:7;}',
  'delivery_callback' => '',
  'fit' => '250',
  'number_parts' => '8',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%/add/%',
  'title' => 'Add image effect',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Add a new effect to a style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/edit/%/effects/%',
  'load_functions' => 'a:2:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;i:5;i:1;s:1:"3";}}i:7;a:1:{s:17:"image_effect_load";a:2:{i:0;i:5;i:1;s:1:"3";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:17:"image_effect_form";i:1;i:5;i:2;i:7;}',
  'delivery_callback' => '',
  'fit' => '250',
  'number_parts' => '8',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%/effects/%',
  'title' => 'Edit image effect',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Edit an existing effect within a style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'load_functions' => 'a:2:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;i:5;i:1;s:1:"3";}}i:7;a:1:{s:17:"image_effect_load";a:2:{i:0;i:5;i:1;s:1:"3";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:24:"image_effect_delete_form";i:1;i:5;i:2;i:7;}',
  'delivery_callback' => '',
  'fit' => '501',
  'number_parts' => '9',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'title' => 'Delete image effect',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Delete an existing effect from a style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'image_style_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/media/image-styles',
  'tab_root' => 'admin/config/media/image-styles',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'List the current image styles on the site.',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/revert/%',
  'load_functions' => 'a:1:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;N;i:1;s:1:"2";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"image_style_revert_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/revert/%',
  'title' => 'Revert style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Revert an image style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-toolkit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:29:"system_image_toolkit_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-toolkit',
  'title' => 'Image toolkit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Choose which image toolkit to use if you have installed optional toolkits.',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/people',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people',
  'title' => 'People',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure user accounts.',
  'position' => 'left',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"user_admin_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Account settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure default behavior of users, including registration requirements, e-mails, fields, and user pictures.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"user";i:2;s:4:"user";i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Manage display',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/display/default',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:7:"default";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"user";i:2;s:4:"user";i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/display',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Default',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/display/full',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:4:"full";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"user";i:2;s:4:"user";i:3;s:4:"full";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/display',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'User account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:4:"user";i:2;s:4:"user";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => '',
  'title_callback' => 'field_ui_menu_title',
  'title_arguments' => 'a:1:{i:0;i:5;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%/delete',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%/edit',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%/field-settings',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Field settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%/widget-type',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Widget type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"user_admin_settings";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/ip-blocking',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"block IP addresses";}',
  'page_callback' => 'system_ip_blocking',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/ip-blocking',
  'title' => 'IP address blocking',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage blocked IP addresses.',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/ip-blocking/delete/%',
  'load_functions' => 'a:1:{i:5;s:15:"blocked_ip_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"block IP addresses";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"system_ip_blocking_delete";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/ip-blocking/delete/%',
  'title' => 'Delete IP address',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional',
  'title' => 'Regional and language',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Regional settings, localization and translation.',
  'position' => 'left',
  'weight' => '-5',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_date_time_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Date and time',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure display formats for date and time.',
  'position' => '',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_date_time_formats',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Configure display format strings for date and time.',
  'position' => '',
  'weight' => '-9',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats/%/delete',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:30:"system_date_delete_format_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/formats/%/delete',
  'title' => 'Delete date format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Allow users to delete a configured date format.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats/%/edit',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:34:"system_configure_date_formats_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/formats/%/edit',
  'title' => 'Edit date format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Allow users to edit a configured date format.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:34:"system_configure_date_formats_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time/formats',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Add format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => 'Allow users to add additional date formats.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats/lookup',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_date_time_lookup',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/formats/lookup',
  'title' => 'Date and time lookup',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/types',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_date_time_settings";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Types',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Configure display formats for date and time.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/types/%/delete',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:35:"system_delete_date_format_type_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/types/%/delete',
  'title' => 'Delete date type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Allow users to delete a configured date type.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/types/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"system_add_date_format_type_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time/types',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Add date type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => 'Add new date type.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_regional_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/settings',
  'title' => 'Regional settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Settings for the site's default time zone and country.",
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search',
  'title' => 'Search and metadata',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Local site search, metadata and SEO.',
  'position' => 'left',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/clean-urls',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_clean_url_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/clean-urls',
  'title' => 'Clean URLs',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Enable or disable clean URLs for your site.',
  'position' => '',
  'weight' => '5',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/clean-urls/check',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_json_output',
  'page_arguments' => 'a:1:{i:0;a:1:{s:6:"status";b:1;}}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/clean-urls/check',
  'title' => 'Clean URL check',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/services',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/services',
  'title' => 'Web services',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Tools related to web services.',
  'position' => 'right',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/services/rss-publishing',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_rss_feeds_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/services/rss-publishing',
  'title' => 'RSS publishing',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure the site description, the number of items per feed and whether feeds should be titles/teasers/full-text.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system',
  'title' => 'System',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'General system related configuration.',
  'position' => 'right',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_manage',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions',
  'title' => 'Actions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage the actions defined for your site.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_actions_configure";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions/configure',
  'title' => 'Configure an advanced action',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions/delete/%',
  'load_functions' => 'a:1:{i:5;s:12:"actions_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"system_actions_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions/delete/%',
  'title' => 'Delete action',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Delete an action.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions/manage',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_manage',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/system/actions',
  'tab_root' => 'admin/config/system/actions',
  'title' => 'Manage actions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Manage the actions defined for your site.',
  'position' => '',
  'weight' => '-2',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions/orphan',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_remove_orphans',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions/orphan',
  'title' => 'Remove orphans',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/cron',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"system_cron_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/cron',
  'title' => 'Cron',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage automatic site maintenance tasks.',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/site-information',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"system_site_information_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/site-information',
  'title' => 'Site information',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Change site name, e-mail address, slogan, default front page, and number of posts per page, error pages.',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface',
  'title' => 'User interface',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Tools that enhance the user interface.',
  'position' => 'right',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/workflow',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/workflow',
  'title' => 'Workflow',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Content workflow, editorial workflow tools.',
  'position' => 'right',
  'weight' => '5',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/content',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"access content overview";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"node_admin_content";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/content',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Find and manage content.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/content/node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"access content overview";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"node_admin_content";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/content',
  'tab_root' => 'admin/content',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/content/webform',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:26:"access all webform results";}',
  'page_callback' => 'webform_admin_content',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/content',
  'tab_root' => 'admin/content',
  'title' => 'Webforms',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'View and edit all the available webforms on your site.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/webform/includes/webform.admin.inc',
))
->values(array(
  'path' => 'admin/index',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_index',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'admin',
  'tab_root' => 'admin',
  'title' => 'Index',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '-18',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/modules',
  'title' => 'Modules',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Extend site functionality.',
  'position' => '',
  'weight' => '-2',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/modules',
  'tab_root' => 'admin/modules',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules/list/confirm',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/modules/list/confirm',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules/uninstall',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_modules_uninstall";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/modules',
  'tab_root' => 'admin/modules',
  'title' => 'Uninstall',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules/uninstall/confirm',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_modules_uninstall";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/modules/uninstall/confirm',
  'title' => 'Uninstall',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/people',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:4:"list";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/people',
  'title' => 'People',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage user accounts, roles, and permissions.',
  'position' => 'left',
  'weight' => '-4',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/create',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:6:"create";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/people',
  'tab_root' => 'admin/people',
  'title' => 'Add user',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/people',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:4:"list";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/people',
  'tab_root' => 'admin/people',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Find and manage people interacting with your site.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:22:"user_admin_permissions";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/people',
  'tab_root' => 'admin/people',
  'title' => 'Permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Determine access to features by selecting permissions for roles.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:22:"user_admin_permissions";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/people/permissions',
  'tab_root' => 'admin/people',
  'title' => 'Permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Determine access to features by selecting permissions for roles.',
  'position' => '',
  'weight' => '-8',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions/roles',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:16:"user_admin_roles";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/people/permissions',
  'tab_root' => 'admin/people',
  'title' => 'Roles',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'List, edit, or add user roles.',
  'position' => '',
  'weight' => '-5',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions/roles/delete/%',
  'load_functions' => 'a:1:{i:5;s:14:"user_role_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_role_edit_access',
  'access_arguments' => 'a:1:{i:0;i:5;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:30:"user_admin_role_delete_confirm";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/people/permissions/roles/delete/%',
  'title' => 'Delete role',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions/roles/edit/%',
  'load_functions' => 'a:1:{i:5;s:14:"user_role_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_role_edit_access',
  'access_arguments' => 'a:1:{i:0;i:5;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:15:"user_admin_role";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/people/permissions/roles/edit/%',
  'title' => 'Edit role',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/reports',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports',
  'title' => 'Reports',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'View reports, updates, and errors.',
  'position' => 'left',
  'weight' => '5',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/access-denied',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'dblog_top',
  'page_arguments' => 'a:1:{i:0;s:13:"access denied";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/access-denied',
  'title' => "Top 'access denied' errors",
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "View 'access denied' errors (403s).",
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/dblog/dblog.admin.inc',
))
->values(array(
  'path' => 'admin/reports/dblog',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'dblog_overview',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/dblog',
  'title' => 'Recent log messages',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'View events that have recently been logged.',
  'position' => '',
  'weight' => '-1',
  'include_file' => 'modules/dblog/dblog.admin.inc',
))
->values(array(
  'path' => 'admin/reports/event/%',
  'load_functions' => 'a:1:{i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'dblog_event',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'delivery_callback' => '',
  'fit' => '14',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/event/%',
  'title' => 'Details',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/dblog/dblog.admin.inc',
))
->values(array(
  'path' => 'admin/reports/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'field_ui_fields_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/fields',
  'title' => 'Field list',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Overview of fields on all entity types.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/reports/page-not-found',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'dblog_top',
  'page_arguments' => 'a:1:{i:0;s:14:"page not found";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/page-not-found',
  'title' => "Top 'page not found' errors",
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "View 'page not found' errors (404s).",
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/dblog/dblog.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_status',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status',
  'title' => 'Status report',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Get a status report about your site's operation and any detected problems.",
  'position' => '',
  'weight' => '-60',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/php',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_php',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/php',
  'title' => 'PHP',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/rebuild',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"node_configure_rebuild_confirm";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/rebuild',
  'title' => 'Rebuild permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/run-cron',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_run_cron',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/run-cron',
  'title' => 'Run cron',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/structure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure',
  'title' => 'Structure',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Administer blocks, content types, menus, etc.',
  'position' => 'right',
  'weight' => '-8',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block',
  'title' => 'Blocks',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Configure what block content appears in your site's sidebars and other regions.",
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/demo/bartik',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:25:"themes/bartik/bartik.info";s:4:"name";s:6:"bartik";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:17:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:17:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1592419104;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/bartik',
  'title' => 'Bartik',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/demo/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:17:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:9:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1592419104;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/garland',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/demo/seven',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:23:"themes/seven/seven.info";s:4:"name";s:5:"seven";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:17:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:5:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1592419104;}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:5:"seven";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/seven',
  'title' => 'Seven',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:5:"seven";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/demo/stark',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => "a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:23:\"themes/stark/stark.info\";s:4:\"name\";s:5:\"stark\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:16:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.72\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1592419104\";s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:9:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1592419104;s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}",
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:5:"stark";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/stark',
  'title' => 'Stark',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:5:"stark";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/bartik',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:25:"themes/bartik/bartik.info";s:4:"name";s:6:"bartik";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:17:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:17:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1592419104;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Bartik',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/bartik/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/block/list/bartik',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:17:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:9:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1592419104;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/seven',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:23:"themes/seven/seven.info";s:4:"name";s:5:"seven";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:17:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:5:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1592419104;}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:5:"seven";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Seven',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/seven/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/block/list/seven',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/stark',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => "a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:23:\"themes/stark/stark.info\";s:4:\"name\";s:5:\"stark\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:16:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.72\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1592419104\";s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:9:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1592419104;s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}",
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:5:"stark";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Stark',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/stark/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/block/list/stark',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/manage/%/%',
  'load_functions' => 'a:2:{i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:21:"block_admin_configure";i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '60',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/manage/%/%',
  'title' => 'Configure block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/manage/%/%/configure',
  'load_functions' => 'a:2:{i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:21:"block_admin_configure";i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '121',
  'number_parts' => '7',
  'context' => '2',
  'tab_parent' => 'admin/structure/block/manage/%/%',
  'tab_root' => 'admin/structure/block/manage/%/%',
  'title' => 'Configure block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/manage/%/%/delete',
  'load_functions' => 'a:2:{i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"block_custom_block_delete";i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '121',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => 'admin/structure/block/manage/%/%',
  'tab_root' => 'admin/structure/block/manage/%/%',
  'title' => 'Delete block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'node_overview_types',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types',
  'title' => 'Content types',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage content types, including default status, front page promotion, comment settings, etc.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"node_type_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/types',
  'tab_root' => 'admin/structure/types',
  'title' => 'Add content type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'node_overview_types',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/types',
  'tab_root' => 'admin/structure/types',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Edit content type',
  'title_callback' => 'node_type_page_title',
  'title_arguments' => 'a:1:{i:0;i:4;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/delete',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Manage display',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/default',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:7:"default";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Default',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/full',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:4:"full";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:4:"full";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Full content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/rss',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:3:"rss";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:3:"rss";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/teaser',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:6:"teaser";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:6:"teaser";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Teaser',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/edit',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:4:"node";i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '122',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => '',
  'title_callback' => 'field_ui_menu_title',
  'title_arguments' => 'a:1:{i:0;i:6;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%/delete',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%/edit',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%/field-settings',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Field settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%/widget-type',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Widget type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/tasks',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'admin',
  'tab_root' => 'admin',
  'title' => 'Tasks',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/views/ajax/autocomplete/taxonomy',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'views_ajax_autocomplete_taxonomy',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/views/ajax/autocomplete/taxonomy',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/views/includes/ajax.inc',
))
->values(array(
  'path' => 'admin/views/ajax/autocomplete/user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"access user profiles";}',
  'page_callback' => 'views_ajax_autocomplete_user',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/views/ajax/autocomplete/user',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/views/includes/ajax.inc',
))
->values(array(
  'path' => 'batch',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'system_batch_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'batch',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_system_batch_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'ctools/autocomplete/%',
  'load_functions' => 'a:1:{i:2;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_content_autocomplete_entity',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '6',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/autocomplete/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/ctools/includes/content.menu.inc',
))
->values(array(
  'path' => 'ctools/context/ajax/access/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_access_ajax_add',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/access/add',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/ctools/includes/context-access-admin.inc',
))
->values(array(
  'path' => 'ctools/context/ajax/access/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_access_ajax_edit',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/access/configure',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/ctools/includes/context-access-admin.inc',
))
->values(array(
  'path' => 'ctools/context/ajax/access/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_access_ajax_delete',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/access/delete',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/ctools/includes/context-access-admin.inc',
))
->values(array(
  'path' => 'ctools/context/ajax/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_context_ajax_item_add',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/add',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/ctools/includes/context-admin.inc',
))
->values(array(
  'path' => 'ctools/context/ajax/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_context_ajax_item_edit',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/configure',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/ctools/includes/context-admin.inc',
))
->values(array(
  'path' => 'ctools/context/ajax/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_context_ajax_item_delete',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/delete',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/ctools/includes/context-admin.inc',
))
->values(array(
  'path' => 'file/ajax',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'file_ajax_upload',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => 'ajax_deliver',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'file/ajax',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'file/progress',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'file_ajax_progress',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'file/progress',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'filter/tips',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'filter_tips_long',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'filter/tips',
  'title' => 'Compose tips',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '20',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.pages.inc',
))
->values(array(
  'path' => 'filter/tips/%',
  'load_functions' => 'a:1:{i:2;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'filter_access',
  'access_arguments' => 'a:1:{i:0;i:2;}',
  'page_callback' => 'filter_tips_long',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '6',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'filter/tips/%',
  'title' => 'Compose tips',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.pages.inc',
))
->values(array(
  'path' => 'node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'node_page_default',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'node/%',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:1;}',
  'page_callback' => 'node_page_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '2',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%',
  'title' => '',
  'title_callback' => 'node_page_title',
  'title_arguments' => 'a:1:{i:0;i:1;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'node/%/delete',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"delete";i:1;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:19:"node_delete_confirm";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '2',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/done',
  'load_functions' => 'a:1:{i:1;s:17:"webform_menu_load";}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_confirmation_page_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => '_webform_confirmation',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/done',
  'title' => 'Webform confirmation',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'node/%/edit',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"update";i:1;i:1;}',
  'page_callback' => 'node_page_edit',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'node_revision_overview',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Revisions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/delete',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:6:"delete";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"node_revision_delete_confirm";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/delete',
  'title' => 'Delete earlier revision',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/revert',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:6:"update";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"node_revision_revert_confirm";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/revert',
  'title' => 'Revert to earlier revision',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/view',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'node_show',
  'page_arguments' => 'a:2:{i:0;i:1;i:1;b:1;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/view',
  'title' => 'Revisions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'node/%/submission/%',
  'load_functions' => 'a:2:{i:1;a:1:{s:17:"webform_menu_load";a:1:{i:0;i:1;}}i:3;a:1:{s:28:"webform_menu_submission_load";a:1:{i:0;i:1;}}}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_submission_access',
  'access_arguments' => 'a:3:{i:0;i:1;i:1;i:3;i:2;s:4:"view";}',
  'page_callback' => 'webform_submission_page',
  'page_arguments' => 'a:3:{i:0;i:1;i:1;i:3;i:2;s:4:"html";}',
  'delivery_callback' => '',
  'fit' => '10',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/submission/%',
  'title' => 'Webform submission',
  'title_callback' => 'webform_submission_title',
  'title_arguments' => 'a:2:{i:0;i:1;i:1;i:3;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/webform/includes/webform.submissions.inc',
))
->values(array(
  'path' => 'node/%/submission/%/delete',
  'load_functions' => 'a:2:{i:1;a:1:{s:17:"webform_menu_load";a:1:{i:0;i:1;}}i:3;a:1:{s:28:"webform_menu_submission_load";a:1:{i:0;i:1;}}}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_submission_access',
  'access_arguments' => 'a:3:{i:0;i:1;i:1;i:3;i:2;s:6:"delete";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:30:"webform_submission_delete_form";i:1;i:1;i:2;i:3;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'node/%/submission/%',
  'tab_root' => 'node/%/submission/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'sites/all/modules/webform/includes/webform.submissions.inc',
))
->values(array(
  'path' => 'node/%/submission/%/edit',
  'load_functions' => 'a:2:{i:1;a:1:{s:17:"webform_menu_load";a:1:{i:0;i:1;}}i:3;a:1:{s:28:"webform_menu_submission_load";a:1:{i:0;i:1;}}}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_submission_access',
  'access_arguments' => 'a:3:{i:0;i:1;i:1;i:3;i:2;s:4:"edit";}',
  'page_callback' => 'webform_submission_page',
  'page_arguments' => 'a:3:{i:0;i:1;i:1;i:3;i:2;s:4:"form";}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'node/%/submission/%',
  'tab_root' => 'node/%/submission/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'sites/all/modules/webform/includes/webform.submissions.inc',
))
->values(array(
  'path' => 'node/%/submission/%/resend',
  'load_functions' => 'a:2:{i:1;a:1:{s:17:"webform_menu_load";a:1:{i:0;i:1;}}i:3;a:1:{s:28:"webform_menu_submission_load";a:1:{i:0;i:1;}}}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_results_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"webform_submission_resend";i:1;i:1;i:2;i:3;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/submission/%/resend',
  'title' => 'Resend e-mails',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/webform/includes/webform.submissions.inc',
))
->values(array(
  'path' => 'node/%/submission/%/view',
  'load_functions' => 'a:2:{i:1;a:1:{s:17:"webform_menu_load";a:1:{i:0;i:1;}}i:3;a:1:{s:28:"webform_menu_submission_load";a:1:{i:0;i:1;}}}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_submission_access',
  'access_arguments' => 'a:3:{i:0;i:1;i:1;i:3;i:2;s:4:"view";}',
  'page_callback' => 'webform_submission_page',
  'page_arguments' => 'a:3:{i:0;i:1;i:1;i:3;i:2;s:4:"html";}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'node/%/submission/%',
  'tab_root' => 'node/%/submission/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/webform/includes/webform.submissions.inc',
))
->values(array(
  'path' => 'node/%/submissions',
  'load_functions' => 'a:1:{i:1;s:17:"webform_menu_load";}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_submission_access',
  'access_arguments' => 'a:3:{i:0;i:1;i:1;N;i:2;s:4:"list";}',
  'page_callback' => 'webform_results_submissions',
  'page_arguments' => 'a:3:{i:0;i:1;i:1;b:1;i:2;s:2:"50";}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/submissions',
  'title' => 'Submissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/webform/includes/webform.report.inc',
))
->values(array(
  'path' => 'node/%/view',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:1;}',
  'page_callback' => 'node_page_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => '',
))
->values(array(
  'path' => 'node/%/webform',
  'load_functions' => 'a:1:{i:1;s:17:"webform_menu_load";}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_node_update_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'webform_components_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Webform',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'sites/all/modules/webform/includes/webform.components.inc',
))
->values(array(
  'path' => 'node/%/webform-results',
  'load_functions' => 'a:1:{i:1;s:17:"webform_menu_load";}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_results_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'webform_results_submissions',
  'page_arguments' => 'a:3:{i:0;i:1;i:1;b:0;i:2;s:2:"50";}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Results',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'sites/all/modules/webform/includes/webform.report.inc',
))
->values(array(
  'path' => 'node/%/webform-results/analysis',
  'load_functions' => 'a:1:{i:1;s:17:"webform_menu_load";}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_results_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'webform_results_analysis',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '11',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'node/%/webform-results',
  'tab_root' => 'node/%',
  'title' => 'Analysis',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '5',
  'include_file' => 'sites/all/modules/webform/includes/webform.report.inc',
))
->values(array(
  'path' => 'node/%/webform-results/analysis/%',
  'load_functions' => 'a:2:{i:1;a:1:{s:17:"webform_menu_load";a:2:{i:0;i:1;i:1;i:4;}}i:4;a:1:{s:27:"webform_menu_component_load";a:2:{i:0;i:1;i:1;i:4;}}}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_results_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'webform_results_analysis',
  'page_arguments' => 'a:3:{i:0;i:1;i:1;a:0:{}i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '22',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'node/%/webform-results/analysis',
  'tab_root' => 'node/%',
  'title' => 'Analysis',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/webform/includes/webform.report.inc',
))
->values(array(
  'path' => 'node/%/webform-results/analysis/%/more',
  'load_functions' => 'a:2:{i:1;a:1:{s:17:"webform_menu_load";a:2:{i:0;i:1;i:1;i:4;}}i:4;a:1:{s:27:"webform_menu_component_load";a:2:{i:0;i:1;i:1;i:4;}}}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_results_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'webform_results_analysis',
  'page_arguments' => 'a:3:{i:0;i:1;i:1;a:0:{}i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '45',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'node/%/webform-results/analysis/%',
  'tab_root' => 'node/%',
  'title' => 'In-depth analysis',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/webform/includes/webform.report.inc',
))
->values(array(
  'path' => 'node/%/webform-results/clear',
  'load_functions' => 'a:1:{i:1;s:17:"webform_menu_load";}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_results_clear_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"webform_results_clear_form";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '11',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'node/%/webform-results',
  'tab_root' => 'node/%',
  'title' => 'Clear',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '8',
  'include_file' => 'sites/all/modules/webform/includes/webform.report.inc',
))
->values(array(
  'path' => 'node/%/webform-results/download',
  'load_functions' => 'a:1:{i:1;s:17:"webform_menu_load";}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_results_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"webform_results_download_form";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '11',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'node/%/webform-results',
  'tab_root' => 'node/%',
  'title' => 'Download',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '7',
  'include_file' => 'sites/all/modules/webform/includes/webform.report.inc',
))
->values(array(
  'path' => 'node/%/webform-results/download-file',
  'load_functions' => 'a:1:{i:1;s:17:"webform_menu_load";}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_results_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'webform_results_download_callback',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '11',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/webform-results/download-file',
  'title' => 'Download',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/webform/includes/webform.report.inc',
))
->values(array(
  'path' => 'node/%/webform-results/submissions',
  'load_functions' => 'a:1:{i:1;s:17:"webform_menu_load";}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_results_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'webform_results_submissions',
  'page_arguments' => 'a:3:{i:0;i:1;i:1;b:0;i:2;s:2:"50";}',
  'delivery_callback' => '',
  'fit' => '11',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'node/%/webform-results',
  'tab_root' => 'node/%',
  'title' => 'Submissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '4',
  'include_file' => 'sites/all/modules/webform/includes/webform.report.inc',
))
->values(array(
  'path' => 'node/%/webform-results/table',
  'load_functions' => 'a:1:{i:1;s:17:"webform_menu_load";}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_results_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'webform_results_table',
  'page_arguments' => 'a:2:{i:0;i:1;i:1;s:2:"50";}',
  'delivery_callback' => '',
  'fit' => '11',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'node/%/webform-results',
  'tab_root' => 'node/%',
  'title' => 'Table',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '6',
  'include_file' => 'sites/all/modules/webform/includes/webform.report.inc',
))
->values(array(
  'path' => 'node/%/webform/components',
  'load_functions' => 'a:1:{i:1;s:17:"webform_menu_load";}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_node_update_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'webform_components_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '11',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'node/%/webform',
  'tab_root' => 'node/%',
  'title' => 'Form components',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/webform/includes/webform.components.inc',
))
->values(array(
  'path' => 'node/%/webform/components/%',
  'load_functions' => 'a:2:{i:1;a:1:{s:17:"webform_menu_load";a:2:{i:0;i:1;i:1;i:5;}}i:4;a:1:{s:27:"webform_menu_component_load";a:2:{i:0;i:1;i:1;i:5;}}}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_node_update_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:27:"webform_component_edit_form";i:1;i:1;i:2;i:4;i:3;b:0;}',
  'delivery_callback' => '',
  'fit' => '22',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'node/%/webform/components',
  'tab_root' => 'node/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/webform/includes/webform.components.inc',
))
->values(array(
  'path' => 'node/%/webform/components/%/clone',
  'load_functions' => 'a:2:{i:1;a:1:{s:17:"webform_menu_load";a:2:{i:0;i:1;i:1;i:5;}}i:4;a:1:{s:27:"webform_menu_component_load";a:2:{i:0;i:1;i:1;i:5;}}}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_node_update_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:27:"webform_component_edit_form";i:1;i:1;i:2;i:4;i:3;b:1;}',
  'delivery_callback' => '',
  'fit' => '45',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'node/%/webform/components/%',
  'tab_root' => 'node/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/webform/includes/webform.components.inc',
))
->values(array(
  'path' => 'node/%/webform/components/%/delete',
  'load_functions' => 'a:2:{i:1;a:1:{s:17:"webform_menu_load";a:2:{i:0;i:1;i:1;i:5;}}i:4;a:1:{s:27:"webform_menu_component_load";a:2:{i:0;i:1;i:1;i:5;}}}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_node_update_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"webform_component_delete_form";i:1;i:1;i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '45',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'node/%/webform/components/%',
  'tab_root' => 'node/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/webform/includes/webform.components.inc',
))
->values(array(
  'path' => 'node/%/webform/conditionals',
  'load_functions' => 'a:1:{i:1;s:17:"webform_menu_load";}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_node_update_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"webform_conditionals_form";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '11',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'node/%/webform',
  'tab_root' => 'node/%',
  'title' => 'Conditionals',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'sites/all/modules/webform/includes/webform.conditionals.inc',
))
->values(array(
  'path' => 'node/%/webform/configure',
  'load_functions' => 'a:1:{i:1;s:17:"webform_menu_load";}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_node_update_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:22:"webform_configure_form";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '11',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'node/%/webform',
  'tab_root' => 'node/%',
  'title' => 'Form settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '5',
  'include_file' => 'sites/all/modules/webform/includes/webform.pages.inc',
))
->values(array(
  'path' => 'node/%/webform/emails',
  'load_functions' => 'a:1:{i:1;s:17:"webform_menu_load";}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_node_update_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:19:"webform_emails_form";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '11',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'node/%/webform',
  'tab_root' => 'node/%',
  'title' => 'E-mails',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '4',
  'include_file' => 'sites/all/modules/webform/includes/webform.emails.inc',
))
->values(array(
  'path' => 'node/%/webform/emails/%',
  'load_functions' => 'a:2:{i:1;a:1:{s:17:"webform_menu_load";a:1:{i:0;i:1;}}i:4;a:1:{s:23:"webform_menu_email_load";a:1:{i:0;i:1;}}}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_node_update_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"webform_email_edit_form";i:1;i:1;i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '22',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'node/%/webform/emails',
  'tab_root' => 'node/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/webform/includes/webform.emails.inc',
))
->values(array(
  'path' => 'node/%/webform/emails/%/clone',
  'load_functions' => 'a:2:{i:1;a:1:{s:17:"webform_menu_load";a:1:{i:0;i:1;}}i:4;a:1:{s:23:"webform_menu_email_load";a:1:{i:0;i:1;}}}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_node_update_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:23:"webform_email_edit_form";i:1;i:1;i:2;i:4;i:3;b:1;}',
  'delivery_callback' => '',
  'fit' => '45',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'node/%/webform/emails/%',
  'tab_root' => 'node/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/webform/includes/webform.emails.inc',
))
->values(array(
  'path' => 'node/%/webform/emails/%/delete',
  'load_functions' => 'a:2:{i:1;a:1:{s:17:"webform_menu_load";a:1:{i:0;i:1;}}i:4;a:1:{s:23:"webform_menu_email_load";a:1:{i:0;i:1;}}}',
  'to_arg_functions' => 'a:1:{i:1;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_node_update_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"webform_email_delete_form";i:1;i:1;i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '45',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'node/%/webform/emails/%',
  'tab_root' => 'node/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/webform/includes/webform.emails.inc',
))
->values(array(
  'path' => 'node/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_node_add_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'node_add_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add',
  'title' => 'Add content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/page',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:4:"page";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;s:4:"page";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add/page',
  'title' => 'Basic page',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'A simple content type without webform integration',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/webform',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:7:"webform";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;s:7:"webform";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add/webform',
  'title' => 'Webform',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Create a new form or questionnaire accessible to users. Submission results and statistics are recorded and accessible to privileged users.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/webform-custom',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:14:"webform_custom";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;s:14:"webform_custom";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add/webform-custom',
  'title' => 'Custom webform host node',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'A custom content type for webforms',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'rss.xml',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'node_feed',
  'page_arguments' => 'a:2:{i:0;b:0;i:1;a:0:{}}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'rss.xml',
  'title' => 'RSS feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'sites/default/files/styles/%',
  'load_functions' => 'a:1:{i:4;s:16:"image_style_load";}',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'image_style_deliver',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'sites/default/files/styles/%',
  'title' => 'Generate image style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'system/ajax',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'ajax_form_callback',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => 'ajax_deliver',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/ajax',
  'title' => 'AHAH callback',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'includes/form.inc',
))
->values(array(
  'path' => 'system/files',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'file_download',
  'page_arguments' => 'a:1:{i:0;s:7:"private";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/files',
  'title' => 'File download',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'system/files/styles/%',
  'load_functions' => 'a:1:{i:3;s:16:"image_style_load";}',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'image_style_deliver',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'delivery_callback' => '',
  'fit' => '14',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/files/styles/%',
  'title' => 'Generate image style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'system/temporary',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'file_download',
  'page_arguments' => 'a:1:{i:0;s:9:"temporary";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/temporary',
  'title' => 'Temporary files',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'system/timezone',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'system_timezone',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/timezone',
  'title' => 'Time zone',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user',
  'title' => 'User account',
  'title_callback' => 'user_menu_title',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_view_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_view_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '2',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/%',
  'title' => 'My account',
  'title_callback' => 'user_page_title',
  'title_arguments' => 'a:1:{i:0;i:1;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'user/%/cancel',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_cancel_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"user_cancel_confirm_form";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/%/cancel',
  'title' => 'Cancel account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/cancel/confirm/%/%',
  'load_functions' => 'a:3:{i:1;s:9:"user_load";i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_cancel_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_cancel_confirm',
  'page_arguments' => 'a:3:{i:0;i:1;i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '44',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/%/cancel/confirm/%/%',
  'title' => 'Confirm account cancellation',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/edit',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_edit_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/edit/account',
  'load_functions' => 'a:1:{i:1;a:1:{s:18:"user_category_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_edit_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '11',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'user/%/edit',
  'tab_root' => 'user/%',
  'title' => 'Account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/view',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_view_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_view_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => '',
))
->values(array(
  'path' => 'user/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"access user profiles";}',
  'page_callback' => 'user_autocomplete',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/autocomplete',
  'title' => 'User autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/login',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_anonymous',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Log in',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/logout',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_logged_in',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_logout',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/logout',
  'title' => 'Log out',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/password',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:9:"user_pass";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Request new password',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/register',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_register_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"user_register_form";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Create new account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'user/reset/%/%/%',
  'load_functions' => 'a:3:{i:2;N;i:3;N;i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:15:"user_pass_reset";i:1;i:2;i:2;i:3;i:3;i:4;}',
  'delivery_callback' => '',
  'fit' => '24',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/reset/%/%/%',
  'title' => 'Reset password',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'views/ajax',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'views_ajax',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => 'ajax_deliver',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'views/ajax',
  'title' => 'Views',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => 'Ajax callback for view loading.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/views/includes/ajax.inc',
))
->values(array(
  'path' => 'webform/ajax/options/%',
  'load_functions' => 'a:1:{i:3;a:1:{s:17:"webform_menu_load";a:1:{i:0;i:3;}}}',
  'to_arg_functions' => 'a:1:{i:3;s:19:"webform_menu_to_arg";}',
  'access_callback' => 'webform_node_update_access',
  'access_arguments' => 'a:1:{i:0;i:3;}',
  'page_callback' => 'webform_select_options_ajax',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '14',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'webform/ajax/options/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/webform/components/select.inc',
))
->values(array(
  'path' => 'webform/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer views";}',
  'page_callback' => 'webform_views_autocomplete',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'webform/autocomplete',
  'title' => 'Webforms',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/webform/views/webform.views.inc',
))
->execute();
$connection->schema()->createTable('node', array(
  'fields' => array(
    'nid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'comment' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'promote' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'sticky' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'tnid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'translate' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'unique keys' => array(
    'vid' => array(
      'vid',
    ),
  ),
  'indexes' => array(
    'node_changed' => array(
      'changed',
    ),
    'node_created' => array(
      'created',
    ),
    'node_frontpage' => array(
      'promote',
      'status',
      'sticky',
      'created',
    ),
    'node_status_type' => array(
      'status',
      'type',
      'nid',
    ),
    'node_title_type' => array(
      'title',
      array(
        'type',
        '4',
      ),
    ),
    'node_type' => array(
      array(
        'type',
        '4',
      ),
    ),
    'uid' => array(
      'uid',
    ),
    'tnid' => array(
      'tnid',
    ),
    'translate' => array(
      'translate',
    ),
    'language' => array(
      'language',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node')
->fields(array(
  'nid',
  'vid',
  'type',
  'language',
  'title',
  'uid',
  'status',
  'created',
  'changed',
  'comment',
  'promote',
  'sticky',
  'tnid',
  'translate',
))
->values(array(
  'nid' => '1',
  'vid' => '1',
  'type' => 'page',
  'language' => 'und',
  'title' => 'Basic Page Content #1',
  'uid' => '2',
  'status' => '1',
  'created' => '1600260167',
  'changed' => '1600260167',
  'comment' => '0',
  'promote' => '1',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '2',
  'vid' => '2',
  'type' => 'page',
  'language' => 'und',
  'title' => 'Basic Page Content #2',
  'uid' => '2',
  'status' => '1',
  'created' => '1600260211',
  'changed' => '1600260211',
  'comment' => '0',
  'promote' => '1',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '3',
  'vid' => '3',
  'type' => 'webform_custom',
  'language' => 'und',
  'title' => 'A Webform host node with "webform_custom" type',
  'uid' => '2',
  'status' => '1',
  'created' => '1600260281',
  'changed' => '1600263716',
  'comment' => '0',
  'promote' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '4',
  'vid' => '4',
  'type' => 'webform',
  'language' => 'und',
  'title' => 'A Webform host node with the default "webform" type',
  'uid' => '1',
  'status' => '1',
  'created' => '1600266781',
  'changed' => '1600328877',
  'comment' => '0',
  'promote' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '5',
  'vid' => '5',
  'type' => 'webform',
  'language' => 'und',
  'title' => 'Coffee Questionnaire',
  'uid' => '2',
  'status' => '1',
  'created' => '1600325860',
  'changed' => '1600328901',
  'comment' => '0',
  'promote' => '1',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->execute();
$connection->schema()->createTable('node_access', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'gid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'realm' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'grant_view' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'grant_update' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'grant_delete' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'nid',
    'gid',
    'realm',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_access')
->fields(array(
  'nid',
  'gid',
  'realm',
  'grant_view',
  'grant_update',
  'grant_delete',
))
->values(array(
  'nid' => '0',
  'gid' => '0',
  'realm' => 'all',
  'grant_view' => '1',
  'grant_update' => '0',
  'grant_delete' => '0',
))
->execute();
$connection->schema()->createTable('node_revision', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'log' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
    'comment' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'promote' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'sticky' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
    'uid' => array(
      'uid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_revision')
->fields(array(
  'nid',
  'vid',
  'uid',
  'title',
  'log',
  'timestamp',
  'status',
  'comment',
  'promote',
  'sticky',
))
->values(array(
  'nid' => '1',
  'vid' => '1',
  'uid' => '2',
  'title' => 'Basic Page Content #1',
  'log' => '',
  'timestamp' => '1600260167',
  'status' => '1',
  'comment' => '0',
  'promote' => '1',
  'sticky' => '0',
))
->values(array(
  'nid' => '2',
  'vid' => '2',
  'uid' => '2',
  'title' => 'Basic Page Content #2',
  'log' => '',
  'timestamp' => '1600260211',
  'status' => '1',
  'comment' => '0',
  'promote' => '1',
  'sticky' => '0',
))
->values(array(
  'nid' => '3',
  'vid' => '3',
  'uid' => '2',
  'title' => 'A Webform host node with "webform_custom" type',
  'log' => '',
  'timestamp' => '1600263716',
  'status' => '1',
  'comment' => '0',
  'promote' => '0',
  'sticky' => '0',
))
->values(array(
  'nid' => '4',
  'vid' => '4',
  'uid' => '1',
  'title' => 'A Webform host node with the default "webform" type',
  'log' => '',
  'timestamp' => '1600328877',
  'status' => '1',
  'comment' => '0',
  'promote' => '0',
  'sticky' => '0',
))
->values(array(
  'nid' => '5',
  'vid' => '5',
  'uid' => '1',
  'title' => 'Coffee Questionnaire',
  'log' => '',
  'timestamp' => '1600328901',
  'status' => '1',
  'comment' => '0',
  'promote' => '1',
  'sticky' => '0',
))
->execute();
$connection->schema()->createTable('node_type', array(
  'fields' => array(
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'base' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'medium',
    ),
    'help' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'medium',
    ),
    'has_title' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'unsigned' => TRUE,
    ),
    'title_label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'custom' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'modified' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'disabled' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'orig_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'type',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_type')
->fields(array(
  'type',
  'name',
  'base',
  'module',
  'description',
  'help',
  'has_title',
  'title_label',
  'custom',
  'modified',
  'locked',
  'disabled',
  'orig_type',
))
->values(array(
  'type' => 'page',
  'name' => 'Basic page',
  'base' => 'node_content',
  'module' => 'node',
  'description' => 'A simple content type without webform integration',
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'disabled' => '0',
  'orig_type' => 'page',
))
->values(array(
  'type' => 'webform',
  'name' => 'Webform',
  'base' => 'node_content',
  'module' => 'node',
  'description' => 'Create a new form or questionnaire accessible to users. Submission results and statistics are recorded and accessible to privileged users.',
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'disabled' => '0',
  'orig_type' => 'webform',
))
->values(array(
  'type' => 'webform_custom',
  'name' => 'Custom webform host node',
  'base' => 'node_content',
  'module' => 'node',
  'description' => 'A custom content type for webforms',
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'disabled' => '0',
  'orig_type' => 'webform_custom',
))
->execute();
$connection->schema()->createTable('queue', array(
  'fields' => array(
    'item_id' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'item_id',
  ),
  'indexes' => array(
    'name_created' => array(
      'name',
      'created',
    ),
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('registry', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '9',
      'default' => '',
    ),
    'filename' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'name',
    'type',
  ),
  'indexes' => array(
    'hook' => array(
      'type',
      'weight',
      'module',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('registry')
->fields(array(
  'name',
  'type',
  'filename',
  'module',
  'weight',
))
->values(array(
  'name' => 'AccessDeniedTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'AdminMetaTagTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ArchiverInterface',
  'type' => 'interface',
  'filename' => 'includes/archiver.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'ArchiverTar',
  'type' => 'class',
  'filename' => 'modules/system/system.archiver.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ArchiverZip',
  'type' => 'class',
  'filename' => 'modules/system/system.archiver.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'Archive_Tar',
  'type' => 'class',
  'filename' => 'modules/system/system.tar.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'BatchMemoryQueue',
  'type' => 'class',
  'filename' => 'includes/batch.queue.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'BatchQueue',
  'type' => 'class',
  'filename' => 'includes/batch.queue.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockAdminThemeTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockCacheTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockHashTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockHiddenRegionTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockHTMLIdTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockInvalidRegionTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockTemplateSuggestionsUnitTest',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockViewModuleDeltaAlterWebTest',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'ConfirmFormTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'CronQueueTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'CronRunTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsContextIDTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/context.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsContextKeywordsSubstitutionTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/context.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsContextUnitTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/context.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CToolsCssCache',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/includes/css-cache.inc',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsCSSObjectCache',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/css_cache.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsCssTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/css.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsMathExpressionStackTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/math_expression_stack.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsMathExpressionTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/math_expression.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsModuleTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/ctools.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsObjectCache',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/object_cache.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsPageTokens',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/page_tokens.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsPluginsGetInfoTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/ctools.plugins.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsUnitObjectCachePlugins',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/tests/object_cache_unit.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'ctools_context',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/includes/context.inc',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'ctools_context_optional',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/includes/context.inc',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'ctools_context_required',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/includes/context.inc',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'ctools_export_ui',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/plugins/export_ui/ctools_export_ui.class.php',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'ctools_math_expr',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/includes/math-expr.inc',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'ctools_math_expr_stack',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/includes/math-expr.inc',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'ctools_stylizer_image_processor',
  'type' => 'class',
  'filename' => 'sites/all/modules/ctools/includes/stylizer.inc',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'Database',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseCondition',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnection',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnectionNotDefinedException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnection_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnection_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnection_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseDriverNotSpecifiedException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseLog',
  'type' => 'class',
  'filename' => 'includes/database/log.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchema',
  'type' => 'class',
  'filename' => 'includes/database/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchemaObjectDoesNotExistException',
  'type' => 'class',
  'filename' => 'includes/database/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchemaObjectExistsException',
  'type' => 'class',
  'filename' => 'includes/database/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchema_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchema_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchema_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatementBase',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatementEmpty',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatementInterface',
  'type' => 'interface',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatementPrefetch',
  'type' => 'class',
  'filename' => 'includes/database/prefetch.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatement_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTaskException',
  'type' => 'class',
  'filename' => 'includes/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTasks',
  'type' => 'class',
  'filename' => 'includes/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTasks_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTasks_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTasks_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransaction',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionCommitFailedException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionExplicitCommitNotAllowedException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionNameNonUniqueException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionNoActiveException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionOutOfOrderException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DateFormatTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DateTimeFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DBLogTestCase',
  'type' => 'class',
  'filename' => 'modules/dblog/dblog.test',
  'module' => 'dblog',
  'weight' => '0',
))
->values(array(
  'name' => 'DefaultMailSystem',
  'type' => 'class',
  'filename' => 'modules/system/system.mail.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DeleteQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DeleteQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalCacheArray',
  'type' => 'class',
  'filename' => 'includes/bootstrap.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalCacheInterface',
  'type' => 'interface',
  'filename' => 'includes/cache.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalDatabaseCache',
  'type' => 'class',
  'filename' => 'includes/cache.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalDefaultEntityController',
  'type' => 'class',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalEntityControllerInterface',
  'type' => 'interface',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalFakeCache',
  'type' => 'class',
  'filename' => 'includes/cache-install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalLocalStreamWrapper',
  'type' => 'class',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalPrivateStreamWrapper',
  'type' => 'class',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalPublicStreamWrapper',
  'type' => 'class',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalQueue',
  'type' => 'class',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalQueueInterface',
  'type' => 'interface',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalReliableQueueInterface',
  'type' => 'interface',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalRequestSanitizer',
  'type' => 'class',
  'filename' => 'includes/request-sanitizer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalSetMessageTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalStreamWrapperInterface',
  'type' => 'interface',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalTemporaryStreamWrapper',
  'type' => 'class',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalUpdateException',
  'type' => 'class',
  'filename' => 'includes/update.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalUpdaterInterface',
  'type' => 'interface',
  'filename' => 'includes/updater.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'EnableDisableTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityFieldQuery',
  'type' => 'class',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityFieldQueryException',
  'type' => 'class',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMalformedException',
  'type' => 'class',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityPropertiesTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldAttachOtherTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldAttachStorageTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldAttachTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldBulkDeleteTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldCrudTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldDisplayAPITestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldException',
  'type' => 'class',
  'filename' => 'modules/field/field.module',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldFormTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldInfo',
  'type' => 'class',
  'filename' => 'modules/field/field.info.class.inc',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldInfoTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldInstanceCrudTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldsOverlapException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldSqlStorageTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/field_sql_storage/field_sql_storage.test',
  'module' => 'field_sql_storage',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldTranslationsTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUIAlterTestCase',
  'type' => 'class',
  'filename' => 'modules/field_ui/field_ui.test',
  'module' => 'field_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUIManageDisplayTestCase',
  'type' => 'class',
  'filename' => 'modules/field_ui/field_ui.test',
  'module' => 'field_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUIManageFieldsTestCase',
  'type' => 'class',
  'filename' => 'modules/field_ui/field_ui.test',
  'module' => 'field_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUITestCase',
  'type' => 'class',
  'filename' => 'modules/field_ui/field_ui.test',
  'module' => 'field_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUpdateForbiddenException',
  'type' => 'class',
  'filename' => 'modules/field/field.module',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldValidationException',
  'type' => 'class',
  'filename' => 'modules/field/field.attach.inc',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldAnonymousSubmission',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldDisplayTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldPathTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldRevisionTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldValidateTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldWidgetTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileManagedFileElementTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FilePrivateTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileScanDirectory',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTaxonomyTermTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransfer',
  'type' => 'class',
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferChmodInterface',
  'type' => 'interface',
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferException',
  'type' => 'class',
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferFTP',
  'type' => 'class',
  'filename' => 'includes/filetransfer/ftp.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferFTPExtension',
  'type' => 'class',
  'filename' => 'includes/filetransfer/ftp.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferLocal',
  'type' => 'class',
  'filename' => 'includes/filetransfer/local.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferSSH',
  'type' => 'class',
  'filename' => 'includes/filetransfer/ssh.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterCRUDTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterDefaultFormatTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterDOMSerializeTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterFormatAccessTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterHooksTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterNoFormatTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterSecurityTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterSettingsTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterUnitTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FloodFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'FrontPageTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'HookRequirementsTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageAdminStylesUnitTest',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageAdminUiTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageDimensionsScaleTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageDimensionsTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageEffectsUnitTest',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageFieldDefaultImagesTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageFieldDisplayTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageFieldValidateTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageStyleFlushTest',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageStylesPathAndUrlTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageThemeFunctionWebTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'InfoFileParserTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'InsertQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'InsertQuery_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'InsertQuery_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'InsertQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'InvalidMergeQueryException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'IPAddressBlockingTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ListDynamicValuesTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/list/tests/list.test',
  'module' => 'list',
  'weight' => '0',
))
->values(array(
  'name' => 'ListDynamicValuesValidationTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/list/tests/list.test',
  'module' => 'list',
  'weight' => '0',
))
->values(array(
  'name' => 'ListFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/list/tests/list.test',
  'module' => 'list',
  'weight' => '0',
))
->values(array(
  'name' => 'ListFieldUITestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/list/tests/list.test',
  'module' => 'list',
  'weight' => '0',
))
->values(array(
  'name' => 'MailSystemInterface',
  'type' => 'interface',
  'filename' => 'includes/mail.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'MemoryQueue',
  'type' => 'class',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'MergeQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleDependencyTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleRequiredTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleUpdater',
  'type' => 'class',
  'filename' => 'modules/system/system.updater.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleVersionTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'MultiStepNodeFormBasicOptionsTest',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NewDefaultThemeBlocks',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessBaseTableTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessPagerTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessRebuildTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessRecordsTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeBlockFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeBlockTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeBuildContent',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeController',
  'type' => 'class',
  'filename' => 'modules/node/node.module',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeCreationTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeEntityFieldQueryAlter',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeEntityViewModeAlterTest',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeFeedTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeLoadHooksTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeLoadMultipleTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeMultiByteUtf8Test',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodePageCacheTest',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodePostSettingsTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeQueryAlter',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeRevisionPermissionsTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeRevisionsTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeRSSContentTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeSaveTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTitleTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTitleXSSTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTypePersistenceTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTypeTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeWebTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NoFieldsException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'NonDefaultBlockAdmin',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'NumberFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/number/number.test',
  'module' => 'number',
  'weight' => '0',
))
->values(array(
  'name' => 'OptionsSelectDynamicValuesTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/options/options.test',
  'module' => 'options',
  'weight' => '0',
))
->values(array(
  'name' => 'OptionsWidgetsTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/options/options.test',
  'module' => 'options',
  'weight' => '0',
))
->values(array(
  'name' => 'PageEditTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'PageNotFoundTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'PagePreviewTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'PagerDefault',
  'type' => 'class',
  'filename' => 'includes/pager.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'PageTitleFiltering',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'PageViewTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'Query',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueryAlterableInterface',
  'type' => 'interface',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueryConditionInterface',
  'type' => 'interface',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueryExtendableInterface',
  'type' => 'interface',
  'filename' => 'includes/database/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueryPlaceholderInterface',
  'type' => 'interface',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueueTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'RetrieveFileTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SchemaCache',
  'type' => 'class',
  'filename' => 'includes/bootstrap.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQuery',
  'type' => 'class',
  'filename' => 'includes/database/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQueryExtender',
  'type' => 'class',
  'filename' => 'includes/database/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQueryInterface',
  'type' => 'interface',
  'filename' => 'includes/database/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQuery_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'ShutdownFunctionsTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SiteMaintenanceTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SkipDotsRecursiveDirectoryIterator',
  'type' => 'class',
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'StreamWrapperInterface',
  'type' => 'interface',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SummaryLengthTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemAuthorizeCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemBlockTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemIndexPhpTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemInfoAlterTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemMainContentFallback',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemQueue',
  'type' => 'class',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemThemeFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemValidTokenTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TableSort',
  'type' => 'class',
  'filename' => 'includes/tablesort.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'TestingMailSystem',
  'type' => 'class',
  'filename' => 'modules/system/system.mail.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TextFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/text/text.test',
  'module' => 'text',
  'weight' => '0',
))
->values(array(
  'name' => 'TextSummaryTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/text/text.test',
  'module' => 'text',
  'weight' => '0',
))
->values(array(
  'name' => 'TextTranslationTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/text/text.test',
  'module' => 'text',
  'weight' => '0',
))
->values(array(
  'name' => 'ThemeRegistry',
  'type' => 'class',
  'filename' => 'includes/theme.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'ThemeUpdater',
  'type' => 'class',
  'filename' => 'modules/system/system.updater.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TokenScanTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TruncateQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'TruncateQuery_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'TruncateQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateQuery_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'Updater',
  'type' => 'class',
  'filename' => 'includes/updater.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdaterException',
  'type' => 'class',
  'filename' => 'includes/updater.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdaterFileTransferException',
  'type' => 'class',
  'filename' => 'includes/updater.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateScriptFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'UserAccountLinksUnitTests',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserAuthmapAssignmentTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserAutocompleteTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserBlocksUnitTests',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserCancelTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserController',
  'type' => 'class',
  'filename' => 'modules/user/user.module',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserCreateTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserEditedOwnAccountTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserEditRebuildTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserEditTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserLoginTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserPasswordResetTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserPermissionsTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserPictureTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserRegistrationTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserRoleAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserRolesAssignmentTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserSaveTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserSignatureTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserTimeZoneFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserUserSearchTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserValidateCurrentPassCustomForm',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserValidationTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'view',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/includes/view.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsAccessTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_access.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsAjaxTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_ajax.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsAnalyzeTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_analyze.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsArgumentDefaultTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_argument_default.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsArgumentValidatorTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_argument_validator.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsBasicTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_basic.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsCacheTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_cache.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsCloneTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_clone.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsExposedFormTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_exposed_form.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'viewsFieldApiDataTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/field/views_fieldapi.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsFieldApiTestHelper',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/field/views_fieldapi.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsGlossaryTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_glossary.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerAreaTextTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_area_text.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'viewsHandlerArgumentCommentUserUidTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/comment/views_handler_argument_comment_user_uid.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerArgumentNullTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_argument_null.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerFieldBooleanTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_field_boolean.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerFieldCustomTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_field_custom.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerFieldDateTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_field_date.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'viewsHandlerFieldFieldTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/field/views_fieldapi.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerFieldMath',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_field_math.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerFieldTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_field.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerFieldUrlTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_field_url.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'viewsHandlerFieldUserNameTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/user/views_handler_field_user_name.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerFileExtensionTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_field_file_extension.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerFilterCombineTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_filter_combine.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'viewsHandlerFilterCommentUserUidTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/comment/views_handler_filter_comment_user_uid.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerFilterCounterTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_field_counter.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerFilterDateTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_filter_date.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerFilterEqualityTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_filter_equality.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerFilterInOperator',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_filter_in_operator.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerFilterNumericTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_filter_numeric.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerFilterStringTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_filter_string.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerFilterTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_handler_filter.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerManyToOneTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_manytoone.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerRelationshipNodeTermDataTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/taxonomy/views_handler_relationship_node_term_data.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerSortDateTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_sort_date.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerSortRandomTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_sort_random.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerSortTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_sort.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlersTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_handlers.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handlers.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerTestFileSize',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_field_file_size.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsHandlerTestXss',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_field_xss.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsModuleTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_module.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsNodeRevisionRelationsTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/node/views_node_revision_relations.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsPagerTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_pager.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsPluginDisplayTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/plugins/views_plugin_display.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'viewsPluginStyleJumpMenuTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/styles/views_plugin_style_jump_menu.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsPluginStyleMappingTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/styles/views_plugin_style_mapping.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsPluginStyleTestBase',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/styles/views_plugin_style_base.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsPluginStyleTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/styles/views_plugin_style.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsPluginStyleUnformattedTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/styles/views_plugin_style_unformatted.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsQueryGroupByTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_groupby.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'viewsSearchQuery',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/search/views_handler_filter_search.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsSqlTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_query.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_query.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsTranslatableTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_translatable.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsUiGroupbyTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_groupby.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsUIWizardBasicTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_ui.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsUIWizardDefaultViewsTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_ui.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsUIWizardHelper',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_ui.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsUIWizardItemsPerPageTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_ui.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsUIWizardJumpMenuTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_ui.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsUIWizardMenuTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_ui.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsUIWizardOverrideDisplaysTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_ui.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsUIWizardSortingTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_ui.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsUIWizardTaggedWithTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_ui.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsUpgradeTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_upgrade.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsUserArgumentDefault',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/user/views_user_argument_default.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsUserArgumentValidate',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/user/views_user_argument_validate.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsUserTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/user/views_user.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'ViewsViewTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_view.test',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_db_object',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/includes/view.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_display',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/includes/view.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/includes/handlers.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_area',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_area.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_area_broken',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_area.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_area_messages',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_area_messages.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_area_result',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_area_result.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_area_text',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_area_text.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_area_text_custom',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_area_text_custom.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_area_view',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_area_view.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_argument.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_aggregator_category_cid',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/aggregator/views_handler_argument_aggregator_category_cid.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_aggregator_fid',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/aggregator/views_handler_argument_aggregator_fid.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_aggregator_iid',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/aggregator/views_handler_argument_aggregator_iid.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_broken',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_argument.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_comment_user_uid',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_argument_comment_user_uid.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_date',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_argument_date.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_field_list',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/field/views_handler_argument_field_list.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_field_list_string',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/field/views_handler_argument_field_list_string.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_file_fid',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/system/views_handler_argument_file_fid.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_formula',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_argument_formula.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_group_by_numeric',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_argument_group_by_numeric.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_locale_group',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/locale/views_handler_argument_locale_group.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_locale_language',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/locale/views_handler_argument_locale_language.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_many_to_one',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_argument_many_to_one.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_node_created_day',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_argument_dates_various.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_node_created_fulldate',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_argument_dates_various.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_node_created_month',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_argument_dates_various.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_node_created_week',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_argument_dates_various.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_node_created_year',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_argument_dates_various.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_node_created_year_month',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_argument_dates_various.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_node_language',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_argument_node_language.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_node_nid',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_argument_node_nid.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_node_tnid',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/translation/views_handler_argument_node_tnid.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_node_type',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_argument_node_type.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_node_uid_revision',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_argument_node_uid_revision.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_node_vid',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_argument_node_vid.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_null',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_argument_null.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_numeric',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_argument_numeric.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_search',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/search/views_handler_argument_search.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_string',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_argument_string.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_taxonomy',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_argument_taxonomy.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_term_node_tid',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_argument_term_node_tid.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_term_node_tid_depth',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_argument_term_node_tid_depth.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_term_node_tid_depth_join',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_argument_term_node_tid_depth_join.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_term_node_tid_depth_modifier',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_argument_term_node_tid_depth_modifier.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_tracker_comment_user_uid',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/tracker/views_handler_argument_tracker_comment_user_uid.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_users_roles_rid',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/user/views_handler_argument_users_roles_rid.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_user_uid',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/user/views_handler_argument_user_uid.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_vocabulary_machine_name',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_argument_vocabulary_machine_name.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_argument_vocabulary_vid',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_argument_vocabulary_vid.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_field.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_accesslog_path',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/statistics/views_handler_field_accesslog_path.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_aggregator_category',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/aggregator/views_handler_field_aggregator_category.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_aggregator_title_link',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/aggregator/views_handler_field_aggregator_title_link.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_aggregator_xss',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/aggregator/views_handler_field_aggregator_xss.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_boolean',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_boolean.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_broken',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_field.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_comment',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_comment.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_comment_depth',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_comment_depth.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_comment_link',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_comment_link.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_comment_link_approve',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_comment_link_approve.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_comment_link_delete',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_comment_link_delete.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_comment_link_edit',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_comment_link_edit.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_comment_link_reply',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_comment_link_reply.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_comment_node_link',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_comment_node_link.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_comment_username',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_comment_username.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_contact_link',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/contact/views_handler_field_contact_link.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_contextual_links',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_contextual_links.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_counter',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_counter.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_ctools_dropdown',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_ctools_dropdown.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_custom',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_custom.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_date',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_date.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_entity',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_entity.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_field',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/field/views_handler_field_field.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_file',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/system/views_handler_field_file.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_file_extension',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/system/views_handler_field_file_extension.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_file_filemime',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/system/views_handler_field_file_filemime.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_file_size',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_field.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_file_status',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/system/views_handler_field_file_status.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_file_uri',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/system/views_handler_field_file_uri.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_filter_format_name',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/filter/views_handler_field_filter_format_name.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_history_user_timestamp',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_history_user_timestamp.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_last_comment_timestamp',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_last_comment_timestamp.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_links',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_links.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_locale_group',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/locale/views_handler_field_locale_group.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_locale_language',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/locale/views_handler_field_locale_language.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_locale_link_edit',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/locale/views_handler_field_locale_link_edit.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_machine_name',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_machine_name.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_markup',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_markup.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_math',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_math.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_ncs_last_comment_name',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_ncs_last_comment_name.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_ncs_last_updated',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_ncs_last_updated.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_node',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_node.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_node_comment',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_node_comment.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_node_counter_timestamp',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/statistics/views_handler_field_node_counter_timestamp.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_node_language',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/locale/views_handler_field_node_language.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_node_link',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_node_link.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_node_link_delete',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_node_link_delete.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_node_link_edit',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_node_link_edit.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_node_link_translate',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/translation/views_handler_field_node_link_translate.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_node_new_comments',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_node_new_comments.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_node_path',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_node_path.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_node_revision',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_node_revision.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_node_revision_link',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_node_revision_link.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_node_revision_link_delete',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_node_revision_link_delete.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_node_revision_link_revert',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_node_revision_link_revert.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_node_translation_link',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/translation/views_handler_field_node_translation_link.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_node_type',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_node_type.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_node_version_count',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_node_version_count.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_numeric',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_numeric.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_prerender_list',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_prerender_list.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_profile_date',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/profile/views_handler_field_profile_date.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_profile_list',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/profile/views_handler_field_profile_list.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_search_score',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/search/views_handler_field_search_score.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_serialized',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_serialized.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_statistics_numeric',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/statistics/views_handler_field_statistics_numeric.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_taxonomy',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_field_taxonomy.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_term_link_edit',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_field_term_link_edit.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_term_node_tid',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_field_term_node_tid.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_time_interval',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_time_interval.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_url',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_url.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_user',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/user/views_handler_field_user.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_user_language',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/user/views_handler_field_user_language.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_user_link',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/user/views_handler_field_user_link.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_user_link_cancel',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/user/views_handler_field_user_link_cancel.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_user_link_edit',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/user/views_handler_field_user_link_edit.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_user_mail',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/user/views_handler_field_user_mail.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_user_name',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/user/views_handler_field_user_name.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_user_permissions',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/user/views_handler_field_user_permissions.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_user_picture',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/user/views_handler_field_user_picture.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_user_roles',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/user/views_handler_field_user_roles.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_field_xss',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_field.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_aggregator_category_cid',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/aggregator/views_handler_filter_aggregator_category_cid.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_boolean_operator',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_boolean_operator.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_boolean_operator_string',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_boolean_operator_string.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_broken',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_combine',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_combine.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_comment_user_uid',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_filter_comment_user_uid.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_date',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_date.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_entity_bundle',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_entity_bundle.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_equality',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_equality.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_fields_compare',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_fields_compare.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_field_list',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/field/views_handler_filter_field_list.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_field_list_boolean',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/field/views_handler_filter_field_list_boolean.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_file_status',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/system/views_handler_filter_file_status.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_group_by_numeric',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_group_by_numeric.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_history_user_timestamp',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_filter_history_user_timestamp.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_in_operator',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_in_operator.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_locale_group',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/locale/views_handler_filter_locale_group.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_locale_language',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/locale/views_handler_filter_locale_language.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_locale_version',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/locale/views_handler_filter_locale_version.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_many_to_one',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_many_to_one.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_ncs_last_updated',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_filter_ncs_last_updated.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_node_access',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_filter_node_access.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_node_comment',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_filter_node_comment.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_node_language',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/locale/views_handler_filter_node_language.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_node_status',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_filter_node_status.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_node_tnid',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/translation/views_handler_filter_node_tnid.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_node_tnid_child',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/translation/views_handler_filter_node_tnid_child.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_node_type',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_filter_node_type.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_node_uid_revision',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_filter_node_uid_revision.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_node_version_count',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_filter_node_version_count.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_numeric',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_numeric.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_profile_selection',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/profile/views_handler_filter_profile_selection.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_search',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/search/views_handler_filter_search.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_string',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_string.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_system_type',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/system/views_handler_filter_system_type.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_term_node_tid',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_filter_term_node_tid.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_term_node_tid_depth',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_filter_term_node_tid_depth.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_term_node_tid_depth_join',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_filter_term_node_tid_depth_join.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_tracker_boolean_operator',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/tracker/views_handler_filter_tracker_boolean_operator.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_tracker_comment_user_uid',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/tracker/views_handler_filter_tracker_comment_user_uid.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_user_current',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/user/views_handler_filter_user_current.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_user_name',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/user/views_handler_filter_user_name.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_user_permissions',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/user/views_handler_filter_user_permissions.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_user_roles',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/user/views_handler_filter_user_roles.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_vocabulary_machine_name',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_filter_vocabulary_machine_name.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_filter_vocabulary_vid',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_filter_vocabulary_vid.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_relationship',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_relationship.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_relationship_broken',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_relationship.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_relationship_entity_reverse',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/field/views_handler_relationship_entity_reverse.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_relationship_groupwise_max',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_relationship_groupwise_max.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_relationship_node_term_data',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_relationship_node_term_data.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_relationship_translation',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/translation/views_handler_relationship_translation.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_sort',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_sort.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_sort_broken',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_sort.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_sort_comment_thread',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_sort_comment_thread.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_sort_date',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_sort_date.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_sort_group_by_numeric',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_sort_group_by_numeric.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_sort_menu_hierarchy',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_sort_menu_hierarchy.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_sort_ncs_last_comment_name',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_sort_ncs_last_comment_name.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_sort_ncs_last_updated',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_sort_ncs_last_updated.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_sort_node_language',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/locale/views_handler_sort_node_language.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_sort_node_version_count',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_handler_sort_node_version_count.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_sort_random',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/handlers/views_handler_sort_random.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_handler_sort_search_score',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/search/views_handler_sort_search_score.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_join',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/includes/handlers.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_join_subquery',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/includes/handlers.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_many_to_one_helper',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/includes/handlers.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_object',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/includes/base.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/includes/plugins.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_access',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_access.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_access_none',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_access_none.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_access_perm',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_access_perm.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_access_role',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_access_role.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_argument_default',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_argument_default.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_argument_default_book_root',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/book/views_plugin_argument_default_book_root.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_argument_default_current_user',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/user/views_plugin_argument_default_current_user.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_argument_default_fixed',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_argument_default_fixed.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_argument_default_node',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_plugin_argument_default_node.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_argument_default_php',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_argument_default_php.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_argument_default_raw',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_argument_default_raw.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_argument_default_taxonomy_tid',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_plugin_argument_default_taxonomy_tid.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_argument_default_user',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/user/views_plugin_argument_default_user.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_argument_validate',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_argument_validate.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_argument_validate_node',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_plugin_argument_validate_node.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_argument_validate_numeric',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_argument_validate_numeric.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_argument_validate_php',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_argument_validate_php.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_argument_validate_taxonomy_term',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_plugin_argument_validate_taxonomy_term.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_argument_validate_user',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/user/views_plugin_argument_validate_user.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_cache',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_cache.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_cache_none',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_cache_none.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_cache_time',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_cache_time.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_display',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_display.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_display_attachment',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_display_attachment.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_display_block',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_display_block.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_display_default',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_display_default.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_display_embed',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_display_embed.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_display_extender',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_display_extender.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_display_feed',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_display_feed.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_display_page',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_display_page.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_exposed_form',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_exposed_form.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_exposed_form_basic',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_exposed_form_basic.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_exposed_form_input_required',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_exposed_form_input_required.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_localization',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_localization.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_localization_core',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_localization_core.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_localization_none',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_localization_none.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_localization_test',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/views_plugin_localization_test.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_pager',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_pager.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_pager_full',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_pager_full.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_pager_mini',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_pager_mini.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_pager_none',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_pager_none.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_pager_some',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_pager_some.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_query',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_query.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_query_default',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_query_default.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_row',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_row.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_row_aggregator_rss',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/aggregator/views_plugin_row_aggregator_rss.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_row_comment_rss',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_plugin_row_comment_rss.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_row_comment_view',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/comment/views_plugin_row_comment_view.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_row_fields',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_row_fields.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_row_node_rss',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_plugin_row_node_rss.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_row_node_view',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/node/views_plugin_row_node_view.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_row_rss_fields',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_row_rss_fields.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_row_search_view',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/search/views_plugin_row_search_view.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_row_user_view',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/modules/user/views_plugin_row_user_view.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_style',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_style.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_style_default',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_style_default.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_style_grid',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_style_grid.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_style_jump_menu',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_style_jump_menu.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_style_list',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_style_list.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_style_mapping',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_style_mapping.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_style_rss',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_style_rss.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_style_summary',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_style_summary.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_style_summary_jump_menu',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_style_summary_jump_menu.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_style_summary_unformatted',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_style_summary_unformatted.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_plugin_style_table',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/plugins/views_plugin_style_table.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_test_area_access',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/test_handlers/views_test_area_access.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_test_plugin_access_test_dynamic',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/test_plugins/views_test_plugin_access_test_dynamic.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_test_plugin_access_test_static',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/test_plugins/views_test_plugin_access_test_static.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'views_test_plugin_style_test_mapping',
  'type' => 'class',
  'filename' => 'sites/all/modules/views/tests/test_plugins/views_test_plugin_style_test_mapping.inc',
  'module' => 'views',
  'weight' => '0',
))
->values(array(
  'name' => 'WebformComponentsTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/tests/WebformComponentsTestCase.test',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'WebformConditionals',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/includes/webform.webformconditionals.inc',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'WebformConditionalsTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/tests/WebformConditionalsTestCase.test',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'WebformGeneralTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/tests/WebformGeneralTestCase.test',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'WebformPermissionsTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/tests/WebformPermissionsTestCase.test',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'WebformSubmissionTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/tests/WebformSubmissionTestCase.test',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'WebformTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/tests/WebformTestCase.test',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'WebformUnitTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/tests/WebformUnitTestCase.test',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'webform_exporter',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/includes/exporters/webform_exporter.inc',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'webform_exporter_delimited',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/includes/exporters/webform_exporter_delimited.inc',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'webform_exporter_excel_delimited',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/includes/exporters/webform_exporter_excel_delimited.inc',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'webform_exporter_excel_xlsx',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/includes/exporters/webform_exporter_excel_xlsx.inc',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'webform_handler_area_result_pager',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/views/webform_handler_area_result_pager.inc',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'webform_handler_field_form_body',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/views/webform_handler_field_form_body.inc',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'webform_handler_field_is_draft',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/views/webform_handler_field_is_draft.inc',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'webform_handler_field_node_link_edit',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/views/webform_handler_field_node_link_edit.inc',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'webform_handler_field_node_link_results',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/views/webform_handler_field_node_link_results.inc',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'webform_handler_field_numeric_data',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/views/webform_handler_numeric_data.inc',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'webform_handler_field_submission_count',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/views/webform_handler_field_submission_count.inc',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'webform_handler_field_submission_data',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/views/webform_handler_field_submission_data.inc',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'webform_handler_field_submission_link',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/views/webform_handler_field_submission_link.inc',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'webform_handler_field_webform_status',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/views/webform_handler_field_webform_status.inc',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'webform_handler_filter_is_draft',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/views/webform_handler_filter_is_draft.inc',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'webform_handler_filter_numeric_data',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/views/webform_handler_numeric_data.inc',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'webform_handler_filter_submission_data',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/views/webform_handler_filter_submission_data.inc',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'webform_handler_filter_webform_status',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/views/webform_handler_filter_webform_status.inc',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'webform_handler_relationship_submission_data',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/views/webform_handler_relationship_submission_data.inc',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'webform_handler_sort_numeric_data',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/views/webform_handler_numeric_data.inc',
  'module' => 'webform',
  'weight' => '0',
))
->values(array(
  'name' => 'webform_views_plugin_row_submission_view',
  'type' => 'class',
  'filename' => 'sites/all/modules/webform/views/webform_plugin_row_submission_view.inc',
  'module' => 'webform',
  'weight' => '0',
))
->execute();
$connection->schema()->createTable('registry_file', array(
  'fields' => array(
    'filename' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'hash' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
  ),
  'primary key' => array(
    'filename',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('registry_file')
->fields(array(
  'filename',
  'hash',
))
->values(array(
  'filename' => 'includes/actions.inc',
  'hash' => 'f36b066681463c7dfe189e0430cb1a89bf66f7e228cbb53cdfcd93987193f759',
))
->values(array(
  'filename' => 'includes/ajax.inc',
  'hash' => '8d5ebead219c48d5929ee6a5a178a331471ee6ceb38653094514c952457eaebd',
))
->values(array(
  'filename' => 'includes/archiver.inc',
  'hash' => 'bdbb21b712a62f6b913590b609fd17cd9f3c3b77c0d21f68e71a78427ed2e3e9',
))
->values(array(
  'filename' => 'includes/authorize.inc',
  'hash' => '6d64d8c21aa01eb12fc29918732e4df6b871ed06e5d41373cb95c197ed661d13',
))
->values(array(
  'filename' => 'includes/batch.inc',
  'hash' => '3480548cff18a67cf26072e041058cabe64bb839c6320a9050dc32eb87534aef',
))
->values(array(
  'filename' => 'includes/batch.queue.inc',
  'hash' => '554b2e92e1dad0f7fd5a19cb8dff7e109f10fbe2441a5692d076338ec908de0f',
))
->values(array(
  'filename' => 'includes/bootstrap.inc',
  'hash' => '6c77865c8212ff17bd82d125387cc25266a727c47cc753ff3fa8da22c2feed1d',
))
->values(array(
  'filename' => 'includes/cache-install.inc',
  'hash' => 'e7ed123c5805703c84ad2cce9c1ca46b3ce8caeeea0d8ef39a3024a4ab95fa0e',
))
->values(array(
  'filename' => 'includes/cache.inc',
  'hash' => '033c9bf2555dba29382b077f78cc00c82fd7f42a959ba31b710adddf6fdf24fe',
))
->values(array(
  'filename' => 'includes/common.inc',
  'hash' => 'e1b68e5297d064ce020f698579e8b232c311af126e7eaa14b29ad3252669a8a9',
))
->values(array(
  'filename' => 'includes/database/database.inc',
  'hash' => '2ef46543fb9cf61ed9fa9aed4e44dd31630c22604ea6b8e48b57ebd7ad11a111',
))
->values(array(
  'filename' => 'includes/database/log.inc',
  'hash' => '9feb5a17ae2fabcf26a96d2a634ba73da501f7bcfc3599a693d916a6971d00d1',
))
->values(array(
  'filename' => 'includes/database/mysql/database.inc',
  'hash' => '32a577354dba6030043500873f8a2a7359c80c179a213284b026c1a9b0452b70',
))
->values(array(
  'filename' => 'includes/database/mysql/install.inc',
  'hash' => '6ae316941f771732fbbabed7e1d6b4cbb41b1f429dd097d04b3345aa15e461a0',
))
->values(array(
  'filename' => 'includes/database/mysql/query.inc',
  'hash' => '0212a871646c223bf77aa26b945c77a8974855373967b5fb9fdc09f8a1de88a6',
))
->values(array(
  'filename' => 'includes/database/mysql/schema.inc',
  'hash' => '2ef729f8d6466d5cd87ba233152d88590bce629d8366040b2509b4e24258d780',
))
->values(array(
  'filename' => 'includes/database/pgsql/database.inc',
  'hash' => '651bec324e2204aa35a28fdbd876aa8e4f7a9e909e75cc8db811e9c156b0df88',
))
->values(array(
  'filename' => 'includes/database/pgsql/install.inc',
  'hash' => '39587f26a9e054afaab2064d996af910f1b201ef1c6b82938ef130e4ff8c6aab',
))
->values(array(
  'filename' => 'includes/database/pgsql/query.inc',
  'hash' => '0df57377686c921e722a10b49d5e433b131176c8059a4ace4680964206fc14b4',
))
->values(array(
  'filename' => 'includes/database/pgsql/schema.inc',
  'hash' => '1588daadfa53506aa1f5d94572162a45a46dc3ceabdd0e2f224532ded6508403',
))
->values(array(
  'filename' => 'includes/database/pgsql/select.inc',
  'hash' => '1e509bc97c58223750e8ea735145b316827e36f43c07b946003e41f5bca23659',
))
->values(array(
  'filename' => 'includes/database/prefetch.inc',
  'hash' => 'b5b207a66a69ecb52ee4f4459af16a7b5eabedc87254245f37cc33bebb61c0fb',
))
->values(array(
  'filename' => 'includes/database/query.inc',
  'hash' => '982d44a294eea1c9619687c14df2987257e3776fcabeba05f01432e934cf61c6',
))
->values(array(
  'filename' => 'includes/database/schema.inc',
  'hash' => '6ea8e4063eb72d8f6b1a9f8b8908489d9f89b4a158ef37002d21209fb500358c',
))
->values(array(
  'filename' => 'includes/database/select.inc',
  'hash' => '02a2d4345287df62b163ca2524e99b7370c9ec167bc937245328683d4e3e3d56',
))
->values(array(
  'filename' => 'includes/database/sqlite/database.inc',
  'hash' => '62f6669c4610557c4b34ada9f0a0f61d6cb7b377e0a9032d2efca7b5f39b0965',
))
->values(array(
  'filename' => 'includes/database/sqlite/install.inc',
  'hash' => '6620f354aa175a116ba3a0562c980d86cc3b8b481042fc3cc5ed6a4d1a7a6d74',
))
->values(array(
  'filename' => 'includes/database/sqlite/query.inc',
  'hash' => '0eb02ad036ef61c490fb3f189a4cdc8fc1ae0d442737806346fd63aea8f30db3',
))
->values(array(
  'filename' => 'includes/database/sqlite/schema.inc',
  'hash' => '3a7d22ec1f0ee09bfa267309b90e30edbe39e453b3025b30cbe3ae7412a4df2d',
))
->values(array(
  'filename' => 'includes/database/sqlite/select.inc',
  'hash' => '8d1c426dbd337733c206cce9f59a172546c6ed856d8ef3f1c7bef05a16f7bf68',
))
->values(array(
  'filename' => 'includes/date.inc',
  'hash' => '1de2c25e3b67a9919fc6c8061594442b6fb2cdd3a48ddf1591ee3aa98484b737',
))
->values(array(
  'filename' => 'includes/entity.inc',
  'hash' => 'f06b508f93e72ba70f979d8391be57662c018a03a32fac0a6d3baa752740133d',
))
->values(array(
  'filename' => 'includes/errors.inc',
  'hash' => 'd731bbe3a60508e164cfa90b8edc06400c7f15844f9f9bc3935dd87e44c460db',
))
->values(array(
  'filename' => 'includes/file.inc',
  'hash' => 'fb41a8c8875ff453f9b22499ae33c87ff85fad93958d324c07d382c7465bb8b5',
))
->values(array(
  'filename' => 'includes/file.mimetypes.inc',
  'hash' => '33266e837f4ce076378e7e8cef6c5af46446226ca4259f83e13f605856a7f147',
))
->values(array(
  'filename' => 'includes/file.phar.inc',
  'hash' => '544df23f736ce49f458033d6515a301a8ca1c7a7d1bfd3f388caef910534abb3',
))
->values(array(
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'hash' => '68442c03fd8612297a0d1ab86437ff9072fe1b71516f4c1e9f581d137a774698',
))
->values(array(
  'filename' => 'includes/filetransfer/ftp.inc',
  'hash' => '51eb119b8e1221d598ffa6cc46c8a322aa77b49a3d8879f7fb38b7221cf7e06d',
))
->values(array(
  'filename' => 'includes/filetransfer/local.inc',
  'hash' => '7cbfdb46abbdf539640db27e66fb30e5265128f31002bd0dfc3af16ae01a9492',
))
->values(array(
  'filename' => 'includes/filetransfer/ssh.inc',
  'hash' => '92f1232158cb32ab04cbc93ae38ad3af04796e18f66910a9bc5ca8e437f06891',
))
->values(array(
  'filename' => 'includes/form.inc',
  'hash' => '33de77c5c1aada8e0eb402f4ef58bc188f8b855668159f044feee03cb9bd64b2',
))
->values(array(
  'filename' => 'includes/graph.inc',
  'hash' => '8e0e313a8bb33488f371df11fc1b58d7cf80099b886cd1003871e2c896d1b536',
))
->values(array(
  'filename' => 'includes/image.inc',
  'hash' => 'bcdc7e1599c02227502b9d0fe36eeb2b529b130a392bc709eb737647bd361826',
))
->values(array(
  'filename' => 'includes/install.core.inc',
  'hash' => '189653e4bb7d4828bd6e1b61015fabcc7182e23d9dd8858170f98114d99400c8',
))
->values(array(
  'filename' => 'includes/install.inc',
  'hash' => '4d0b8c1532a8829051e17f275fa27e9c379ab826aee2e27229a9679ea6775da7',
))
->values(array(
  'filename' => 'includes/iso.inc',
  'hash' => '0ce4c225edcfa9f037703bc7dd09d4e268a69bcc90e55da0a3f04c502bd2f349',
))
->values(array(
  'filename' => 'includes/json-encode.inc',
  'hash' => '02a822a652d00151f79db9aa9e171c310b69b93a12f549bc2ce00533a8efa14e',
))
->values(array(
  'filename' => 'includes/language.inc',
  'hash' => '4e08f30843a7ccaeea5c041083e9f77d33d57ff002f1ab4f66168e2c683ce128',
))
->values(array(
  'filename' => 'includes/locale.inc',
  'hash' => 'ca50acc0780cbffeca17f99a0997f91b8b9402f0eec1898c3122e1d73664d01d',
))
->values(array(
  'filename' => 'includes/lock.inc',
  'hash' => 'a181c8bd4f88d292a0a73b9f1fbd727e3314f66ec3631f288e6b9a54ba2b70fa',
))
->values(array(
  'filename' => 'includes/mail.inc',
  'hash' => '41d0e657119a05f8d7e85ebf32e74b12a1c3107d717a348158414b113e208b9c',
))
->values(array(
  'filename' => 'includes/menu.inc',
  'hash' => 'b549c620ab2482da3a89f30e08f46bef32a848c6402d8c646234469473c89015',
))
->values(array(
  'filename' => 'includes/module.inc',
  'hash' => '943626f94bc69e95e36fde030475d57893f3296f0f8df461e2ee9f122dd37473',
))
->values(array(
  'filename' => 'includes/pager.inc',
  'hash' => '7d8d827eb2baace7031a02fd4b15a5e684928cd8345f878dd707adce11f93bd2',
))
->values(array(
  'filename' => 'includes/password.inc',
  'hash' => 'fd9a1c94fe5a0fa7c7049a2435c7280b1d666b2074595010e3c492dd15712775',
))
->values(array(
  'filename' => 'includes/path.inc',
  'hash' => 'acfd48f5582893af86cbb5ccf331ddb43bbf2671e879e5424a21c928d06d949f',
))
->values(array(
  'filename' => 'includes/registry.inc',
  'hash' => '2067cc87973e7af23428d3f41b8f8739d80092bc3c9e20b5a8858e481d03f22c',
))
->values(array(
  'filename' => 'includes/request-sanitizer.inc',
  'hash' => '770e8ece7b53d13e2b5ef99da02adb9a3d18071c6cd29eb01af30927cf749a73',
))
->values(array(
  'filename' => 'includes/session.inc',
  'hash' => '68dad2eb48e0f7336c7dfc953b4b8b23c95042de9ad480d127beeefd46552250',
))
->values(array(
  'filename' => 'includes/stream_wrappers.inc',
  'hash' => 'b8a5a53f3d3ef26ea868037547f76af8049ce0c55b464810c627310a84f24924',
))
->values(array(
  'filename' => 'includes/tablesort.inc',
  'hash' => '2d88768a544829595dd6cda2a5eb008bedb730f36bba6dfe005d9ddd999d5c0f',
))
->values(array(
  'filename' => 'includes/theme.inc',
  'hash' => 'ffef4dc87e40ba6e57ac90fd1d81c30ff59da9f5407ddbae98d5597cbae5691a',
))
->values(array(
  'filename' => 'includes/theme.maintenance.inc',
  'hash' => '39f068b3eee4d10a90d6aa3c86db587b6d25844c2919d418d34d133cfe330f5a',
))
->values(array(
  'filename' => 'includes/token.inc',
  'hash' => '5e7898cd78689e2c291ed3cd8f41c032075656896f1db57e49217aac19ae0428',
))
->values(array(
  'filename' => 'includes/unicode.entities.inc',
  'hash' => '2b858138596d961fbaa4c6e3986e409921df7f76b6ee1b109c4af5970f1e0f54',
))
->values(array(
  'filename' => 'includes/unicode.inc',
  'hash' => 'e18772dafe0f80eb139fcfc582fef1704ba9f730647057d4f4841d6a6e4066ca',
))
->values(array(
  'filename' => 'includes/update.inc',
  'hash' => '25c30f1e61ef9c91a7bdeb37791c2215d9dc2ae07dba124722d783ca31bb01e7',
))
->values(array(
  'filename' => 'includes/updater.inc',
  'hash' => 'd2da0e74ed86e93c209f16069f3d32e1a134ceb6c06a0044f78e841a1b54e380',
))
->values(array(
  'filename' => 'includes/utility.inc',
  'hash' => '3458fd2b55ab004dd0cc529b8e58af12916e8bd36653b072bdd820b26b907ed5',
))
->values(array(
  'filename' => 'includes/xmlrpc.inc',
  'hash' => 'ea24176ec445c440ba0c825fc7b04a31b440288df8ef02081560dc418e34e659',
))
->values(array(
  'filename' => 'includes/xmlrpcs.inc',
  'hash' => '925c4d5bf429ad9650f059a8862a100bd394dce887933f5b3e7e32309a51fd8e',
))
->values(array(
  'filename' => 'modules/block/block.test',
  'hash' => '40d9de00589211770a85c47d38c8ad61c598ec65d9332128a882eb8750e65a16',
))
->values(array(
  'filename' => 'modules/dblog/dblog.test',
  'hash' => '79ba7991c3f40f9241e9a03ffa43faf945c82658ca9b52ec62bd13bd80f41269',
))
->values(array(
  'filename' => 'modules/field/field.attach.inc',
  'hash' => '2df4687b5ec078c4893dc1fea514f67524fd5293de717b9e05caf977e5ae2327',
))
->values(array(
  'filename' => 'modules/field/field.info.class.inc',
  'hash' => 'cf18178e119d43897d3abd882ba3acc0cf59d1ad747663437c57b1ec4d0a4322',
))
->values(array(
  'filename' => 'modules/field/field.module',
  'hash' => '48b5b83f214a8d19e446f46c5d7a1cd35faa656ccb7b540f9f02462a440cacdd',
))
->values(array(
  'filename' => 'modules/field/modules/field_sql_storage/field_sql_storage.test',
  'hash' => '315eedaf2022afc884c35efd3b7c400eddab6ea30bec91924bc82ab5cd3e79f2',
))
->values(array(
  'filename' => 'modules/field/modules/list/tests/list.test',
  'hash' => 'c1a214d7efd3247dd947d742a8514ec9649da62593608dfdccee6913d48e5709',
))
->values(array(
  'filename' => 'modules/field/modules/number/number.test',
  'hash' => '4392f6fadf67c7533725e12bbe15ee2624cd54158e153f42f6cad3c28144395e',
))
->values(array(
  'filename' => 'modules/field/modules/options/options.test',
  'hash' => '1b30956b6f46840ccb41b99bda08f328172f008f1fb4164c65fe9e4047fffa5f',
))
->values(array(
  'filename' => 'modules/field/modules/text/text.test',
  'hash' => '5c28b9da26417d2ed8a169850989c0b59f2b188a0161eb58e2b87c67994d602d',
))
->values(array(
  'filename' => 'modules/field/tests/field.test',
  'hash' => '5eaad7a933ef8ea05b958056492ce17858cd542111f0fe81dd1a5949ad8f966e',
))
->values(array(
  'filename' => 'modules/field_ui/field_ui.test',
  'hash' => 'f535e5627c969e9083a63aaf72d4ac645e30709d7b87af15c6c3b870481f283a',
))
->values(array(
  'filename' => 'modules/file/tests/file.test',
  'hash' => 'c5f7592b47329f7a3ab44f9c218eebcef639760cd78180b566551c53bcfe9473',
))
->values(array(
  'filename' => 'modules/filter/filter.test',
  'hash' => 'b8aa5e6b832422c6ad5fe963898ec9526c814614f27ecccb67107ce194997d6a',
))
->values(array(
  'filename' => 'modules/image/image.test',
  'hash' => '6e7a0cbcb58f6210127b0ac7c1d118d488abd0925fe8db10a3405af87f1d9fe1',
))
->values(array(
  'filename' => 'modules/node/node.module',
  'hash' => '45a35bda7eea00f6636c85cef8aea3ced2a181ff6d6841f71603e286607f12a5',
))
->values(array(
  'filename' => 'modules/node/node.test',
  'hash' => '35bf40fde62f3a1de95bab9f037b84f20c2f93a1c579d7d19e4a87afe75dc330',
))
->values(array(
  'filename' => 'modules/system/system.archiver.inc',
  'hash' => '05caceec7b3baecfebd053959c513f134a5ae4070749339495274a81bebb904a',
))
->values(array(
  'filename' => 'modules/system/system.mail.inc',
  'hash' => 'd2f4fca46269981db5edb6316176b7b8161de59d4c24c514b63fe3c536ebb4d6',
))
->values(array(
  'filename' => 'modules/system/system.queue.inc',
  'hash' => 'a77a5913d84368092805ac551ca63737c1d829455504fcccb95baa2932f28009',
))
->values(array(
  'filename' => 'modules/system/system.tar.inc',
  'hash' => 'a4d6659fbd7e80c27dcb20fc61bc443a6ffe62fbb253c0a664ef3986f4f5c868',
))
->values(array(
  'filename' => 'modules/system/system.test',
  'hash' => '606072e2a07b4c9a790307d7d72d1c9b96d2dfaa5532f408e9236a49e8a4a548',
))
->values(array(
  'filename' => 'modules/system/system.updater.inc',
  'hash' => '9433fa8d39500b8c59ab05f41c0aac83b2586a43be4aa949821380e36c4d3c48',
))
->values(array(
  'filename' => 'modules/user/user.module',
  'hash' => '675ffb3a1cf007302e90807fb62b1df875c30f088cdc683c8c47e19a00d22dfd',
))
->values(array(
  'filename' => 'modules/user/user.test',
  'hash' => '26e4956f7dac39d8b6e3fd0b8718d5b7f5667d4da3c276fb2732e5220b5086c6',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/includes/context.inc',
  'hash' => '2057a0331cf54e23ef39aa84b7c60f486aff749223367a30f3513b05dde35f3d',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/includes/css-cache.inc',
  'hash' => 'db90ff67669d9fa445e91074ac67fb97cdb191a19e68d42744f0fd4158649cfa',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/includes/math-expr.inc',
  'hash' => 'f468453177eaa340d2a9dd03cc857be1080f4422bc0c4467e1f55663aa8aa4ae',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/includes/stylizer.inc',
  'hash' => 'a19b912a79e6d982a6bfbb660c108a047e41283a23e1b12e4b9c22af51771add',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/plugins/export_ui/ctools_export_ui.class.php',
  'hash' => '33ca784ee967dee1234372e6075505ce57f7685b494e4fa477318579bb85ccbf',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/context.test',
  'hash' => 'bc23a86c5c32a0335c970f1e51ad6d60cc02d006de3d5cb5ee0bbdaa84d5bcd3',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/css.test',
  'hash' => '832c58634157083e988797bf878c5fd6b9640e187802a397763e25771eced028',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/css_cache.test',
  'hash' => '331564b96148bb666b306ead748b8b18a7baf746e96d6564b9685a23ca47a888',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/ctools.plugins.test',
  'hash' => '2dbabab681d5a9e15e093aef5a48732dcdb030680b932c7a0c7260e444751919',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/ctools.test',
  'hash' => '427659c5c3db1e8638539b6dd1a440451e043129172a42f66f3f9bbd15e8db0b',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/math_expression.test',
  'hash' => '8e75cdab9db025add3adf9dd36fa818e6982b23f7bf3a8192deca5d3240360e4',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/math_expression_stack.test',
  'hash' => '203b98c797d7eaa787c6481c1ab9482c0ca45559314f79632d7c5efb51d7d170',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/object_cache.test',
  'hash' => '0af88e1d17b8265ac621799922934dded7c44073c001acf8c1c47d0187cb52fa',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/object_cache_unit.test',
  'hash' => '9fd7871c5f0307247469bcdd488f3086126f5f7978d6a470f8ecb8a6dc4b5a1e',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/page_tokens.test',
  'hash' => '078f82bd0957d8821521388fa270e70e10e9f143c1012ebac60f2dfd4d9ab1a4',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_area.inc',
  'hash' => '16085f6aff78a35dfb536909e82e0ebba99f382d4abfeea74f86dfbbe576938b',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_area_messages.inc',
  'hash' => 'a99ce6f396662fd511f0a5b4dd44289940c61eb19419fce952e8cd1d92fb540a',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_area_result.inc',
  'hash' => '614026de7b8f6fd6aee56396938ba6354ef3dc7908a93159051389ffafedebb4',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_area_text.inc',
  'hash' => '9b249c72a27c425e554ac5fc4f5bfe5030468e941197a5f2a728251e1a1709ba',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_area_text_custom.inc',
  'hash' => 'b834a5b12dcb0437734337d50d81af185e7e0149fbad853addec5d2c6992c8fd',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_area_view.inc',
  'hash' => '62faaa2aa80df6c136814acde663a7055a5c17bc6e2975ff566464a8fb90a38e',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_argument.inc',
  'hash' => '55a60cee0a22b2b3dc8b1bcd556ee329d7e01c53e9b009866dd24eac0f552a3e',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_argument_date.inc',
  'hash' => 'a74a274dd15c9453b227c5fa78005ec64551d1d608c349f8cdfbb3966179797e',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_argument_formula.inc',
  'hash' => '2090ca11e6328bb3b5c149a18027519bbfcbfdffed66d4c8c1e69316593199b3',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_argument_group_by_numeric.inc',
  'hash' => 'aa65e69556046558f52929009b129ea74ad4f4dd3c79dc517317082be298cad6',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_argument_many_to_one.inc',
  'hash' => 'e3b119709ebdae549a45a33751413d591fd29b886091257cb9f76afc87153612',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_argument_null.inc',
  'hash' => '9c26fd85eccdb9fa5483ea9b556b61bfdab0c7e802ab8516f04fb54ce6e3c501',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_argument_numeric.inc',
  'hash' => '366aa47d02f8c1f69cb9303bf56283601c07c7272a84ad4e6fe35b1bad49c8f3',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_argument_string.inc',
  'hash' => 'b9eb2bc894cd92ab51fe2e09f12b08965561c890df93029877ea520791a51e8b',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_field.inc',
  'hash' => '08c7f960f15d98ffdd1649f66c1439105da77b8850d8ca16705a07898932490a',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_boolean.inc',
  'hash' => 'c4b6fe66a0af7f21db4597f5f697c8a2d5ed5ea413471bb34c31a776b1250e6a',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_contextual_links.inc',
  'hash' => '58adabc6212039a33d232130a07622ba281385ceb8e3b33ad688cd4aefc6754e',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_counter.inc',
  'hash' => '701ade124c2e6c08a459ef5445ceffd3dc16348c752db8eba86d9182ebc93658',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_ctools_dropdown.inc',
  'hash' => '77e35b9f6e95f16c41de1d7a1abc608e48b77aee36ca05874d3b69046e04e5a4',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_custom.inc',
  'hash' => 'd3c2b1df06ec7f74f52e1188c9cd26eef23b09928f2d0355bddb2d14a985d221',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_date.inc',
  'hash' => 'ac3229b68a791fe43be920a02944a67b3fd0747f81c7b50e3ba824f3825aca0d',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_entity.inc',
  'hash' => '3ffdaf1c310f36ea61e7c1766acc112c6683a9a7bb99a5baf48e3ca121322eb3',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_links.inc',
  'hash' => '8d1d612ccf6e0ad5c18086bb32ce9727dbf6ccd0520384cb6265cec42e9772c7',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_machine_name.inc',
  'hash' => 'edbe2e4a2911d4ecdbf1c58f6645dfddf28f4434be809ba64e01fe9ea94783d5',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_markup.inc',
  'hash' => '94a925ba9dcc866929cbb30b895ae75aacae60688ac0e38a1a84cc90ebbd51e6',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_math.inc',
  'hash' => '5c9087cb87791ef94dd1830da08585efba43b28a09f9227e36a9c6e764ddc8f4',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_numeric.inc',
  'hash' => '4fefb5c808f0a7cebacd4b2cbaf25b165a93d3bb4b35b3628302bea6b9031614',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_prerender_list.inc',
  'hash' => '4332691d10f6d0ed91f3b4279499f12737314555fdd6c87a3556d998528545c9',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_serialized.inc',
  'hash' => '14997b7d224d5dd50295f71cf626bd4e4eed0d906d6da32b92037cc734ccac1e',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_time_interval.inc',
  'hash' => '4b6f36465710740d6e266f1cb731b3c0c72ba7455ee0fecee80a847131b3e7de',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_field_url.inc',
  'hash' => '6633a403da44af6e82188fe1416bd06a6cb1f69e0546f162296d2c2e79af255b',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter.inc',
  'hash' => 'fc530fa4eb2458f0b5dfed71d38aa4f13761b4706955c0b1d859b9409cea8ea5',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_boolean_operator.inc',
  'hash' => 'e9089bb8135313d5650c6095d91fb0682f0a0509108b567ccb13f352bab14db0',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_boolean_operator_string.inc',
  'hash' => 'fd2bd503b46361ada4e6b4ada3451b322f646c68de5591e13b194c733ad683f4',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_combine.inc',
  'hash' => '6dfd069622016d0239cfa85311660c1f17173243c381bdca1ef84410c67485af',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_date.inc',
  'hash' => '29d7bbbef9564122a7a83281699fa084596d326c76ac477a691f50fae48fdcc1',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_entity_bundle.inc',
  'hash' => 'c7e82ca67ac0e66740ce247829179158462dc4bf1d119407009460db1cca973e',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_equality.inc',
  'hash' => '8188497af26a099cdb0d7ca3feda14ce288eebe1d02f87348f30da1ef99993e2',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_fields_compare.inc',
  'hash' => '9639036d337eed13379a55ecbac33d1b059c2f38ce20ade614d6819cd0e29a26',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_group_by_numeric.inc',
  'hash' => '1258029768dbdcfcb5cfffcac09b22789fe36e91618a4a06e1e4a4b6c6c19d41',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_in_operator.inc',
  'hash' => 'd54e35c8800930b149a2e2796f0990c079be0ea8359b03bc290ecffc096b14ed',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_many_to_one.inc',
  'hash' => 'e8cb18060c952bf11148c2247ec14201fd499ac005c092e7d96734d83ac9895a',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_numeric.inc',
  'hash' => 'cdb51e786a1e32ed91d84f96085f72cf2b846afbf6d6e2860658604be294bbc5',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_filter_string.inc',
  'hash' => 'cf1da75621747176d5a582634205172fd718ea57548220b9aefc9aa9892c7944',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_relationship.inc',
  'hash' => '56f8b9a3085aee56ffedc75f76a9334c57796f2cd3fe9706506683f46b85a0e4',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_relationship_groupwise_max.inc',
  'hash' => 'cee644bef90c8d4412c01a16f8189b6a5e912d36fcaf181c2cc1198012fd7bbb',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_sort.inc',
  'hash' => '36391f1498cce13b2f37343da53e61ec437f6f1afd0fa3f1cc4c0627ca42e2d3',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_sort_date.inc',
  'hash' => '9949279b1d2f714afa51fba865749a40546ef434f9ba5e68bf8fe09ed056fed4',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_sort_group_by_numeric.inc',
  'hash' => 'ed4196d099a2c5112b46ce1cd256edf71793e130a5ed49631fff2a365fc3291b',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_sort_menu_hierarchy.inc',
  'hash' => '60628a647e83f991b2fb42506b1c52fc8934cb19278fefb2ffe980065d027136',
))
->values(array(
  'filename' => 'sites/all/modules/views/handlers/views_handler_sort_random.inc',
  'hash' => '672a9473a35bc811d8bb0365dedfff988671de9c00e0e703819e9adaa70db4ba',
))
->values(array(
  'filename' => 'sites/all/modules/views/includes/base.inc',
  'hash' => '1eb8aea63c9d50a9a13af71ed49ac76951bd65713c4aba9adc6ce43e402a97e6',
))
->values(array(
  'filename' => 'sites/all/modules/views/includes/handlers.inc',
  'hash' => 'e4de191788ceb6c51f4005b3abcb1c22acf2f5c70b18778d3f8832d6e1b65e8e',
))
->values(array(
  'filename' => 'sites/all/modules/views/includes/plugins.inc',
  'hash' => 'b41a59b67e719abc1df93d022a37c0cf701059d1cf566fab6edee6147bdf0369',
))
->values(array(
  'filename' => 'sites/all/modules/views/includes/view.inc',
  'hash' => 'f862b14fdb3e5eb913f389c6f289b60678d6e35fe4c29a41990ef5df6ee1cefd',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/aggregator/views_handler_argument_aggregator_category_cid.inc',
  'hash' => 'e67a696600c3c9a37f8c732b89813500f207eaad32766f2e804c02063cdfb17c',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/aggregator/views_handler_argument_aggregator_fid.inc',
  'hash' => '51a2520546cac7d4c56a80f2b61dd41a878a4a75037f0739e214ff8155a0fef1',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/aggregator/views_handler_argument_aggregator_iid.inc',
  'hash' => 'c3045fdf47ae7639275090768d7d9a2358cd66e9de600e2cfc7ae52b5cd64c05',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/aggregator/views_handler_field_aggregator_category.inc',
  'hash' => '9af125c4285d770572757e8ad114048e4243dd6710bcd992c3b8365aaf3d5cbb',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/aggregator/views_handler_field_aggregator_title_link.inc',
  'hash' => '717fe70dc6f4a00a808d3ea478fd146c108be26e0c5773f4574b073bce0ef3b3',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/aggregator/views_handler_field_aggregator_xss.inc',
  'hash' => '83ba99ebdc04ed18e266a41ed97c874c81002f13059815e353976668d68e6de3',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/aggregator/views_handler_filter_aggregator_category_cid.inc',
  'hash' => '3d819f5de170c4d4f2e8d3348be5645f27059854169725375fbc5e4148e772e3',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/aggregator/views_plugin_row_aggregator_rss.inc',
  'hash' => 'e73716935ee6172dc5c6dbc6126c00decef6759da8cb05b278089328661583c1',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/book/views_plugin_argument_default_book_root.inc',
  'hash' => '123eda93e4ad9da88a6dc3ffd771772ea71abdf1d749c8f2d17c48d656fb0d5f',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_argument_comment_user_uid.inc',
  'hash' => '9955ba779f626be3dbc18a5d5c3b7e0d4638ea32ce606fbc9144044965b491a8',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_comment.inc',
  'hash' => 'beb5e6eb481aa5adbc347ed7ef31572fcd63a892aa83266b9000f9569508f7ee',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_comment_depth.inc',
  'hash' => 'd316270160be29bac6e50d990c34d51811f9520359458331fced5ea6535a920f',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_comment_link.inc',
  'hash' => '77f3fdaef1bb183bc6f51f9bcdcff7f5c267f02d731c6e774d7964048674f635',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_comment_link_approve.inc',
  'hash' => '3a1587ed47b306e0ff6dd0298e7a1cc0a899c91b814dc48239f7173027fb692f',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_comment_link_delete.inc',
  'hash' => '03ca804e176402c955734151de2d8ec1f77a558efbeabdfc0a2550026805a986',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_comment_link_edit.inc',
  'hash' => '4ea1157e43d2c04d15250aa2247223a5ebdb3cde5cd751ee8d9976ce09701fd5',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_comment_link_reply.inc',
  'hash' => 'c65548a886717de8cd8de65653866daad70395e396a77f67f0ba788eed29c1cf',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_comment_node_link.inc',
  'hash' => 'fc093dd213dd5a9b66830b51083e8c94af1a4cf66485d242199284b20e84bf84',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_comment_username.inc',
  'hash' => 'dce17ff9703a545bb55f10aa51e702ab318ba6652a308bd4bbf7ab509816fbee',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_last_comment_timestamp.inc',
  'hash' => '3865475732389244162027b2a1dd5c847b97f8007bd08bb597ede0a2abc07a33',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_ncs_last_comment_name.inc',
  'hash' => '227bf7ff4ba7464310b75196da3f85e3eb9a8da89f667b6153d5023d93034105',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_ncs_last_updated.inc',
  'hash' => '3a75c18196f060e268ed4a764039f63cfde4d45d157673b19171a6eed5fa1c79',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_node_comment.inc',
  'hash' => 'a3e9f9cd9e251e866ec1fc6e6072fe90e83ff4b882a6aa2796ec8721129dc2cd',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_field_node_new_comments.inc',
  'hash' => '089a6649c4039ec3a855798fa131c01a5c8930928e47493f3c3073fb9ffc040d',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_filter_comment_user_uid.inc',
  'hash' => 'fedb023952d2b1b418848293f45f4f33adf9c885d279655ac0f6761d2dca11d5',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_filter_ncs_last_updated.inc',
  'hash' => '40f9157a53807537a7bd8d5989e6abafbbc3b9b296958207e97944165f9ef639',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_filter_node_comment.inc',
  'hash' => '222e790fae64c087c755949bdd98b2f70851c20c22ba7a0a6eebeca1ccbff8ed',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_sort_comment_thread.inc',
  'hash' => '91fb14f3058c409bef347a0a76c48fe9f4715fcfa49b35a19899e74dfb4e3358',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_sort_ncs_last_comment_name.inc',
  'hash' => '1b988db986ba10fc1052297d6bf47ffed64272032a6aedadb742a7737a8a04bd',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_handler_sort_ncs_last_updated.inc',
  'hash' => 'd7ce11c55dbeef236965d2708cf4ff3f6fd751835b0e63538031600c8dd6b48f',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_plugin_row_comment_rss.inc',
  'hash' => '661a484de92222f270d2894ad9b5372165e4a8beee815aa52628e656757f331e',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/comment/views_plugin_row_comment_view.inc',
  'hash' => '33a763b97f3b8998011e01e967e1a92d988215af365b8db0ebd4bdbc9a081870',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/contact/views_handler_field_contact_link.inc',
  'hash' => '94aae2c3ca97edaae19cf8291b9255a9f50e28507307ec3d6ee3b84729ece1ba',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/field/views_handler_argument_field_list.inc',
  'hash' => 'c2782930964ee2e312ca238357b7ee3e0769372cc1216c604b2633677729c58e',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/field/views_handler_argument_field_list_string.inc',
  'hash' => '1e3d03b1338c2ea5c7550e0ae4966dcb8e163ce2b3538d8654c0c4d3620f0898',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/field/views_handler_field_field.inc',
  'hash' => 'ddd9b0e1e1f452218798b1d2e808d084528d90ab80a3f6b3d9db54513f36d612',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/field/views_handler_filter_field_list.inc',
  'hash' => '77fcfe98e5fb1638c879a3fb2dc6769e49a79cf348e26e843566175b01358730',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/field/views_handler_filter_field_list_boolean.inc',
  'hash' => '028a78d1bdb1b5495dbb1b484220a9d8e31ca7b69f20f119a35fb6d58c7a0160',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/field/views_handler_relationship_entity_reverse.inc',
  'hash' => 'b14ede644a0f64ad2eab73d8c09dca5859412fedbd97ee0580d1d6fcdecdc819',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/filter/views_handler_field_filter_format_name.inc',
  'hash' => '2a0a6d07ec0352260fc3e94c6f08e15afb0888dcc05d4184ba49de01be8b9fea',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/locale/views_handler_argument_locale_group.inc',
  'hash' => '754ebf9a38ae05593fe74be7e4f0a887c12ed710da340c3066686f3f5740c256',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/locale/views_handler_argument_locale_language.inc',
  'hash' => 'ee06594ed7558b4e7369d5d560f3c9f1b8db4442e410e81bb282b45c4b5238ba',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/locale/views_handler_field_locale_group.inc',
  'hash' => 'fc6a3c57d9abffbe1cfb859c6adfdfed5f2c63cb645df1ec732f84ee2e8f4f4c',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/locale/views_handler_field_locale_language.inc',
  'hash' => '431fc20daaf9cccd4d739b16a6cb9a732417b5b6079b12cbb73710fee2a51e9d',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/locale/views_handler_field_locale_link_edit.inc',
  'hash' => '63dc823990a69622585a21212f2e162e2ce018a9c1348c148a3e5215d005e023',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/locale/views_handler_field_node_language.inc',
  'hash' => '76e09d9b0f4c345425a52f9def5aae5e029e6ac9dd079a242dfa9aa98f6cf010',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/locale/views_handler_filter_locale_group.inc',
  'hash' => '2c9da2c417de6cb48a13b4bb52dd9d9ec0a4f257ee4e26b7b99ca46b10334ceb',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/locale/views_handler_filter_locale_language.inc',
  'hash' => '59749963fd5fbebff0a6e09b5553b0ae639bf2f053da7aab325d0662093f3b04',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/locale/views_handler_filter_locale_version.inc',
  'hash' => '266f380b0488af0ebaec0c9b0f8168402bdc53dfdd29f6a81924c88c04829287',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/locale/views_handler_filter_node_language.inc',
  'hash' => '70dd129038f85a61f1a4bb24ce4286520154546f5696a135de8f0f2caf39ac15',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/locale/views_handler_sort_node_language.inc',
  'hash' => '7f24790cf76cf979e9314d12a269b39f2b10d2787b69dc8a3a9b51d0b3ed4ae8',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_argument_dates_various.inc',
  'hash' => '6308402609dbc7f92594e4e5d4f4f0cb5ba71e43c6f247cb71af111c53db83d6',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_argument_node_language.inc',
  'hash' => '85d5ec6d2cb7fe84ba59d27054f170207ee1b765366de7324d2f8b58feaae710',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_argument_node_nid.inc',
  'hash' => '1c3517c618dc4704d48702250075384b9bf3fac50d24d5eed832a17f5dfa2da3',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_argument_node_type.inc',
  'hash' => 'a79d743f7e0300feed39d7e9f1cb46bfe470c4639abc47f0110190d413e1dbc0',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_argument_node_uid_revision.inc',
  'hash' => '04e049eb41769c91b3bbff1be5971bdba0b56d4c9e81f7b564c2ec0cc8c8227f',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_argument_node_vid.inc',
  'hash' => '2bb53e69fcf14294053c5610fe40408f6adb5b25bf6f0c6d66c0848cb90615bb',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_history_user_timestamp.inc',
  'hash' => 'c9bae50db9659597b7e8c1533ac2606919517811ace4b7dc786b7f48a264020d',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_node.inc',
  'hash' => 'e13196a84647ec0bd6a4dcb92cf5d6e340bab0e9aeadabe723567e8c7abf21af',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_node_link.inc',
  'hash' => '450c511b8fada8689fbecd1f92fd208c4add47699e97438bffdd682415e1fe00',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_node_link_delete.inc',
  'hash' => 'ab50268cfb67a3deafa21a7f5acb5c908d378efe6dbfd6e1537cde1487fb0a09',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_node_link_edit.inc',
  'hash' => '91aebee3065d3880773b81d8d3f1d062804162454265f8be12bea3681d0791b0',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_node_path.inc',
  'hash' => 'fe9bd2b94c7ac927c78aa559783e12bea69abf2f9bc1ad8bbd250826bb295597',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_node_revision.inc',
  'hash' => 'd3c7c25c86da0615304764c09e76b2d3f94da06975add14e539964a53d0afab8',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_node_revision_link.inc',
  'hash' => 'ea7b46f10f54fd565bdc6b6a78c581de9889b20afa1d2773bbb51f9dc9ce4da5',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_node_revision_link_delete.inc',
  'hash' => '329a3063a79278c72fbc7a3dd87d9a309a62f4dac039785ff3ac43000b48155f',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_node_revision_link_revert.inc',
  'hash' => '939815ed25649dc4646e26042868cc3eeabf618ba750e84900c74017d181a675',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_node_type.inc',
  'hash' => '0296f415723508d2c68d314394055d5ab14df0958bc6cb0158eba2c395494f07',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_field_node_version_count.inc',
  'hash' => '42ed9bbe09e407f5452e8e8523cb8719c46a41d6a60eca449b0182e7dc9e9298',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_filter_history_user_timestamp.inc',
  'hash' => '83028bbcc531cd39d5368e4b2ec68c5569fb1d12f35712bf14c7cb3da4aa7e91',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_filter_node_access.inc',
  'hash' => '3f6a4da11b627de054c2e14b4869a521352d501d1be18a05f1c67db6ae73d18b',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_filter_node_status.inc',
  'hash' => 'bc823f0c6771f62bb67e1ff79aa4542ebf9bfcee6f5b97d65a7a3b6d2df1ade3',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_filter_node_type.inc',
  'hash' => 'a49a3da3983e79c4aa9ff237f1db5fd808117e939d7c619d62b63f95ad333582',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_filter_node_uid_revision.inc',
  'hash' => '40c2c6b4437e1446cfa41ac45fe29ebeeaa2a37796582c068dc37c6c35a1c88c',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_filter_node_version_count.inc',
  'hash' => '62d2b9095bced391c270d5293d239dba135955dc9157db747d01dca64c45bc56',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_handler_sort_node_version_count.inc',
  'hash' => 'b3b3012e04c2d90f7ae810f41748eea58062f291794a840d5ca951dadf22906b',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_plugin_argument_default_node.inc',
  'hash' => 'acd3fd318bcfcee6eac4381b260a539d6d79c63bc0f350932565b0dbe7e05961',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_plugin_argument_validate_node.inc',
  'hash' => '2c8100dcf21a8d1f24a5e8621f9bbc6d7bfdd3c41b7a191d904f8c854df6d02b',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_plugin_row_node_rss.inc',
  'hash' => 'e9f5f676c0be810ccd6aca1f3c28f8ddcbf8af4b19a9bf6b049e6056b15461bc',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/node/views_plugin_row_node_view.inc',
  'hash' => '2b64a6646cb8cfcbc0448133802d6d5effae2afc53d312ed783a87d2125f890e',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/profile/views_handler_field_profile_date.inc',
  'hash' => 'f1f23952836ebc20b7507250adc6ad0544e070a5b9e373afe3825b68c5caacb7',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/profile/views_handler_field_profile_list.inc',
  'hash' => 'f938abe03f7889fe51db5904c7ca40d0675cf3f6d452684dde3eacaef5aa6db6',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/profile/views_handler_filter_profile_selection.inc',
  'hash' => 'ca90aa667fcf313dd5676556b8fda60c587063cab3e9a42695199886f978239c',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/search/views_handler_argument_search.inc',
  'hash' => '8bca051703deede7e59cc3da73c68dcc77952899f76c3308e4853111f744ae5c',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/search/views_handler_field_search_score.inc',
  'hash' => 'b70e66940c7ddf22a9f51475edb99124faf3a1a9fe94cc9131ad5118e49b80f3',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/search/views_handler_filter_search.inc',
  'hash' => '940712aa47b2eb502a7bc8b255250bb7e915e8f89875798f4a0d41013b131e3f',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/search/views_handler_sort_search_score.inc',
  'hash' => 'a9736feee51cb2f54bc5af8a4120aa6027bf6b44d394dc4ac308999f138fe842',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/search/views_plugin_row_search_view.inc',
  'hash' => 'c8d6a5b3f0b2c795b6e7efe9de0c7598ff709aec09455de22b3b26bc366c65a6',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/statistics/views_handler_field_accesslog_path.inc',
  'hash' => 'e514b0ac78bbce36f6fa94bc3d7f39e3506de9bf8f5ffc149efd341f940b246c',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/statistics/views_handler_field_node_counter_timestamp.inc',
  'hash' => '9493e13b361038b41959974e8c9eb9dec7970024d1dc8754c8a5f1044567d7f2',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/statistics/views_handler_field_statistics_numeric.inc',
  'hash' => 'e29fc2f1fe0e5e87cc594ec21dd81a778b7eac3e99518aad1820a3cb0c68aa86',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/system/views_handler_argument_file_fid.inc',
  'hash' => '2e836d50b8a5fffa2e30cb35a2361aae8aef2f2138e90d12f9de20d74c77b622',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/system/views_handler_field_file.inc',
  'hash' => 'b8a83503931abf9d0804b865f28cc9725520afaefde2a36ee8369670098013b3',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/system/views_handler_field_file_extension.inc',
  'hash' => '83f2f4de5bcad4c04c9f338c6afb1cd321f1325cd6908b65bf246626b62cacf4',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/system/views_handler_field_file_filemime.inc',
  'hash' => '8a83f83bd135c71fe2b763f31aaebe6df392a46eee88e8251c15a1be7a96c1da',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/system/views_handler_field_file_status.inc',
  'hash' => 'e61cefaeb45471b0d95d756ac9bba45fe8dca0fb10ac9bd82fd9a32385175118',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/system/views_handler_field_file_uri.inc',
  'hash' => '8edae85b8a83b5439962e73cae1cf1834b77d9c4a157035e2c1b3b265a9e75a4',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/system/views_handler_filter_file_status.inc',
  'hash' => '630e79a1e4186e955fea776b0d6ce4316d30daf0c1b9594a654cd875f8139e17',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/system/views_handler_filter_system_type.inc',
  'hash' => '024f4708e1ad9e626c56dd288590d39ac2b4be316cf265099a9fe7ad0169a97c',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_argument_taxonomy.inc',
  'hash' => '64d79041c19de4a04675db80cbdeb195bd4b7348f05eadc658fec9103d452d47',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_argument_term_node_tid.inc',
  'hash' => 'fe5278a0ca737d4f207fa956f2adf8f875936903af0965f61d1b436ca4546fb4',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_argument_term_node_tid_depth.inc',
  'hash' => '46f0b0c72c912b854e10686297d52183e186e4da16301c047ab2b9966950e2fa',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_argument_term_node_tid_depth_join.inc',
  'hash' => 'bd8af035a5e1849c9bccf519c82df814b5e0905441222559a4db2c685a962099',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_argument_term_node_tid_depth_modifier.inc',
  'hash' => 'a4ae0d39e66a051c3ee6b5e490887c3a12679854e98b620e061bd6e06849db01',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_argument_vocabulary_machine_name.inc',
  'hash' => '53bd1e4831645069b13f9a9646ae9b74c09e07b997ce10a552c32138d685969d',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_argument_vocabulary_vid.inc',
  'hash' => '5187c6e68cbc69b6f9a01513f3a8de5384a9b8795bf68415decdcc08995caf3c',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_field_taxonomy.inc',
  'hash' => '8c57d2bd1f41bcaddb5eefe70dfd6ec98b3f22cf8f37d860f7f6e67c3592f1dc',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_field_term_link_edit.inc',
  'hash' => '5aa6148b1866311d455897c6c62a773b98fa9988a94187eb0e9fb43c76925cc0',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_field_term_node_tid.inc',
  'hash' => '82608d9d6109d1446f70caf5ad176cbdfcef283a1e5fa2d5565c0572f3a9613d',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_filter_term_node_tid.inc',
  'hash' => 'bc4d5a8b9cc3215a2283ea6725ebfbe0cda867b694491d02235abdc621179e57',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_filter_term_node_tid_depth.inc',
  'hash' => '1fc479f4666696940f59cf330cfe22298d77e6587d16b281948ad05a2b1840f1',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_filter_term_node_tid_depth_join.inc',
  'hash' => '52821fd9d53a62ba65e24cb050edc3a7da78a7192e17e2202a8ce996a715dba0',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_filter_vocabulary_machine_name.inc',
  'hash' => 'b8851e7c67a22e8c472417a97a528db0085b9cff614ac43edaf720378d643c8e',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_filter_vocabulary_vid.inc',
  'hash' => 'f15850128ed9a2c4b7b5964e31faf10570a0fa3670cd72afc09589cc0c432995',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_handler_relationship_node_term_data.inc',
  'hash' => '9dff3dd77766232a4c83cfc92197424d4d2839052f7b91326dda39a81d484f34',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_plugin_argument_default_taxonomy_tid.inc',
  'hash' => '3e6610928bbadd83e10f67ec4d508e2f3f848cc9d7a672c122038ccd3d73f315',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/taxonomy/views_plugin_argument_validate_taxonomy_term.inc',
  'hash' => '3ef7a8d1ce5be4885c8d9b6df3fa578acecea6908bbca1f3baa80b511dab426d',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/tracker/views_handler_argument_tracker_comment_user_uid.inc',
  'hash' => 'e2040743a77ba6ffad50b1601df62f6649747496f180a6e481f59cd320fd81ed',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/tracker/views_handler_filter_tracker_boolean_operator.inc',
  'hash' => '0d0dca36d526ed1bd99f52dd91f113fb7fd3740778fb3ce2072bc39f90b9bb17',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/tracker/views_handler_filter_tracker_comment_user_uid.inc',
  'hash' => 'a3cc9f7b3e6052973bea54dd354116eee5962a9b8e57636ee3f1c87577e85d51',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/translation/views_handler_argument_node_tnid.inc',
  'hash' => 'd0493e7d7a6e182b77748ff44e71ed34999a20ac89830654c113e7c9a0d478f5',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/translation/views_handler_field_node_link_translate.inc',
  'hash' => 'fc540176d6cc1d8e756a872f9e3285b607bf255f4b3ee0d9eb29d107df0dd401',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/translation/views_handler_field_node_translation_link.inc',
  'hash' => '91caa7ac0bc4f465c9a5eb7e79ee63474d59e65ba9e2b6a9b5f466ab51d23031',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/translation/views_handler_filter_node_tnid.inc',
  'hash' => '35509bc3b369b3f0fe541bdd86c4afdb32936d18dc52c32bac01b8f7bd3f78fa',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/translation/views_handler_filter_node_tnid_child.inc',
  'hash' => '8b1282ee8b48c61782239982a7c3426033664d2c96c41896ef7decdba00a7655',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/translation/views_handler_relationship_translation.inc',
  'hash' => '9d1ea9929aa0b5cf606732ca713bc6095902be0270ebe3e6a75620afc28be65a',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/user/views_handler_argument_users_roles_rid.inc',
  'hash' => '31d6f0e24e88473a4790f9f97a80d0467a53ae1774583f71f7fce6c9edc1edf2',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/user/views_handler_argument_user_uid.inc',
  'hash' => '6a4ca265f1585c08a7efb5667d0808683d6b1ecb831228b0928d0c7a1a946c41',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/user/views_handler_field_user.inc',
  'hash' => '96b990f39f2ae5c99324b12b4f0d893c4c2b4b14b212261fdd5d0ddc0e95c409',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/user/views_handler_field_user_language.inc',
  'hash' => '156da9e421dd38f498f008c142e6dd515d5da67c44ff0ece4caff9c8f9b70f67',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/user/views_handler_field_user_link.inc',
  'hash' => 'd13886bf45cb49d2dee4823ff21106a10bdd0aa8ac0e387ca69f66729e203fe0',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/user/views_handler_field_user_link_cancel.inc',
  'hash' => '988c31b68a7e71dc4433ca4a72b692b0b9cfddd6d91ecec62435c882fbd88919',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/user/views_handler_field_user_link_edit.inc',
  'hash' => '0224a0f9268705e02e400125243540a5fb4ceda5fb12e700a6c9300df5f595cf',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/user/views_handler_field_user_mail.inc',
  'hash' => '90d20da35decf9afe27f3cf7665a0738ea972e9d3114114d274fb17054b59c97',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/user/views_handler_field_user_name.inc',
  'hash' => 'b791ae2231d2dbfcdeebf4dcdac2b130d101392b2a93d7e1e0ca42eceaa1fb76',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/user/views_handler_field_user_permissions.inc',
  'hash' => 'b0cbd86a6bd690f28b9b2d3c633d7f93153fac910be9dd25b248f7e628d4dfa7',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/user/views_handler_field_user_picture.inc',
  'hash' => 'd8b780012df737e968f83682fc6de9dfbe3a2b81ade2803d68626d77fdf84dab',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/user/views_handler_field_user_roles.inc',
  'hash' => '248953e670fd9c6ee52486d218843e8c19b49f890df41396bf08d519c1392e16',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/user/views_handler_filter_user_current.inc',
  'hash' => '79b9f735c96e097366659876f85668547f788ca22a89edff9e1f8f84e0a4962a',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/user/views_handler_filter_user_name.inc',
  'hash' => 'bce96d7063b6f2f0b231ecf9b23f96c2e0b4fcde880238c2238306b5f4cb76dc',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/user/views_handler_filter_user_permissions.inc',
  'hash' => '9d8e37e0e78f128f8747e90f962a7bf993d76f750caa74b260d76c659394fc4a',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/user/views_handler_filter_user_roles.inc',
  'hash' => '742caf6b6e989b6a2fedf793d8e3d72e7e0444bf3f29b67c7f359fa333c870fd',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/user/views_plugin_argument_default_current_user.inc',
  'hash' => '30ba56c9372cbb73ad332146a795a13058239925e5660e8ef1a2a0a22cf34ba4',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/user/views_plugin_argument_default_user.inc',
  'hash' => 'e187ae191a4cbcceeef81ffe9bf3b4e32300da0763018bf168d274622ec5f168',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/user/views_plugin_argument_validate_user.inc',
  'hash' => '38259ced6b64580ed263571e8dbaded1fa12a8ea61b7790ba5c9f8b2e29108b3',
))
->values(array(
  'filename' => 'sites/all/modules/views/modules/user/views_plugin_row_user_view.inc',
  'hash' => '22c5ecc1886ef06a6faa6ebc22d8c6991af31b518dceb98eae54fcf18e8acc23',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_access.inc',
  'hash' => 'e1528e2faa60f47fd397fc6e272f88fcd1914c41bd942bb0a0f4a5073fbe1b6d',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_access_none.inc',
  'hash' => '52310ea867d6f21a11ced61fc1ba442836ca97c1e3020e1c5b5b5e9af3d29816',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_access_perm.inc',
  'hash' => 'f88fa2a6898e13bbcde8fe8a5786f3a2014b8b7ac830b6c848e6163d0454a5f1',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_access_role.inc',
  'hash' => '061fdcf1410bb0f785333a23e1293b369993ee6dcd95bfdaf686eb56335a91ed',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_argument_default.inc',
  'hash' => '04cb62069593b0d3de1e00b0eabd5e0b7aa4e8eeb0989713bb343edf229e5925',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_argument_default_fixed.inc',
  'hash' => 'e1f7aca5a279585aa6a4ff7e88fb896f25a6a91abab7cee2d8cf5b34f5b409b4',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_argument_default_php.inc',
  'hash' => 'ffcd3d49b72d8de2e73836d02ff00f9b0c6b9b4ddcf4a41cc32e35df3c426931',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_argument_default_raw.inc',
  'hash' => 'ed0f90f89a3618bacbf26377d499cc572c19eceb299bba4ed48fb2b97421321e',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_argument_validate.inc',
  'hash' => '9ae75fc5b1bf52f923c089ff03be6d0b13d3db1fec7c57d2d61765b57438ce28',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_argument_validate_numeric.inc',
  'hash' => 'd895dec65ea4948641a3c58bdacd6482b37b1d1c6bdec3f35b6a0d2e42329277',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_argument_validate_php.inc',
  'hash' => 'd3468db246b5f1274bd35e1926b515f06d3cd3ecfd54d26a914f3b28491a2c71',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_cache.inc',
  'hash' => '4ee5962d4dd833419da18a42383c0c444893c64508b08b5658104a70650a3bf5',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_cache_none.inc',
  'hash' => '5ce14a8ca7887019cacded3bccd24f566519c24452f86baec422d2197b3bc5e0',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_cache_time.inc',
  'hash' => '3783386fae8966111917f2311055c37f8fcad181aa438d5d0637db05dccbe0e4',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_display.inc',
  'hash' => 'a13858784a9e8cc0e5bda9bafb17e2a6ce48e20281134120b9ef0b7bf9fcc3b2',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_display_attachment.inc',
  'hash' => 'f85f3bd80727ec6a0502393f7fdf085e4fb9d2eec4078a323c27de7b2f9328cc',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_display_block.inc',
  'hash' => '1a14418a1e974d0cdacf2b3de77c46de09248e9eec26c44a6fff20f19d642b09',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_display_default.inc',
  'hash' => 'd4bfea9c858c0ab9249dda27863eee45a9a43486fc8fa72a30ebf14a6b86c4ef',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_display_embed.inc',
  'hash' => '400651e11fe9e0e59540eae0f6f8549b7d6f6c1aabe8818f7f6c4c11ad501bf9',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_display_extender.inc',
  'hash' => 'fdb3b0cc4d6f9eedb74c92563b94a7fdfe53e0f2dac89fe212a6624ac3469f92',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_display_feed.inc',
  'hash' => '2cca54e847676142123e8afff71c1d47112483e2da750489c921399d0e2a1d4c',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_display_page.inc',
  'hash' => 'c389d2892fba61e2689ef868a2e67da7b2807328c1f594ce7dbc5abd5c047bac',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_exposed_form.inc',
  'hash' => '3c7c9b281db9d5f08d9d2dd9c9d943ce1f0589a80dad9f8d00d98567cdbffcf3',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_exposed_form_basic.inc',
  'hash' => '75f0c8630ec72a143e95e3695f379b0ee154d80773633f15de0ce80439e930aa',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_exposed_form_input_required.inc',
  'hash' => '72f41fbb87e87b78f69639e9d81b9f0d341995c882a5a93a7a8327b0e1bc8b0a',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_localization.inc',
  'hash' => '157a13a1d7c6d472f2ef179f74389fa31dce9cab1897363f8c45ce9557ce12e8',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_localization_core.inc',
  'hash' => '8feab7c01df92b1a7c6bbfbcaf4f0adf82b6f2adcbd4f50c7680ab3f8ba648aa',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_localization_none.inc',
  'hash' => '9d94a95dc72ce35561697497e9a6152b0b98d2af45039385e90bc3866c70c28b',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_pager.inc',
  'hash' => '1d90d441e667df2d8306380305a9a054062379a74548e4e789bfbba725c1c222',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_pager_full.inc',
  'hash' => 'ab7a1b468a3fd28aaa0cdb3374bdac558861875604e8c8528e9352f8142a1a9d',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_pager_mini.inc',
  'hash' => '95802b0ef913a5d57b869075ffbcbd1912950c5bcda4cc1fd78e7715a35c6f01',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_pager_none.inc',
  'hash' => 'f8bb711d9edede86814821f1f6d2ca940c5b488eeb8980b0ad3b69b69a93e9a8',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_pager_some.inc',
  'hash' => '272f71363f2a94a32997717ef89dcc4683f63b04b8a2a01a9b6dbbea89fcf97c',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_query.inc',
  'hash' => 'a7e36dc3066067004199fa090602e5a9a7869711e3506b6cddb52f48184eb511',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_query_default.inc',
  'hash' => 'd7b858a0360579f752cfb60bd38c796342f38052f1bf8df08b4bfa1f5763ee3d',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_row.inc',
  'hash' => 'f525a18d9b273a890256bcd07caf6dacb1fcc2a38b65b866c16cd006e92de83d',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_row_fields.inc',
  'hash' => '3030f871c046548365156fdb5d7821104408fddeb327f6c685a72b213276eeae',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_row_rss_fields.inc',
  'hash' => 'a37c50686477ed30b3d2a8688ef418e0862ec729ae749b346cc396bcda0be392',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_style.inc',
  'hash' => 'a41847e71fc168dacde596d1557dd9e6d7a3a19d8b90a3a2ea785f7e7292713d',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_style_default.inc',
  'hash' => '1adf156419a1d7748e3633a8ade693b995902c1eca3452c5cf06da4857a961aa',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_style_grid.inc',
  'hash' => 'b055853b4a0d58ceb2e2e761b515734f952073c0bed0725794745b1343ab8573',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_style_jump_menu.inc',
  'hash' => 'f8c6bb1aa5974b4067077eb27eda7f7402c5c6b276332fba1dd4fcb8122d3335',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_style_list.inc',
  'hash' => 'fe74e3fecf15d8579d5e24d25be48dc4214af08775700eccc7b05b5abebbc951',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_style_mapping.inc',
  'hash' => 'c078643b9c6e23e85e83cb9add17ef928556a5339b5bb55422689cdc6edf2523',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_style_rss.inc',
  'hash' => 'a3e57703c3eb05dd8611ecb0d52c5d5aa516e91462cbed9d0f896528ec9ba98f',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_style_summary.inc',
  'hash' => '957f53e4a431f25a653bb0b7e14e43cf568c88c9504fcc75a93c7faa91c9752e',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_style_summary_jump_menu.inc',
  'hash' => '67b177fa07c38983f67e2ba5bdf2a501b06fd7506141b10e612a1f2514718254',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_style_summary_unformatted.inc',
  'hash' => 'dc49a759f04a7da8dd69a88ba57796ace9960b18bd183926bae43e91b59e723a',
))
->values(array(
  'filename' => 'sites/all/modules/views/plugins/views_plugin_style_table.inc',
  'hash' => '26bbbf4a72a486e5b64edeb935c89be7956ce4486c4b38db980a3e0d7ef17e49',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/comment/views_handler_argument_comment_user_uid.test',
  'hash' => '8af12e2b17cd6944698471827c661a1a842bec3acd807f2a457249f6aac0bbf2',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/comment/views_handler_filter_comment_user_uid.test',
  'hash' => 'd62fe3f3257efc0eaf742e3c177ea3f1bd5efb9fc8f91dc1bc5e9e6196085bd7',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/field/views_fieldapi.test',
  'hash' => '09bbaab425a41fd6d40f632313280527e69e24e79b3719867dcb61ed4b583187',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handlers.test',
  'hash' => '44f3dd30909d43e250c726e312290a522131c7f0d3048fc5f8583fc8c5986f72',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_area_text.test',
  'hash' => '3553a85c6d86992a17029eac182b486940393cee0c06380cf9f60ed208a57b5f',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_argument_null.test',
  'hash' => 'e9adbe3e322cc8b536d79b5b915cab97102199abf2a14ad7a6374cfd18246372',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_field.test',
  'hash' => 'd4a833179c4f9aa57c42ef951b9e6d5a9304281e7aeb8c7dbe92ed6b24251cb4',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_field_boolean.test',
  'hash' => 'c9f409147fe545a413b365ee37e0758a47291165effc76f0ae8743f84915053d',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_field_counter.test',
  'hash' => '86f4514cfa72192034db1ef70723cb2b2b1ffde6e4e5fb4212ec959cd5697ba6',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_field_custom.test',
  'hash' => '57d1f7d01e57f8e2a9694340684344f5e7d6d5c90bad8679aba591192c1f6a2d',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_field_date.test',
  'hash' => '27f9b23bc31068a3f2a2f5b6678388dd4175b66f758b60e9a996e061a2e3a789',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_field_file_extension.test',
  'hash' => '0f9c376f31ca47ecc0f01548d451c548ef7bebe8a07974def77e6725badda4e6',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_field_file_size.test',
  'hash' => '9c951d86dad9df3fca72b20abcb1345a0473578324a454c75d8a5a22e8b68015',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_field_math.test',
  'hash' => 'bbf418c1be15c20d4ddf09add1620f19ff91dc66611e8426a5528900ad9baf60',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_field_url.test',
  'hash' => '0c0e54a93ffd5890b81807e0d0440d061f771fafc6d99943d5d9dfc4a1702686',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_field_xss.test',
  'hash' => '17f33ec5473f0ddf8fbce6a3dfe3e65c0e51b7b13a0afc1b6d3dcf3667d4d83b',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_filter_combine.test',
  'hash' => '40dd1c5db7f8f225999dd1f7acd616269ad6d67155dcb8f843349597ac5a0a13',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_filter_date.test',
  'hash' => 'a26c239c803507d2716ad35c4b3ee6b5339628f45d46dcd2a5d505769309c503',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_filter_equality.test',
  'hash' => 'df783f081546df2f3f77ac69665cd95a5725bdccc5673ab35a79a59aca08ce1a',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_filter_in_operator.test',
  'hash' => '89420a4071677232e0eb82b184b37b818a82bdb2ff90a8b21293f9ecb21808bf',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_filter_numeric.test',
  'hash' => '818f73baea9d062dbc7e4ef35444c6cbb26b4b60ed3972c6d9e697162c755d05',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_filter_string.test',
  'hash' => '33eec214b52abf24b54fa7eae0758f9f0cd59468c11829f87f575baa2017b84e',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_manytoone.test',
  'hash' => '42466036b7dbd70e4dba185961390b2eebfba78b6aec08a75501d8276207d4b9',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_sort.test',
  'hash' => 'ace33efab99798d8221871038b2298b9e645f22278dd015dda5fac6688ee54ee',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_sort_date.test',
  'hash' => '4f997b2d2afdb64747b087c7e118287bc58872d72740e5004e17e5ee6ef643c7',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/handlers/views_handler_sort_random.test',
  'hash' => '9ff72485303fd209ef748c65d0cb52078400985b54f256b82f1b3bb28a323a1f',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/node/views_node_revision_relations.test',
  'hash' => '108f56a3381d1c9a72f85d5a681ebeff66c587d032d13ed229dfc32c7d0195d7',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/plugins/views_plugin_display.test',
  'hash' => 'fb9399398d003056fe5b7d79f67de93b6a79a2a651f1041c73d5beedf632bfde',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/styles/views_plugin_style.test',
  'hash' => 'ec6258fd8ae26ac1832cf2ad9d0f5625965168126413ed6dc7798d09b658db03',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/styles/views_plugin_style_base.test',
  'hash' => '54fb7816d18416d8b0db67e9f55aa2aa50ac204eb9311be14b6700b7d7a95ae7',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/styles/views_plugin_style_jump_menu.test',
  'hash' => 'a78de0a289d2813b8b0c4a841c147d8e9c4a2dd6f6b8a7c89b7a62a9daee2520',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/styles/views_plugin_style_mapping.test',
  'hash' => 'c0e4768100d803b5f1e48c2883ebb9951e538bd72cf4a7325a7c5c7970c2967a',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/styles/views_plugin_style_unformatted.test',
  'hash' => 'd22239d0812c2f28df86b1742a0968c8ce76f120072a7bf5631b839967ff757a',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/taxonomy/views_handler_relationship_node_term_data.test',
  'hash' => '6c4b72146690700987abca3f746e01278c0866438d5324263766fc4493802e12',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/test_handlers/views_test_area_access.inc',
  'hash' => 'bcf28fc741476430d6904d35a81c5d11ae2b99b91a44b513fedfe452d66e2cb6',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/test_plugins/views_test_plugin_access_test_dynamic.inc',
  'hash' => 'd6fbf2f48808f6347c8cb9049bc94c1762eed36e034df3bec23baad23b3454df',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/test_plugins/views_test_plugin_access_test_static.inc',
  'hash' => '38578c3e1ca4cec8e75fa088fc274390baf01335c226e4791b2a498bb62b0633',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/test_plugins/views_test_plugin_style_test_mapping.inc',
  'hash' => 'd5a1752b2d751359aaa6600f94f9e2cda903ffb580781cedc0ded7ea795f6024',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/user/views_handler_field_user_name.test',
  'hash' => 'fa92b2055c02ea2c3cd5f9619848f299cc83a3d21638a7dd44804ea9e0644ad0',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/user/views_user.test',
  'hash' => '59c88fe311319773d8d2e9d76b4f6b6f5731c86797e47760ec585295c376853c',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/user/views_user_argument_default.test',
  'hash' => 'a2026a55bec3bfd84601f4c03ba5a284732f9797c61c175a906b11a8fbe8effc',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/user/views_user_argument_validate.test',
  'hash' => '954b4b5886e74f20a113032734dfca6e5c1cfc068d31a5b9ba428337659a44e3',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_access.test',
  'hash' => '3f17cc9257c3c12f24197106b27654e811801fc5d5639022e23a98c7b45e4d7f',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_ajax.test',
  'hash' => '9741ae5e85382066f5a6401d1d85b333dedd741d13194c4dafcdc0ca81441e7b',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_analyze.test',
  'hash' => 'f521c5e3c781d6eaf1ad58536a875c2c8cefc973a23087073653f397b7de89df',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_argument_default.test',
  'hash' => 'de7a8eb60e71b6bc2996d636bb91aa6c9c3adca6f857300b13c1e650d07ad66e',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_argument_validator.test',
  'hash' => '8fe3d99942cd98f981a08ab49b09eb8bb2cf1e2fb09b53dc1030abb59611edba',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_basic.test',
  'hash' => 'e3715a9df468b1c2decb4d8a068a68ca6a3f8bd467066634075ee643d6cabb60',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_cache.test',
  'hash' => '325ac3e8100fe1c9aa065a72bdd238c863bf51da269d2a686a36060d05ede112',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_clone.test',
  'hash' => '99176a985b8e7ce8a83214f2a98a66394a2ebe7a852192e82f50d359bee89052',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_exposed_form.test',
  'hash' => '0427bd048cab45f3f07aca9f96e8e8f083f464ca61975c107f63988ec9fbc9a1',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_glossary.test',
  'hash' => 'f585ecf6a0b10d956b4010ccef44f19db11da52fa2d25380e97c4eded6ad199f',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_groupby.test',
  'hash' => 'db01e228395517ed4d0d8fa234a63a14781068f60e54d07e40ae7ef12052394d',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_handlers.test',
  'hash' => '87f9e7bd3afa75f79bb1f3cdfff0b76fc4199174e197459b7c3f985c8256ffcd',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_handler_filter.test',
  'hash' => '39f2aade9f7d32ca2dd3d22fe3c36eb973695e315e8bca6dd76cb72fd5734779',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_module.test',
  'hash' => '2640ac503d4a832258f8836459b9228a6ce39849d199d407f85ff4a9d939c7a8',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_pager.test',
  'hash' => 'fd1e54a66c8f4c4b7bc811cf0466ea1c7bb8d961b8b592d2101ae168dbc8f613',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_plugin_localization_test.inc',
  'hash' => 'db13bd5e57b137f6cf0d06789b2429e33b429d5e001e1e99c6afbac38944d050',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_query.test',
  'hash' => 'e7f5b1449539805086fd2b10239c8f702851a3dbefe8e93a89d85ab75361e9ff',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_test.views_default.inc',
  'hash' => '1245b6883b9ce5169d5ea21cd951794a33f87ed16305205a35f2157f6152ab93',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_translatable.test',
  'hash' => '09e2091a84268085a75992b30b761c76a58b8ca2c1612e41d899c180ff8d9066',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_ui.test',
  'hash' => 'fbd2f7ed1320f28dc7ac17949296199218f9f10ee18bdc6c35c75c75e68876fb',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_upgrade.test',
  'hash' => 'ebebe64dc1fd8b70908e11e6ad4e7b81c4ab472d3da4773fd6f46932764fc60e',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_view.test',
  'hash' => '9fc3e62bfa6ad01bbf71b9b2ff065466290de378bd7adc28943dba1c1364fc83',
))
->values(array(
  'filename' => 'sites/all/modules/webform/includes/exporters/webform_exporter.inc',
  'hash' => '8c4728cb3708a4e0696f862d1e7c3158e197f9229f35bd22af1d02733d68e64c',
))
->values(array(
  'filename' => 'sites/all/modules/webform/includes/exporters/webform_exporter_delimited.inc',
  'hash' => '8b4cf8874d1f65ea28c68650ddcebf8d9942369b28c1e16a159ddf3e67592732',
))
->values(array(
  'filename' => 'sites/all/modules/webform/includes/exporters/webform_exporter_excel_delimited.inc',
  'hash' => 'b0a1a07ecae9704b85e7618b497025340036f6d65f5cc56968f2de8fb5106e3c',
))
->values(array(
  'filename' => 'sites/all/modules/webform/includes/exporters/webform_exporter_excel_xlsx.inc',
  'hash' => 'de72554a8c76c1eaf158eebbbe286dc2c2af62e5fb03ab34870e24d9656d2445',
))
->values(array(
  'filename' => 'sites/all/modules/webform/includes/webform.webformconditionals.inc',
  'hash' => 'f3f03d6dd81698c9f309657940735a5b5a11910d7961513d65dd47aae081450e',
))
->values(array(
  'filename' => 'sites/all/modules/webform/tests/WebformComponentsTestCase.test',
  'hash' => 'ec7d75134bd2c19eaeecb857fed561a53254f4de4c51871b4475687f2c908fd7',
))
->values(array(
  'filename' => 'sites/all/modules/webform/tests/WebformConditionalsTestCase.test',
  'hash' => '92c206ab6a7e459b54d0d5f462e1e3870bdc427e15e89f6fce72473433f1276e',
))
->values(array(
  'filename' => 'sites/all/modules/webform/tests/WebformGeneralTestCase.test',
  'hash' => 'd9b4fe1fc2b75722eb173bd208b6d61c9ac839d8270f7e6d6a755ae78240f2b8',
))
->values(array(
  'filename' => 'sites/all/modules/webform/tests/WebformPermissionsTestCase.test',
  'hash' => '495960f5ff8d9db6a3e071d49be7818c043370acccb5c01fa1ffdb427cdd1989',
))
->values(array(
  'filename' => 'sites/all/modules/webform/tests/WebformSubmissionTestCase.test',
  'hash' => '05005575be173b2ac651d1917fa591d487ead385960bb5cfb29c47328198c990',
))
->values(array(
  'filename' => 'sites/all/modules/webform/tests/WebformTestCase.test',
  'hash' => '2b585e6c24cea87e28c9c5c29dc412019985e4eaba5ad41f30f66d67be5e55d3',
))
->values(array(
  'filename' => 'sites/all/modules/webform/tests/WebformUnitTestCase.test',
  'hash' => 'a63813926d365b45a3874e87efd381111ef8bf09e92179bba889b169b45a50f8',
))
->values(array(
  'filename' => 'sites/all/modules/webform/views/webform_handler_area_result_pager.inc',
  'hash' => 'd920f260e0be7e90b857e8fdec34ab53f4b647f3d33e75305540bf012bb0d1cb',
))
->values(array(
  'filename' => 'sites/all/modules/webform/views/webform_handler_field_form_body.inc',
  'hash' => 'eb5f6abf5e89a96d465a2725df9dd1abedc487f600bb720631fe4d95d2196981',
))
->values(array(
  'filename' => 'sites/all/modules/webform/views/webform_handler_field_is_draft.inc',
  'hash' => '6a6e1da0e20776fb7b125b5347545ffdd816b2b967082c8ebac7de8c52c02dce',
))
->values(array(
  'filename' => 'sites/all/modules/webform/views/webform_handler_field_node_link_edit.inc',
  'hash' => '0de291d7d01905b370262e0efb95c35f911284e417c6b5ebd64f7f68394fa1c7',
))
->values(array(
  'filename' => 'sites/all/modules/webform/views/webform_handler_field_node_link_results.inc',
  'hash' => '56dde719429262e52db86c2b11d0269a71ac6755f399b7d5c30a464d9c2456ab',
))
->values(array(
  'filename' => 'sites/all/modules/webform/views/webform_handler_field_submission_count.inc',
  'hash' => '26495f7abe8dbdcc3673539734ed01edb869849e5ac175ec9c771dddab1dccc5',
))
->values(array(
  'filename' => 'sites/all/modules/webform/views/webform_handler_field_submission_data.inc',
  'hash' => '150b55041533aefbdde84baf84ac5853e2838af7264a437bd580be81728fda84',
))
->values(array(
  'filename' => 'sites/all/modules/webform/views/webform_handler_field_submission_link.inc',
  'hash' => '1174037ab690ba8d32c4f8ccfc7c8784403c178bdceee5283f70e181ffeb9886',
))
->values(array(
  'filename' => 'sites/all/modules/webform/views/webform_handler_field_webform_status.inc',
  'hash' => 'c6e6f7701a35ff89945dcbff81b4abc63237e4cacd710f2456bda11b86856b84',
))
->values(array(
  'filename' => 'sites/all/modules/webform/views/webform_handler_filter_is_draft.inc',
  'hash' => 'f4260dce44c0a4d58219ea54ce3bf01b485fc49e0fa1cec61d78c6f733b2aeef',
))
->values(array(
  'filename' => 'sites/all/modules/webform/views/webform_handler_filter_submission_data.inc',
  'hash' => 'eeb1cf085a9a566974461a3cf62e824e31ef6bfe89d0c5bf9a77ebd4798f5fa8',
))
->values(array(
  'filename' => 'sites/all/modules/webform/views/webform_handler_filter_webform_status.inc',
  'hash' => '62e1e262e406a8d214720dc1e3bcf7dab081edfd33e87d9a5fa360b06f4166f7',
))
->values(array(
  'filename' => 'sites/all/modules/webform/views/webform_handler_numeric_data.inc',
  'hash' => 'f9c873d0ecae95774e04849e7ab41413cf2bd645751ab1f175decf8c7a5d81e7',
))
->values(array(
  'filename' => 'sites/all/modules/webform/views/webform_handler_relationship_submission_data.inc',
  'hash' => 'cc2801c2aa85f4bc0237350f3c162db6e7181b0fc80ea83af9b644d457e5d4a4',
))
->values(array(
  'filename' => 'sites/all/modules/webform/views/webform_plugin_row_submission_view.inc',
  'hash' => '2f9f1de24b95f9aabe06306a248cffdd3c2e5b202f714a286ec6c6d79b793419',
))
->execute();
$connection->schema()->createTable('role', array(
  'fields' => array(
    'rid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'rid',
  ),
  'unique keys' => array(
    'name' => array(
      'name',
    ),
  ),
  'indexes' => array(
    'name_weight' => array(
      'name',
      'weight',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('role')
->fields(array(
  'rid',
  'name',
  'weight',
))
->values(array(
  'rid' => '1',
  'name' => 'anonymous user',
  'weight' => '0',
))
->values(array(
  'rid' => '2',
  'name' => 'authenticated user',
  'weight' => '1',
))
->values(array(
  'rid' => '3',
  'name' => 'webform admin',
  'weight' => '2',
))
->execute();
$connection->schema()->createTable('role_permission', array(
  'fields' => array(
    'rid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'permission' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'rid',
    'permission',
  ),
  'indexes' => array(
    'permission' => array(
      'permission',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('role_permission')
->fields(array(
  'rid',
  'permission',
  'module',
))
->values(array(
  'rid' => '1',
  'permission' => 'access content',
  'module' => 'node',
))
->values(array(
  'rid' => '2',
  'permission' => 'access content',
  'module' => 'node',
))
->values(array(
  'rid' => '2',
  'permission' => 'access own webform submissions',
  'module' => 'webform',
))
->values(array(
  'rid' => '2',
  'permission' => 'delete own webform submissions',
  'module' => 'webform',
))
->values(array(
  'rid' => '2',
  'permission' => 'edit own webform submissions',
  'module' => 'webform',
))
->values(array(
  'rid' => '2',
  'permission' => 'use text format filtered_html',
  'module' => 'filter',
))
->values(array(
  'rid' => '3',
  'permission' => 'access all webform results',
  'module' => 'webform',
))
->values(array(
  'rid' => '3',
  'permission' => 'access own webform results',
  'module' => 'webform',
))
->values(array(
  'rid' => '3',
  'permission' => 'create page content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'create webform content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'create webform_custom content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'delete own page content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'delete own webform content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'delete own webform_custom content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit any page content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit any webform content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit any webform_custom content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit own page content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit own webform content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit own webform_custom content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit webform components',
  'module' => 'webform',
))
->values(array(
  'rid' => '3',
  'permission' => 'use text format filtered_html',
  'module' => 'filter',
))
->values(array(
  'rid' => '3',
  'permission' => 'view own unpublished content',
  'module' => 'node',
))
->execute();
$connection->schema()->createTable('semaphore', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'value' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'expire' => array(
      'type' => 'float',
      'not null' => TRUE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'name',
  ),
  'indexes' => array(
    'value' => array(
      'value',
    ),
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('sequences', array(
  'fields' => array(
    'value' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'value',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('sequences')
->fields(array(
  'value',
))
->values(array(
  'value' => '3',
))
->execute();
$connection->schema()->createTable('sessions', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'sid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ),
    'ssid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'session' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'sid',
    'ssid',
  ),
  'indexes' => array(
    'timestamp' => array(
      'timestamp',
    ),
    'uid' => array(
      'uid',
    ),
    'ssid' => array(
      'ssid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('system', array(
  'fields' => array(
    'filename' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'owner' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'bootstrap' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'schema_version' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '-1',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'info' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'filename',
  ),
  'indexes' => array(
    'system_list' => array(
      'status',
      'bootstrap',
      'type',
      'weight',
      'name',
    ),
    'type_name' => array(
      'type',
      'name',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('system')
->fields(array(
  'filename',
  'name',
  'type',
  'owner',
  'status',
  'bootstrap',
  'schema_version',
  'weight',
  'info',
))
->values(array(
  'filename' => 'modules/aggregator/aggregator.module',
  'name' => 'aggregator',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:10:"Aggregator";s:11:"description";s:57:"Aggregates syndicated content (RSS, RDF, and Atom feeds).";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:15:"aggregator.test";}s:9:"configure";s:41:"admin/config/services/aggregator/settings";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:14:"aggregator.css";s:33:"modules/aggregator/aggregator.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/aggregator/tests/aggregator_test.module',
  'name' => 'aggregator_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:23:"Aggregator module tests";s:11:"description";s:46:"Support module for aggregator related testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/block/block.module',
  'name' => 'block',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7009',
  'weight' => '-5',
  'info' => 'a:13:{s:4:"name";s:5:"Block";s:11:"description";s:140:"Controls the visual building blocks a page is constructed with. Blocks are boxes of content rendered into an area, or region, of a web page.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"block.test";}s:9:"configure";s:21:"admin/structure/block";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/block/tests/block_test.module',
  'name' => 'block_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Block test";s:11:"description";s:21:"Provides test blocks.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/blog/blog.module',
  'name' => 'blog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:4:"Blog";s:11:"description";s:25:"Enables multi-user blogs.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"blog.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/book/book.module',
  'name' => 'book',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:4:"Book";s:11:"description";s:66:"Allows users to create and organize related content in an outline.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"book.test";}s:9:"configure";s:27:"admin/content/book/settings";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"book.css";s:21:"modules/book/book.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/color/color.module',
  'name' => 'color',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:5:"Color";s:11:"description";s:70:"Allows administrators to change the color scheme of compatible themes.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"color.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/comment/comment.module',
  'name' => 'comment',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:7:"Comment";s:11:"description";s:57:"Allows users to comment on and discuss published content.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:4:"text";}s:5:"files";a:2:{i:0;s:14:"comment.module";i:1;s:12:"comment.test";}s:9:"configure";s:21:"admin/content/comment";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:11:"comment.css";s:27:"modules/comment/comment.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/contact/contact.module',
  'name' => 'contact',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:7:"Contact";s:11:"description";s:61:"Enables the use of both personal and site-wide contact forms.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"contact.test";}s:9:"configure";s:23:"admin/structure/contact";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/contextual/contextual.module',
  'name' => 'contextual',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:16:"Contextual links";s:11:"description";s:75:"Provides contextual links to perform actions related to elements on a page.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:15:"contextual.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/dashboard/dashboard.module',
  'name' => 'dashboard',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:9:"Dashboard";s:11:"description";s:136:"Provides a dashboard page in the administrative interface for organizing administrative tasks and tracking information within your site.";s:4:"core";s:3:"7.x";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:5:"files";a:1:{i:0;s:14:"dashboard.test";}s:12:"dependencies";a:1:{i:0;s:5:"block";}s:9:"configure";s:25:"admin/dashboard/customize";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/dblog/dblog.module',
  'name' => 'dblog',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '1',
  'schema_version' => '7003',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:16:"Database logging";s:11:"description";s:47:"Logs and records system events to the database.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"dblog.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/field.module',
  'name' => 'field',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7004',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:5:"Field";s:11:"description";s:57:"Field API to add fields to entities like nodes and users.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:4:{i:0;s:12:"field.module";i:1;s:16:"field.attach.inc";i:2;s:20:"field.info.class.inc";i:3;s:16:"tests/field.test";}s:12:"dependencies";a:1:{i:0;s:17:"field_sql_storage";}s:8:"required";b:1;s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:15:"theme/field.css";s:29:"modules/field/theme/field.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/field_sql_storage/field_sql_storage.module',
  'name' => 'field_sql_storage',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7002',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:17:"Field SQL storage";s:11:"description";s:37:"Stores field data in an SQL database.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:22:"field_sql_storage.test";}s:8:"required";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/list/list.module',
  'name' => 'list',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7002',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:4:"List";s:11:"description";s:69:"Defines list field types. Use with Options to create selection lists.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:12:"dependencies";a:2:{i:0;s:5:"field";i:1;s:7:"options";}s:5:"files";a:1:{i:0;s:15:"tests/list.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/list/tests/list_test.module',
  'name' => 'list_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:9:"List test";s:11:"description";s:41:"Support module for the List module tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/number/number.module',
  'name' => 'number',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:6:"Number";s:11:"description";s:28:"Defines numeric field types.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:11:"number.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/options/options.module',
  'name' => 'options',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:7:"Options";s:11:"description";s:82:"Defines selection, check box and radio button widgets for text and numeric fields.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:12:"options.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/text/text.module',
  'name' => 'text',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7000',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:4:"Text";s:11:"description";s:32:"Defines simple text field types.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:9:"text.test";}s:8:"required";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:11:"explanation";s:73:"Field type(s) in use - see <a href="/admin/reports/fields">Field list</a>";}',
))
->values(array(
  'filename' => 'modules/field/tests/field_test.module',
  'name' => 'field_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:14:"Field API Test";s:11:"description";s:39:"Support module for the Field API tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:5:"files";a:1:{i:0;s:21:"field_test.entity.inc";}s:7:"version";s:4:"7.72";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field_ui/field_ui.module',
  'name' => 'field_ui',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:8:"Field UI";s:11:"description";s:33:"User interface for the Field API.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:13:"field_ui.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/file/file.module',
  'name' => 'file',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:4:"File";s:11:"description";s:26:"Defines a file field type.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:15:"tests/file.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/file/tests/file_module_test.module',
  'name' => 'file_module_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:9:"File test";s:11:"description";s:53:"Provides hooks for testing File module functionality.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/filter/filter.module',
  'name' => 'filter',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7010',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:6:"Filter";s:11:"description";s:43:"Filters content in preparation for display.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"filter.test";}s:8:"required";b:1;s:9:"configure";s:28:"admin/config/content/formats";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/forum/forum.module',
  'name' => 'forum',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:5:"Forum";s:11:"description";s:27:"Provides discussion forums.";s:12:"dependencies";a:2:{i:0;s:8:"taxonomy";i:1;s:7:"comment";}s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"forum.test";}s:9:"configure";s:21:"admin/structure/forum";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"forum.css";s:23:"modules/forum/forum.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/help/help.module',
  'name' => 'help',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:4:"Help";s:11:"description";s:35:"Manages the display of online help.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"help.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/image/image.module',
  'name' => 'image',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7005',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:5:"Image";s:11:"description";s:34:"Provides image manipulation tools.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:4:"file";}s:5:"files";a:1:{i:0;s:10:"image.test";}s:9:"configure";s:31:"admin/config/media/image-styles";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/image/tests/image_module_test.module',
  'name' => 'image_module_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Image test";s:11:"description";s:69:"Provides hook implementations for testing Image module functionality.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:24:"image_module_test.module";}s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/locale/locale.module',
  'name' => 'locale',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:6:"Locale";s:11:"description";s:119:"Adds language handling functionality and enables the translation of the user interface to languages other than English.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"locale.test";}s:9:"configure";s:30:"admin/config/regional/language";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/locale/tests/locale_test.module',
  'name' => 'locale_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:11:"Locale Test";s:11:"description";s:42:"Support module for the locale layer tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/menu/menu.module',
  'name' => 'menu',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:4:"Menu";s:11:"description";s:60:"Allows administrators to customize the site navigation menu.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"menu.test";}s:9:"configure";s:20:"admin/structure/menu";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/node/node.module',
  'name' => 'node',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7016',
  'weight' => '0',
  'info' => 'a:15:{s:4:"name";s:4:"Node";s:11:"description";s:66:"Allows content to be submitted to the site and displayed on pages.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:11:"node.module";i:1;s:9:"node.test";}s:8:"required";b:1;s:9:"configure";s:21:"admin/structure/types";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"node.css";s:21:"modules/node/node.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/node/tests/node_access_test.module',
  'name' => 'node_access_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:24:"Node module access tests";s:11:"description";s:43:"Support module for node permission testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/node/tests/node_test.module',
  'name' => 'node_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:17:"Node module tests";s:11:"description";s:40:"Support module for node related testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/node/tests/node_test_exception.module',
  'name' => 'node_test_exception',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:27:"Node module exception tests";s:11:"description";s:50:"Support module for node related exception testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/openid/openid.module',
  'name' => 'openid',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:6:"OpenID";s:11:"description";s:48:"Allows users to log into your site using OpenID.";s:7:"version";s:4:"7.72";s:7:"package";s:4:"Core";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"openid.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/openid/tests/openid_test.module',
  'name' => 'openid_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:21:"OpenID dummy provider";s:11:"description";s:33:"OpenID provider used for testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:6:"openid";}s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/overlay/overlay.module',
  'name' => 'overlay',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:7:"Overlay";s:11:"description";s:59:"Displays the Drupal administration interface in an overlay.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/path/path.module',
  'name' => 'path',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:4:"Path";s:11:"description";s:28:"Allows users to rename URLs.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"path.test";}s:9:"configure";s:24:"admin/config/search/path";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/php/php.module',
  'name' => 'php',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:10:"PHP filter";s:11:"description";s:50:"Allows embedded PHP code/snippets to be evaluated.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:8:"php.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/poll/poll.module',
  'name' => 'poll',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:4:"Poll";s:11:"description";s:95:"Allows your site to capture votes on different topics in the form of multiple choice questions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"poll.test";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"poll.css";s:21:"modules/poll/poll.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/profile/profile.module',
  'name' => 'profile',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:7:"Profile";s:11:"description";s:36:"Supports configurable user profiles.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"profile.test";}s:9:"configure";s:27:"admin/config/people/profile";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/rdf/rdf.module',
  'name' => 'rdf',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:3:"RDF";s:11:"description";s:148:"Enriches your content with metadata to let other applications (e.g. search engines, aggregators) better understand its relationships and attributes.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:8:"rdf.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/rdf/tests/rdf_test.module',
  'name' => 'rdf_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:16:"RDF module tests";s:11:"description";s:38:"Support module for RDF module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:4:"blog";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/search/search.module',
  'name' => 'search',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:6:"Search";s:11:"description";s:36:"Enables site-wide keyword searching.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:19:"search.extender.inc";i:1;s:11:"search.test";}s:9:"configure";s:28:"admin/config/search/settings";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:10:"search.css";s:25:"modules/search/search.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/search/tests/search_embedded_form.module',
  'name' => 'search_embedded_form',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:20:"Search embedded form";s:11:"description";s:59:"Support module for search module testing of embedded forms.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/search/tests/search_extra_type.module',
  'name' => 'search_extra_type',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:16:"Test search type";s:11:"description";s:41:"Support module for search module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/search/tests/search_node_tags.module',
  'name' => 'search_node_tags',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:21:"Test search node tags";s:11:"description";s:44:"Support module for Node search tags testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/shortcut/shortcut.module',
  'name' => 'shortcut',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:8:"Shortcut";s:11:"description";s:60:"Allows users to manage customizable lists of shortcut links.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:13:"shortcut.test";}s:9:"configure";s:36:"admin/config/user-interface/shortcut";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/simpletest.module',
  'name' => 'simpletest',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:7:"Testing";s:11:"description";s:53:"Provides a framework for unit and functional testing.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:51:{i:0;s:15:"simpletest.test";i:1;s:24:"drupal_web_test_case.php";i:2;s:18:"tests/actions.test";i:3;s:15:"tests/ajax.test";i:4;s:16:"tests/batch.test";i:5;s:15:"tests/boot.test";i:6;s:20:"tests/bootstrap.test";i:7;s:16:"tests/cache.test";i:8;s:17:"tests/common.test";i:9;s:24:"tests/database_test.test";i:10;s:22:"tests/entity_crud.test";i:11;s:32:"tests/entity_crud_hook_test.test";i:12;s:23:"tests/entity_query.test";i:13;s:16:"tests/error.test";i:14;s:15:"tests/file.test";i:15;s:23:"tests/filetransfer.test";i:16;s:15:"tests/form.test";i:17;s:16:"tests/graph.test";i:18;s:16:"tests/image.test";i:19;s:15:"tests/lock.test";i:20;s:15:"tests/mail.test";i:21;s:15:"tests/menu.test";i:22;s:17:"tests/module.test";i:23;s:16:"tests/pager.test";i:24;s:19:"tests/password.test";i:25;s:15:"tests/path.test";i:26;s:19:"tests/registry.test";i:27;s:28:"tests/request_sanitizer.test";i:28;s:17:"tests/schema.test";i:29;s:18:"tests/session.test";i:30;s:20:"tests/tablesort.test";i:31;s:16:"tests/theme.test";i:32;s:18:"tests/unicode.test";i:33;s:17:"tests/update.test";i:34;s:17:"tests/xmlrpc.test";i:35;s:26:"tests/upgrade/upgrade.test";i:36;s:34:"tests/upgrade/upgrade.comment.test";i:37;s:33:"tests/upgrade/upgrade.filter.test";i:38;s:32:"tests/upgrade/upgrade.forum.test";i:39;s:33:"tests/upgrade/upgrade.locale.test";i:40;s:31:"tests/upgrade/upgrade.menu.test";i:41;s:31:"tests/upgrade/upgrade.node.test";i:42;s:35:"tests/upgrade/upgrade.taxonomy.test";i:43;s:34:"tests/upgrade/upgrade.trigger.test";i:44;s:39:"tests/upgrade/upgrade.translatable.test";i:45;s:33:"tests/upgrade/upgrade.upload.test";i:46;s:31:"tests/upgrade/upgrade.user.test";i:47;s:36:"tests/upgrade/update.aggregator.test";i:48;s:33:"tests/upgrade/update.trigger.test";i:49;s:31:"tests/upgrade/update.field.test";i:50;s:30:"tests/upgrade/update.user.test";}s:9:"configure";s:41:"admin/config/development/testing/settings";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/actions_loop_test.module',
  'name' => 'actions_loop_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:17:"Actions loop test";s:11:"description";s:39:"Support module for action loop testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/ajax_forms_test.module',
  'name' => 'ajax_forms_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:26:"AJAX form test mock module";s:11:"description";s:25:"Test for AJAX form calls.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/ajax_test.module',
  'name' => 'ajax_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:9:"AJAX Test";s:11:"description";s:40:"Support module for AJAX framework tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/batch_test.module',
  'name' => 'batch_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:14:"Batch API test";s:11:"description";s:35:"Support module for Batch API tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/boot_test_1.module',
  'name' => 'boot_test_1',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:21:"Early bootstrap tests";s:11:"description";s:39:"A support module for hook_boot testing.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/boot_test_2.module',
  'name' => 'boot_test_2',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:21:"Early bootstrap tests";s:11:"description";s:44:"A support module for hook_boot hook testing.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/common_test.module',
  'name' => 'common_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:11:"Common Test";s:11:"description";s:32:"Support module for Common tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:15:"common_test.css";s:40:"modules/simpletest/tests/common_test.css";}s:5:"print";a:1:{s:21:"common_test.print.css";s:46:"modules/simpletest/tests/common_test.print.css";}}s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/common_test_cron_helper.module',
  'name' => 'common_test_cron_helper',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:23:"Common Test Cron Helper";s:11:"description";s:56:"Helper module for CronRunTestCase::testCronExceptions().";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/database_test.module',
  'name' => 'database_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:13:"Database Test";s:11:"description";s:40:"Support module for Database layer tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/drupal_autoload_test/drupal_autoload_test.module',
  'name' => 'drupal_autoload_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:25:"Drupal code registry test";s:11:"description";s:45:"Support module for testing the code registry.";s:5:"files";a:2:{i:0;s:34:"drupal_autoload_test_interface.inc";i:1;s:30:"drupal_autoload_test_class.inc";}s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/drupal_system_listing_compatible_test/drupal_system_listing_compatible_test.module',
  'name' => 'drupal_system_listing_compatible_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:37:"Drupal system listing compatible test";s:11:"description";s:62:"Support module for testing the drupal_system_listing function.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/drupal_system_listing_incompatible_test/drupal_system_listing_incompatible_test.module',
  'name' => 'drupal_system_listing_incompatible_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:39:"Drupal system listing incompatible test";s:11:"description";s:62:"Support module for testing the drupal_system_listing function.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/entity_cache_test.module',
  'name' => 'entity_cache_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:17:"Entity cache test";s:11:"description";s:40:"Support module for testing entity cache.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:28:"entity_cache_test_dependency";}s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/entity_cache_test_dependency.module',
  'name' => 'entity_cache_test_dependency',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:28:"Entity cache test dependency";s:11:"description";s:51:"Support dependency module for testing entity cache.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/entity_crud_hook_test.module',
  'name' => 'entity_crud_hook_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:22:"Entity CRUD Hooks Test";s:11:"description";s:35:"Support module for CRUD hook tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/entity_query_access_test.module',
  'name' => 'entity_query_access_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:24:"Entity query access test";s:11:"description";s:49:"Support module for checking entity query results.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/error_test.module',
  'name' => 'error_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Error test";s:11:"description";s:47:"Support module for error and exception testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/file_test.module',
  'name' => 'file_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:9:"File test";s:11:"description";s:39:"Support module for file handling tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:16:"file_test.module";}s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/filter_test.module',
  'name' => 'filter_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:18:"Filter test module";s:11:"description";s:33:"Tests filter hooks and functions.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/form_test.module',
  'name' => 'form_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:12:"FormAPI Test";s:11:"description";s:34:"Support module for Form API tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/image_test.module',
  'name' => 'image_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Image test";s:11:"description";s:39:"Support module for image toolkit tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/menu_test.module',
  'name' => 'menu_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:15:"Hook menu tests";s:11:"description";s:37:"Support module for menu hook testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/module_test.module',
  'name' => 'module_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:11:"Module test";s:11:"description";s:41:"Support module for module system testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/path_test.module',
  'name' => 'path_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:15:"Hook path tests";s:11:"description";s:37:"Support module for path hook testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/psr_0_test/psr_0_test.module',
  'name' => 'psr_0_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:16:"PSR-0 Test cases";s:11:"description";s:44:"Test classes to be discovered by simpletest.";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/psr_4_test/psr_4_test.module',
  'name' => 'psr_4_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:16:"PSR-4 Test cases";s:11:"description";s:44:"Test classes to be discovered by simpletest.";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/requirements1_test.module',
  'name' => 'requirements1_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:13:{s:4:\"name\";s:19:\"Requirements 1 Test\";s:11:\"description\";s:80:\"Tests that a module is not installed when it fails hook_requirements('install').\";s:7:\"package\";s:7:\"Testing\";s:7:\"version\";s:4:\"7.72\";s:4:\"core\";s:3:\"7.x\";s:6:\"hidden\";b:1;s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1592419104\";s:5:\"mtime\";i:1592419104;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}",
))
->values(array(
  'filename' => 'modules/simpletest/tests/requirements2_test.module',
  'name' => 'requirements2_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:13:{s:4:\"name\";s:19:\"Requirements 2 Test\";s:11:\"description\";s:98:\"Tests that a module is not installed when the one it depends on fails hook_requirements('install).\";s:12:\"dependencies\";a:2:{i:0;s:18:\"requirements1_test\";i:1;s:7:\"comment\";}s:7:\"package\";s:7:\"Testing\";s:7:\"version\";s:4:\"7.72\";s:4:\"core\";s:3:\"7.x\";s:6:\"hidden\";b:1;s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1592419104\";s:5:\"mtime\";i:1592419104;s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}",
))
->values(array(
  'filename' => 'modules/simpletest/tests/session_test.module',
  'name' => 'session_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:12:"Session test";s:11:"description";s:40:"Support module for session data testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_dependencies_test.module',
  'name' => 'system_dependencies_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:22:"System dependency test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:19:"_missing_dependency";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_incompatible_core_version_dependencies_test.module',
  'name' => 'system_incompatible_core_version_dependencies_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:50:"System incompatible core version dependencies test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:37:"system_incompatible_core_version_test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_incompatible_core_version_test.module',
  'name' => 'system_incompatible_core_version_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:37:"System incompatible core version test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"5.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_incompatible_module_version_dependencies_test.module',
  'name' => 'system_incompatible_module_version_dependencies_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:52:"System incompatible module version dependencies test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:46:"system_incompatible_module_version_test (>2.0)";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_incompatible_module_version_test.module',
  'name' => 'system_incompatible_module_version_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:39:"System incompatible module version test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_project_namespace_test.module',
  'name' => 'system_project_namespace_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:29:"System project namespace test";s:11:"description";s:58:"Support module for testing project namespace dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:13:"drupal:filter";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_test.module',
  'name' => 'system_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:11:"System test";s:11:"description";s:34:"Support module for system testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:18:"system_test.module";}s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/taxonomy_test.module',
  'name' => 'taxonomy_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:20:"Taxonomy test module";s:11:"description";s:45:""Tests functions and hooks not used in core".";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:8:"taxonomy";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/theme_test.module',
  'name' => 'theme_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Theme test";s:11:"description";s:40:"Support module for theme system testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/update_script_test.module',
  'name' => 'update_script_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:18:"Update script test";s:11:"description";s:41:"Support module for update script testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/update_test_1.module',
  'name' => 'update_test_1',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:11:"Update test";s:11:"description";s:34:"Support module for update testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/update_test_2.module',
  'name' => 'update_test_2',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:11:"Update test";s:11:"description";s:34:"Support module for update testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/update_test_3.module',
  'name' => 'update_test_3',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:11:"Update test";s:11:"description";s:34:"Support module for update testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/url_alter_test.module',
  'name' => 'url_alter_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:15:"Url_alter tests";s:11:"description";s:45:"A support modules for url_alter hook testing.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/xmlrpc_test.module',
  'name' => 'xmlrpc_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:12:"XML-RPC Test";s:11:"description";s:75:"Support module for XML-RPC tests according to the validator1 specification.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/statistics/statistics.module',
  'name' => 'statistics',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Statistics";s:11:"description";s:37:"Logs access statistics for your site.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:15:"statistics.test";}s:9:"configure";s:30:"admin/config/system/statistics";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/syslog/syslog.module',
  'name' => 'syslog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:6:"Syslog";s:11:"description";s:41:"Logs and records system events to syslog.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"syslog.test";}s:9:"configure";s:32:"admin/config/development/logging";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/system/system.module',
  'name' => 'system',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7084',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:6:"System";s:11:"description";s:54:"Handles general site configuration for administrators.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:6:{i:0;s:19:"system.archiver.inc";i:1;s:15:"system.mail.inc";i:2;s:16:"system.queue.inc";i:3;s:14:"system.tar.inc";i:4;s:18:"system.updater.inc";i:5;s:11:"system.test";}s:8:"required";b:1;s:9:"configure";s:19:"admin/config/system";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/system/tests/cron_queue_test.module',
  'name' => 'cron_queue_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:15:"Cron Queue test";s:11:"description";s:41:"Support module for the cron queue runner.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/system/tests/system_cron_test.module',
  'name' => 'system_cron_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:16:"System Cron Test";s:11:"description";s:45:"Support module for testing the system_cron().";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/taxonomy/taxonomy.module',
  'name' => 'taxonomy',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:8:"Taxonomy";s:11:"description";s:38:"Enables the categorization of content.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:7:"options";}s:5:"files";a:2:{i:0;s:15:"taxonomy.module";i:1;s:13:"taxonomy.test";}s:9:"configure";s:24:"admin/structure/taxonomy";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/toolbar/toolbar.module',
  'name' => 'toolbar',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:7:"Toolbar";s:11:"description";s:99:"Provides a toolbar that shows the top-level administration menu items and links from other modules.";s:4:"core";s:3:"7.x";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/tracker/tracker.module',
  'name' => 'tracker',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:7:"Tracker";s:11:"description";s:45:"Enables tracking of recent content for users.";s:12:"dependencies";a:1:{i:0;s:7:"comment";}s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"tracker.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/translation/tests/translation_test.module',
  'name' => 'translation_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:24:"Content Translation Test";s:11:"description";s:49:"Support module for the content translation tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/translation/translation.module',
  'name' => 'translation',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:19:"Content translation";s:11:"description";s:57:"Allows content to be translated into different languages.";s:12:"dependencies";a:1:{i:0;s:6:"locale";}s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:16:"translation.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/trigger/tests/trigger_test.module',
  'name' => 'trigger_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:12:"Trigger Test";s:11:"description";s:33:"Support module for Trigger tests.";s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"version";s:4:"7.72";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/trigger/trigger.module',
  'name' => 'trigger',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:7:"Trigger";s:11:"description";s:90:"Enables actions to be fired on certain system events, such as when new content is created.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"trigger.test";}s:9:"configure";s:23:"admin/structure/trigger";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/tests/aaa_update_test.module',
  'name' => 'aaa_update_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:15:"AAA Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"version";s:4:"7.72";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/tests/bbb_update_test.module',
  'name' => 'bbb_update_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:15:"BBB Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"version";s:4:"7.72";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/tests/ccc_update_test.module',
  'name' => 'ccc_update_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:15:"CCC Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"version";s:4:"7.72";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/tests/update_test.module',
  'name' => 'update_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:11:"Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/update.module',
  'name' => 'update',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:14:"Update manager";s:11:"description";s:104:"Checks for available updates, and can securely install or update modules and themes via a web interface.";s:7:"version";s:4:"7.72";s:7:"package";s:4:"Core";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"update.test";}s:9:"configure";s:30:"admin/reports/updates/settings";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/user/tests/user_form_test.module',
  'name' => 'user_form_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:22:"User module form tests";s:11:"description";s:37:"Support module for user form testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/user/tests/user_session_test.module',
  'name' => 'user_session_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:25:"User module session tests";s:11:"description";s:40:"Support module for user session testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/user/user.module',
  'name' => 'user',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7019',
  'weight' => '0',
  'info' => 'a:15:{s:4:"name";s:4:"User";s:11:"description";s:47:"Manages the user registration and login system.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:11:"user.module";i:1;s:9:"user.test";}s:8:"required";b:1;s:9:"configure";s:19:"admin/config/people";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"user.css";s:21:"modules/user/user.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'profiles/minimal/minimal.profile',
  'name' => 'minimal',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '1000',
  'info' => 'a:15:{s:4:"name";s:7:"Minimal";s:11:"description";s:38:"Start with only a few modules enabled.";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:12:"dependencies";a:2:{i:0;s:5:"block";i:1;s:5:"dblog";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:5:"mtime";i:1592419104;s:7:"package";s:5:"Other";s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;s:6:"hidden";b:1;s:8:"required";b:1;s:17:"distribution_name";s:6:"Drupal";}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/bulk_export/bulk_export.module',
  'name' => 'bulk_export',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:11:"Bulk Export";s:11:"description";s:67:"Performs bulk exporting of data objects known about by Chaos tools.";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:7:"package";s:16:"Chaos tool suite";s:7:"version";s:8:"7.x-1.15";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1549603691";s:5:"mtime";i:1549603691;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/ctools.module',
  'name' => 'ctools',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7003',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:11:"Chaos tools";s:11:"description";s:46:"A library of helpful tools by Merlin of Chaos.";s:4:"core";s:3:"7.x";s:7:"package";s:16:"Chaos tool suite";s:5:"files";a:14:{i:0;s:20:"includes/context.inc";i:1;s:22:"includes/css-cache.inc";i:2;s:22:"includes/math-expr.inc";i:3;s:21:"includes/stylizer.inc";i:4;s:18:"tests/context.test";i:5;s:14:"tests/css.test";i:6;s:20:"tests/css_cache.test";i:7;s:25:"tests/ctools.plugins.test";i:8;s:17:"tests/ctools.test";i:9;s:26:"tests/math_expression.test";i:10;s:32:"tests/math_expression_stack.test";i:11;s:23:"tests/object_cache.test";i:12;s:28:"tests/object_cache_unit.test";i:13;s:22:"tests/page_tokens.test";}s:7:"version";s:8:"7.x-1.15";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1549603691";s:5:"mtime";i:1549603691;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/ctools_access_ruleset/ctools_access_ruleset.module',
  'name' => 'ctools_access_ruleset',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:15:"Custom rulesets";s:11:"description";s:81:"Create custom, exportable, reusable access rulesets for applications like Panels.";s:4:"core";s:3:"7.x";s:7:"package";s:16:"Chaos tool suite";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:7:"version";s:8:"7.x-1.15";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1549603691";s:5:"mtime";i:1549603691;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/ctools_ajax_sample/ctools_ajax_sample.module',
  'name' => 'ctools_ajax_sample',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:33:"Chaos Tools (CTools) AJAX Example";s:11:"description";s:41:"Shows how to use the power of Chaos AJAX.";s:7:"package";s:16:"Chaos tool suite";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:4:"core";s:3:"7.x";s:7:"version";s:8:"7.x-1.15";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1549603691";s:5:"mtime";i:1549603691;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/ctools_custom_content/ctools_custom_content.module',
  'name' => 'ctools_custom_content',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:20:"Custom content panes";s:11:"description";s:79:"Create custom, exportable, reusable content panes for applications like Panels.";s:4:"core";s:3:"7.x";s:7:"package";s:16:"Chaos tool suite";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:7:"version";s:8:"7.x-1.15";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1549603691";s:5:"mtime";i:1549603691;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/ctools_plugin_example/ctools_plugin_example.module',
  'name' => 'ctools_plugin_example',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:35:"Chaos Tools (CTools) Plugin Example";s:11:"description";s:75:"Shows how an external module can provide ctools plugins (for Panels, etc.).";s:7:"package";s:16:"Chaos tool suite";s:12:"dependencies";a:4:{i:0;s:6:"ctools";i:1;s:6:"panels";i:2;s:12:"page_manager";i:3;s:13:"advanced_help";}s:4:"core";s:3:"7.x";s:7:"version";s:8:"7.x-1.15";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1549603691";s:5:"mtime";i:1549603691;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/page_manager/page_manager.module',
  'name' => 'page_manager',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:12:"Page manager";s:11:"description";s:54:"Provides a UI and API to manage pages within the site.";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:7:"package";s:16:"Chaos tool suite";s:5:"files";a:1:{i:0;s:21:"tests/head_links.test";}s:7:"version";s:8:"7.x-1.15";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1549603691";s:5:"mtime";i:1549603691;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/stylizer/stylizer.module',
  'name' => 'stylizer',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:8:"Stylizer";s:11:"description";s:53:"Create custom styles for applications such as Panels.";s:4:"core";s:3:"7.x";s:7:"package";s:16:"Chaos tool suite";s:12:"dependencies";a:2:{i:0;s:6:"ctools";i:1;s:5:"color";}s:7:"version";s:8:"7.x-1.15";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1549603691";s:5:"mtime";i:1549603691;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/term_depth/term_depth.module',
  'name' => 'term_depth',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:17:"Term Depth access";s:11:"description";s:48:"Controls access to context based upon term depth";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:7:"package";s:16:"Chaos tool suite";s:7:"version";s:8:"7.x-1.15";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1549603691";s:5:"mtime";i:1549603691;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/ctools_export_test/ctools_export_test.module',
  'name' => 'ctools_export_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:18:"CTools export test";s:11:"description";s:25:"CTools export test module";s:4:"core";s:3:"7.x";s:7:"package";s:16:"Chaos tool suite";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:6:"hidden";b:1;s:5:"files";a:1:{i:0;s:18:"ctools_export.test";}s:7:"version";s:8:"7.x-1.15";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1549603691";s:5:"mtime";i:1549603691;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/tests/ctools_plugin_test.module',
  'name' => 'ctools_plugin_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:24:"Chaos tools plugins test";s:11:"description";s:42:"Provides hooks for testing ctools plugins.";s:7:"package";s:16:"Chaos tool suite";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:6:"hidden";b:1;s:7:"version";s:8:"7.x-1.15";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1549603691";s:5:"mtime";i:1549603691;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/ctools/views_content/views_content.module',
  'name' => 'views_content',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:19:"Views content panes";s:11:"description";s:104:"Allows Views content to be used in Panels, Dashboard and other modules which use the CTools Content API.";s:7:"package";s:16:"Chaos tool suite";s:12:"dependencies";a:2:{i:0;s:6:"ctools";i:1;s:5:"views";}s:4:"core";s:3:"7.x";s:5:"files";a:3:{i:0;s:61:"plugins/views/views_content_plugin_display_ctools_context.inc";i:1;s:57:"plugins/views/views_content_plugin_display_panel_pane.inc";i:2;s:59:"plugins/views/views_content_plugin_style_ctools_context.inc";}s:7:"version";s:8:"7.x-1.15";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1549603691";s:5:"mtime";i:1549603691;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/views/tests/views_test.module',
  'name' => 'views_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Views Test";s:11:"description";s:22:"Test module for Views.";s:7:"package";s:5:"Views";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"views";}s:6:"hidden";b:1;s:7:"version";s:8:"7.x-3.24";s:7:"project";s:5:"views";s:9:"datestamp";s:10:"1583615732";s:5:"mtime";i:1583615732;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/views/views.module',
  'name' => 'views',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7302',
  'weight' => '10',
  'info' => 'a:13:{s:4:"name";s:5:"Views";s:11:"description";s:55:"Create customized lists and queries from your database.";s:7:"package";s:5:"Views";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:13:"css/views.css";s:37:"sites/all/modules/views/css/views.css";}}s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:5:"files";a:316:{i:0;s:31:"handlers/views_handler_area.inc";i:1;s:40:"handlers/views_handler_area_messages.inc";i:2;s:38:"handlers/views_handler_area_result.inc";i:3;s:36:"handlers/views_handler_area_text.inc";i:4;s:43:"handlers/views_handler_area_text_custom.inc";i:5;s:36:"handlers/views_handler_area_view.inc";i:6;s:35:"handlers/views_handler_argument.inc";i:7;s:40:"handlers/views_handler_argument_date.inc";i:8;s:43:"handlers/views_handler_argument_formula.inc";i:9;s:47:"handlers/views_handler_argument_many_to_one.inc";i:10;s:40:"handlers/views_handler_argument_null.inc";i:11;s:43:"handlers/views_handler_argument_numeric.inc";i:12;s:42:"handlers/views_handler_argument_string.inc";i:13;s:52:"handlers/views_handler_argument_group_by_numeric.inc";i:14;s:32:"handlers/views_handler_field.inc";i:15;s:40:"handlers/views_handler_field_counter.inc";i:16;s:40:"handlers/views_handler_field_boolean.inc";i:17;s:49:"handlers/views_handler_field_contextual_links.inc";i:18;s:48:"handlers/views_handler_field_ctools_dropdown.inc";i:19;s:39:"handlers/views_handler_field_custom.inc";i:20;s:37:"handlers/views_handler_field_date.inc";i:21;s:39:"handlers/views_handler_field_entity.inc";i:22;s:38:"handlers/views_handler_field_links.inc";i:23;s:39:"handlers/views_handler_field_markup.inc";i:24;s:37:"handlers/views_handler_field_math.inc";i:25;s:40:"handlers/views_handler_field_numeric.inc";i:26;s:47:"handlers/views_handler_field_prerender_list.inc";i:27;s:46:"handlers/views_handler_field_time_interval.inc";i:28;s:43:"handlers/views_handler_field_serialized.inc";i:29;s:45:"handlers/views_handler_field_machine_name.inc";i:30;s:36:"handlers/views_handler_field_url.inc";i:31;s:33:"handlers/views_handler_filter.inc";i:32;s:50:"handlers/views_handler_filter_boolean_operator.inc";i:33;s:57:"handlers/views_handler_filter_boolean_operator_string.inc";i:34;s:41:"handlers/views_handler_filter_combine.inc";i:35;s:38:"handlers/views_handler_filter_date.inc";i:36;s:42:"handlers/views_handler_filter_equality.inc";i:37;s:47:"handlers/views_handler_filter_entity_bundle.inc";i:38;s:50:"handlers/views_handler_filter_group_by_numeric.inc";i:39;s:45:"handlers/views_handler_filter_in_operator.inc";i:40;s:45:"handlers/views_handler_filter_many_to_one.inc";i:41;s:41:"handlers/views_handler_filter_numeric.inc";i:42;s:40:"handlers/views_handler_filter_string.inc";i:43;s:48:"handlers/views_handler_filter_fields_compare.inc";i:44;s:39:"handlers/views_handler_relationship.inc";i:45;s:53:"handlers/views_handler_relationship_groupwise_max.inc";i:46;s:31:"handlers/views_handler_sort.inc";i:47;s:36:"handlers/views_handler_sort_date.inc";i:48;s:39:"handlers/views_handler_sort_formula.inc";i:49;s:48:"handlers/views_handler_sort_group_by_numeric.inc";i:50;s:46:"handlers/views_handler_sort_menu_hierarchy.inc";i:51;s:38:"handlers/views_handler_sort_random.inc";i:52;s:17:"includes/base.inc";i:53;s:21:"includes/handlers.inc";i:54;s:20:"includes/plugins.inc";i:55;s:17:"includes/view.inc";i:56;s:60:"modules/aggregator/views_handler_argument_aggregator_fid.inc";i:57;s:60:"modules/aggregator/views_handler_argument_aggregator_iid.inc";i:58;s:69:"modules/aggregator/views_handler_argument_aggregator_category_cid.inc";i:59;s:64:"modules/aggregator/views_handler_field_aggregator_title_link.inc";i:60;s:62:"modules/aggregator/views_handler_field_aggregator_category.inc";i:61;s:70:"modules/aggregator/views_handler_field_aggregator_item_description.inc";i:62;s:57:"modules/aggregator/views_handler_field_aggregator_xss.inc";i:63;s:67:"modules/aggregator/views_handler_filter_aggregator_category_cid.inc";i:64;s:54:"modules/aggregator/views_plugin_row_aggregator_rss.inc";i:65;s:56:"modules/book/views_plugin_argument_default_book_root.inc";i:66;s:59:"modules/comment/views_handler_argument_comment_user_uid.inc";i:67;s:47:"modules/comment/views_handler_field_comment.inc";i:68;s:53:"modules/comment/views_handler_field_comment_depth.inc";i:69;s:52:"modules/comment/views_handler_field_comment_link.inc";i:70;s:60:"modules/comment/views_handler_field_comment_link_approve.inc";i:71;s:59:"modules/comment/views_handler_field_comment_link_delete.inc";i:72;s:57:"modules/comment/views_handler_field_comment_link_edit.inc";i:73;s:58:"modules/comment/views_handler_field_comment_link_reply.inc";i:74;s:57:"modules/comment/views_handler_field_comment_node_link.inc";i:75;s:56:"modules/comment/views_handler_field_comment_username.inc";i:76;s:61:"modules/comment/views_handler_field_ncs_last_comment_name.inc";i:77;s:56:"modules/comment/views_handler_field_ncs_last_updated.inc";i:78;s:52:"modules/comment/views_handler_field_node_comment.inc";i:79;s:57:"modules/comment/views_handler_field_node_new_comments.inc";i:80;s:62:"modules/comment/views_handler_field_last_comment_timestamp.inc";i:81;s:57:"modules/comment/views_handler_filter_comment_user_uid.inc";i:82;s:57:"modules/comment/views_handler_filter_ncs_last_updated.inc";i:83;s:53:"modules/comment/views_handler_filter_node_comment.inc";i:84;s:53:"modules/comment/views_handler_sort_comment_thread.inc";i:85;s:60:"modules/comment/views_handler_sort_ncs_last_comment_name.inc";i:86;s:55:"modules/comment/views_handler_sort_ncs_last_updated.inc";i:87;s:48:"modules/comment/views_plugin_row_comment_rss.inc";i:88;s:49:"modules/comment/views_plugin_row_comment_view.inc";i:89;s:52:"modules/contact/views_handler_field_contact_link.inc";i:90;s:43:"modules/field/views_handler_field_field.inc";i:91;s:59:"modules/field/views_handler_relationship_entity_reverse.inc";i:92;s:51:"modules/field/views_handler_argument_field_list.inc";i:93;s:57:"modules/field/views_handler_filter_field_list_boolean.inc";i:94;s:58:"modules/field/views_handler_argument_field_list_string.inc";i:95;s:49:"modules/field/views_handler_filter_field_list.inc";i:96;s:57:"modules/filter/views_handler_field_filter_format_name.inc";i:97;s:52:"modules/locale/views_handler_field_node_language.inc";i:98;s:53:"modules/locale/views_handler_filter_node_language.inc";i:99;s:54:"modules/locale/views_handler_argument_locale_group.inc";i:100;s:57:"modules/locale/views_handler_argument_locale_language.inc";i:101;s:51:"modules/locale/views_handler_field_locale_group.inc";i:102;s:54:"modules/locale/views_handler_field_locale_language.inc";i:103;s:55:"modules/locale/views_handler_field_locale_link_edit.inc";i:104;s:52:"modules/locale/views_handler_filter_locale_group.inc";i:105;s:55:"modules/locale/views_handler_filter_locale_language.inc";i:106;s:54:"modules/locale/views_handler_filter_locale_version.inc";i:107;s:51:"modules/locale/views_handler_sort_node_language.inc";i:108;s:53:"modules/node/views_handler_argument_dates_various.inc";i:109;s:53:"modules/node/views_handler_argument_node_language.inc";i:110;s:48:"modules/node/views_handler_argument_node_nid.inc";i:111;s:49:"modules/node/views_handler_argument_node_type.inc";i:112;s:48:"modules/node/views_handler_argument_node_vid.inc";i:113;s:57:"modules/node/views_handler_argument_node_uid_revision.inc";i:114;s:59:"modules/node/views_handler_field_history_user_timestamp.inc";i:115;s:41:"modules/node/views_handler_field_node.inc";i:116;s:46:"modules/node/views_handler_field_node_link.inc";i:117;s:53:"modules/node/views_handler_field_node_link_delete.inc";i:118;s:51:"modules/node/views_handler_field_node_link_edit.inc";i:119;s:50:"modules/node/views_handler_field_node_revision.inc";i:120;s:55:"modules/node/views_handler_field_node_revision_link.inc";i:121;s:62:"modules/node/views_handler_field_node_revision_link_delete.inc";i:122;s:62:"modules/node/views_handler_field_node_revision_link_revert.inc";i:123;s:46:"modules/node/views_handler_field_node_path.inc";i:124;s:46:"modules/node/views_handler_field_node_type.inc";i:125;s:55:"modules/node/views_handler_field_node_version_count.inc";i:126;s:60:"modules/node/views_handler_filter_history_user_timestamp.inc";i:127;s:49:"modules/node/views_handler_filter_node_access.inc";i:128;s:49:"modules/node/views_handler_filter_node_status.inc";i:129;s:47:"modules/node/views_handler_filter_node_type.inc";i:130;s:55:"modules/node/views_handler_filter_node_uid_revision.inc";i:131;s:56:"modules/node/views_handler_filter_node_version_count.inc";i:132;s:54:"modules/node/views_handler_sort_node_version_count.inc";i:133;s:51:"modules/node/views_plugin_argument_default_node.inc";i:134;s:52:"modules/node/views_plugin_argument_validate_node.inc";i:135;s:42:"modules/node/views_plugin_row_node_rss.inc";i:136;s:43:"modules/node/views_plugin_row_node_view.inc";i:137;s:52:"modules/profile/views_handler_field_profile_date.inc";i:138;s:52:"modules/profile/views_handler_field_profile_list.inc";i:139;s:58:"modules/profile/views_handler_filter_profile_selection.inc";i:140;s:48:"modules/search/views_handler_argument_search.inc";i:141;s:51:"modules/search/views_handler_field_search_score.inc";i:142;s:46:"modules/search/views_handler_filter_search.inc";i:143;s:50:"modules/search/views_handler_sort_search_score.inc";i:144;s:47:"modules/search/views_plugin_row_search_view.inc";i:145;s:57:"modules/statistics/views_handler_field_accesslog_path.inc";i:146;s:65:"modules/statistics/views_handler_field_node_counter_timestamp.inc";i:147;s:61:"modules/statistics/views_handler_field_statistics_numeric.inc";i:148;s:50:"modules/system/views_handler_argument_file_fid.inc";i:149;s:43:"modules/system/views_handler_field_file.inc";i:150;s:53:"modules/system/views_handler_field_file_extension.inc";i:151;s:52:"modules/system/views_handler_field_file_filemime.inc";i:152;s:47:"modules/system/views_handler_field_file_uri.inc";i:153;s:50:"modules/system/views_handler_field_file_status.inc";i:154;s:51:"modules/system/views_handler_filter_file_status.inc";i:155;s:52:"modules/taxonomy/views_handler_argument_taxonomy.inc";i:156;s:57:"modules/taxonomy/views_handler_argument_term_node_tid.inc";i:157;s:63:"modules/taxonomy/views_handler_argument_term_node_tid_depth.inc";i:158;s:68:"modules/taxonomy/views_handler_argument_term_node_tid_depth_join.inc";i:159;s:72:"modules/taxonomy/views_handler_argument_term_node_tid_depth_modifier.inc";i:160;s:58:"modules/taxonomy/views_handler_argument_vocabulary_vid.inc";i:161;s:67:"modules/taxonomy/views_handler_argument_vocabulary_machine_name.inc";i:162;s:49:"modules/taxonomy/views_handler_field_taxonomy.inc";i:163;s:54:"modules/taxonomy/views_handler_field_term_node_tid.inc";i:164;s:55:"modules/taxonomy/views_handler_field_term_link_edit.inc";i:165;s:55:"modules/taxonomy/views_handler_filter_term_node_tid.inc";i:166;s:61:"modules/taxonomy/views_handler_filter_term_node_tid_depth.inc";i:167;s:66:"modules/taxonomy/views_handler_filter_term_node_tid_depth_join.inc";i:168;s:56:"modules/taxonomy/views_handler_filter_vocabulary_vid.inc";i:169;s:65:"modules/taxonomy/views_handler_filter_vocabulary_machine_name.inc";i:170;s:62:"modules/taxonomy/views_handler_relationship_node_term_data.inc";i:171;s:65:"modules/taxonomy/views_plugin_argument_validate_taxonomy_term.inc";i:172;s:63:"modules/taxonomy/views_plugin_argument_default_taxonomy_tid.inc";i:173;s:67:"modules/tracker/views_handler_argument_tracker_comment_user_uid.inc";i:174;s:65:"modules/tracker/views_handler_filter_tracker_comment_user_uid.inc";i:175;s:65:"modules/tracker/views_handler_filter_tracker_boolean_operator.inc";i:176;s:51:"modules/system/views_handler_filter_system_type.inc";i:177;s:56:"modules/translation/views_handler_argument_node_tnid.inc";i:178;s:63:"modules/translation/views_handler_field_node_link_translate.inc";i:179;s:65:"modules/translation/views_handler_field_node_translation_link.inc";i:180;s:54:"modules/translation/views_handler_filter_node_tnid.inc";i:181;s:60:"modules/translation/views_handler_filter_node_tnid_child.inc";i:182;s:62:"modules/translation/views_handler_relationship_translation.inc";i:183;s:48:"modules/user/views_handler_argument_user_uid.inc";i:184;s:55:"modules/user/views_handler_argument_users_roles_rid.inc";i:185;s:41:"modules/user/views_handler_field_user.inc";i:186;s:50:"modules/user/views_handler_field_user_language.inc";i:187;s:46:"modules/user/views_handler_field_user_link.inc";i:188;s:53:"modules/user/views_handler_field_user_link_cancel.inc";i:189;s:51:"modules/user/views_handler_field_user_link_edit.inc";i:190;s:46:"modules/user/views_handler_field_user_mail.inc";i:191;s:46:"modules/user/views_handler_field_user_name.inc";i:192;s:53:"modules/user/views_handler_field_user_permissions.inc";i:193;s:49:"modules/user/views_handler_field_user_picture.inc";i:194;s:47:"modules/user/views_handler_field_user_roles.inc";i:195;s:50:"modules/user/views_handler_filter_user_current.inc";i:196;s:47:"modules/user/views_handler_filter_user_name.inc";i:197;s:54:"modules/user/views_handler_filter_user_permissions.inc";i:198;s:48:"modules/user/views_handler_filter_user_roles.inc";i:199;s:59:"modules/user/views_plugin_argument_default_current_user.inc";i:200;s:51:"modules/user/views_plugin_argument_default_user.inc";i:201;s:52:"modules/user/views_plugin_argument_validate_user.inc";i:202;s:43:"modules/user/views_plugin_row_user_view.inc";i:203;s:31:"plugins/views_plugin_access.inc";i:204;s:36:"plugins/views_plugin_access_none.inc";i:205;s:36:"plugins/views_plugin_access_perm.inc";i:206;s:36:"plugins/views_plugin_access_role.inc";i:207;s:41:"plugins/views_plugin_argument_default.inc";i:208;s:45:"plugins/views_plugin_argument_default_php.inc";i:209;s:47:"plugins/views_plugin_argument_default_fixed.inc";i:210;s:45:"plugins/views_plugin_argument_default_raw.inc";i:211;s:42:"plugins/views_plugin_argument_validate.inc";i:212;s:50:"plugins/views_plugin_argument_validate_numeric.inc";i:213;s:46:"plugins/views_plugin_argument_validate_php.inc";i:214;s:30:"plugins/views_plugin_cache.inc";i:215;s:35:"plugins/views_plugin_cache_none.inc";i:216;s:35:"plugins/views_plugin_cache_time.inc";i:217;s:32:"plugins/views_plugin_display.inc";i:218;s:43:"plugins/views_plugin_display_attachment.inc";i:219;s:38:"plugins/views_plugin_display_block.inc";i:220;s:40:"plugins/views_plugin_display_default.inc";i:221;s:38:"plugins/views_plugin_display_embed.inc";i:222;s:41:"plugins/views_plugin_display_extender.inc";i:223;s:37:"plugins/views_plugin_display_feed.inc";i:224;s:37:"plugins/views_plugin_display_page.inc";i:225;s:43:"plugins/views_plugin_exposed_form_basic.inc";i:226;s:37:"plugins/views_plugin_exposed_form.inc";i:227;s:52:"plugins/views_plugin_exposed_form_input_required.inc";i:228;s:42:"plugins/views_plugin_localization_core.inc";i:229;s:37:"plugins/views_plugin_localization.inc";i:230;s:42:"plugins/views_plugin_localization_none.inc";i:231;s:30:"plugins/views_plugin_pager.inc";i:232;s:35:"plugins/views_plugin_pager_full.inc";i:233;s:35:"plugins/views_plugin_pager_mini.inc";i:234;s:35:"plugins/views_plugin_pager_none.inc";i:235;s:35:"plugins/views_plugin_pager_some.inc";i:236;s:30:"plugins/views_plugin_query.inc";i:237;s:38:"plugins/views_plugin_query_default.inc";i:238;s:28:"plugins/views_plugin_row.inc";i:239;s:35:"plugins/views_plugin_row_fields.inc";i:240;s:39:"plugins/views_plugin_row_rss_fields.inc";i:241;s:30:"plugins/views_plugin_style.inc";i:242;s:38:"plugins/views_plugin_style_default.inc";i:243;s:35:"plugins/views_plugin_style_grid.inc";i:244;s:35:"plugins/views_plugin_style_list.inc";i:245;s:40:"plugins/views_plugin_style_jump_menu.inc";i:246;s:38:"plugins/views_plugin_style_mapping.inc";i:247;s:34:"plugins/views_plugin_style_rss.inc";i:248;s:38:"plugins/views_plugin_style_summary.inc";i:249;s:48:"plugins/views_plugin_style_summary_jump_menu.inc";i:250;s:50:"plugins/views_plugin_style_summary_unformatted.inc";i:251;s:36:"plugins/views_plugin_style_table.inc";i:252;s:34:"tests/handlers/views_handlers.test";i:253;s:43:"tests/handlers/views_handler_area_text.test";i:254;s:47:"tests/handlers/views_handler_argument_null.test";i:255;s:39:"tests/handlers/views_handler_field.test";i:256;s:47:"tests/handlers/views_handler_field_boolean.test";i:257;s:46:"tests/handlers/views_handler_field_custom.test";i:258;s:47:"tests/handlers/views_handler_field_counter.test";i:259;s:44:"tests/handlers/views_handler_field_date.test";i:260;s:54:"tests/handlers/views_handler_field_file_extension.test";i:261;s:49:"tests/handlers/views_handler_field_file_size.test";i:262;s:44:"tests/handlers/views_handler_field_math.test";i:263;s:43:"tests/handlers/views_handler_field_url.test";i:264;s:43:"tests/handlers/views_handler_field_xss.test";i:265;s:48:"tests/handlers/views_handler_filter_combine.test";i:266;s:45:"tests/handlers/views_handler_filter_date.test";i:267;s:49:"tests/handlers/views_handler_filter_equality.test";i:268;s:52:"tests/handlers/views_handler_filter_in_operator.test";i:269;s:48:"tests/handlers/views_handler_filter_numeric.test";i:270;s:47:"tests/handlers/views_handler_filter_string.test";i:271;s:43:"tests/handlers/views_handler_manytoone.test";i:272;s:45:"tests/handlers/views_handler_sort_random.test";i:273;s:43:"tests/handlers/views_handler_sort_date.test";i:274;s:38:"tests/handlers/views_handler_sort.test";i:275;s:46:"tests/test_handlers/views_test_area_access.inc";i:276;s:60:"tests/test_plugins/views_test_plugin_access_test_dynamic.inc";i:277;s:59:"tests/test_plugins/views_test_plugin_access_test_static.inc";i:278;s:59:"tests/test_plugins/views_test_plugin_style_test_mapping.inc";i:279;s:39:"tests/plugins/views_plugin_display.test";i:280;s:46:"tests/styles/views_plugin_style_jump_menu.test";i:281;s:36:"tests/styles/views_plugin_style.test";i:282;s:41:"tests/styles/views_plugin_style_base.test";i:283;s:44:"tests/styles/views_plugin_style_mapping.test";i:284;s:48:"tests/styles/views_plugin_style_unformatted.test";i:285;s:23:"tests/views_access.test";i:286;s:24:"tests/views_analyze.test";i:287;s:22:"tests/views_basic.test";i:288;s:21:"tests/views_ajax.test";i:289;s:33:"tests/views_argument_default.test";i:290;s:35:"tests/views_argument_validator.test";i:291;s:29:"tests/views_exposed_form.test";i:292;s:31:"tests/field/views_fieldapi.test";i:293;s:25:"tests/views_glossary.test";i:294;s:24:"tests/views_groupby.test";i:295;s:31:"tests/views_handler_filter.test";i:296;s:25:"tests/views_handlers.test";i:297;s:23:"tests/views_module.test";i:298;s:22:"tests/views_pager.test";i:299;s:40:"tests/views_plugin_localization_test.inc";i:300;s:29:"tests/views_translatable.test";i:301;s:22:"tests/views_query.test";i:302;s:24:"tests/views_upgrade.test";i:303;s:34:"tests/views_test.views_default.inc";i:304;s:58:"tests/comment/views_handler_argument_comment_user_uid.test";i:305;s:56:"tests/comment/views_handler_filter_comment_user_uid.test";i:306;s:45:"tests/node/views_node_revision_relations.test";i:307;s:61:"tests/taxonomy/views_handler_relationship_node_term_data.test";i:308;s:45:"tests/user/views_handler_field_user_name.test";i:309;s:43:"tests/user/views_user_argument_default.test";i:310;s:44:"tests/user/views_user_argument_validate.test";i:311;s:26:"tests/user/views_user.test";i:312;s:22:"tests/views_cache.test";i:313;s:22:"tests/views_clone.test";i:314;s:21:"tests/views_view.test";i:315;s:19:"tests/views_ui.test";}s:7:"version";s:8:"7.x-3.24";s:7:"project";s:5:"views";s:9:"datestamp";s:10:"1583615732";s:5:"mtime";i:1583615732;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/views/views_ui.module',
  'name' => 'views_ui',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:14:{s:4:\"name\";s:8:\"Views UI\";s:11:\"description\";s:93:\"Administrative interface to views. Without this module, you cannot create or edit your views.\";s:7:\"package\";s:5:\"Views\";s:4:\"core\";s:3:\"7.x\";s:9:\"configure\";s:21:\"admin/structure/views\";s:12:\"dependencies\";a:1:{i:0;s:5:\"views\";}s:34:\"# @codingStandardsIgnoreLine\nfiles\";a:1:{i:0;s:15:\"views_ui.module\";}s:5:\"files\";a:1:{i:0;s:57:\"plugins/views_wizard/views_ui_base_views_wizard.class.php\";}s:7:\"version\";s:8:\"7.x-3.24\";s:7:\"project\";s:5:\"views\";s:9:\"datestamp\";s:10:\"1583615732\";s:5:\"mtime\";i:1583615732;s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}",
))
->values(array(
  'filename' => 'sites/all/modules/webform/webform.module',
  'name' => 'webform',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7431',
  'weight' => '-1',
  'info' => 'a:14:{s:4:"name";s:7:"Webform";s:11:"description";s:49:"Enables the creation of forms and questionnaires.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Webform";s:9:"configure";s:28:"admin/config/content/webform";s:3:"php";s:3:"5.3";s:12:"dependencies";a:2:{i:0;s:6:"ctools";i:1;s:5:"views";}s:17:"test_dependencies";a:1:{i:0;s:5:"token";}s:5:"files";a:27:{i:0;s:40:"includes/webform.webformconditionals.inc";i:1;s:49:"includes/exporters/webform_exporter_delimited.inc";i:2;s:55:"includes/exporters/webform_exporter_excel_delimited.inc";i:3;s:50:"includes/exporters/webform_exporter_excel_xlsx.inc";i:4;s:39:"includes/exporters/webform_exporter.inc";i:5;s:43:"views/webform_handler_area_result_pager.inc";i:6;s:41:"views/webform_handler_field_form_body.inc";i:7;s:40:"views/webform_handler_field_is_draft.inc";i:8;s:46:"views/webform_handler_field_node_link_edit.inc";i:9;s:49:"views/webform_handler_field_node_link_results.inc";i:10;s:48:"views/webform_handler_field_submission_count.inc";i:11;s:47:"views/webform_handler_field_submission_data.inc";i:12;s:47:"views/webform_handler_field_submission_link.inc";i:13;s:46:"views/webform_handler_field_webform_status.inc";i:14;s:41:"views/webform_handler_filter_is_draft.inc";i:15;s:48:"views/webform_handler_filter_submission_data.inc";i:16;s:47:"views/webform_handler_filter_webform_status.inc";i:17;s:38:"views/webform_handler_numeric_data.inc";i:18;s:54:"views/webform_handler_relationship_submission_data.inc";i:19;s:44:"views/webform_plugin_row_submission_view.inc";i:20;s:36:"tests/WebformComponentsTestCase.test";i:21;s:38:"tests/WebformConditionalsTestCase.test";i:22;s:33:"tests/WebformGeneralTestCase.test";i:23;s:37:"tests/WebformPermissionsTestCase.test";i:24;s:36:"tests/WebformSubmissionTestCase.test";i:25;s:26:"tests/WebformTestCase.test";i:26;s:30:"tests/WebformUnitTestCase.test";}s:7:"version";s:8:"7.x-4.23";s:7:"project";s:7:"webform";s:9:"datestamp";s:10:"1591623589";s:5:"mtime";i:1591623589;s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'themes/bartik/bartik.info',
  'name' => 'bartik',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:17:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:17:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1592419104;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}',
))
->values(array(
  'filename' => 'themes/garland/garland.info',
  'name' => 'garland',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:17:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:9:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1592419104;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}',
))
->values(array(
  'filename' => 'themes/seven/seven.info',
  'name' => 'seven',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:17:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.72";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:5:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1592419104";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1592419104;}',
))
->values(array(
  'filename' => 'themes/stark/stark.info',
  'name' => 'stark',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:16:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.72\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1592419104\";s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:9:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1592419104;s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}}",
))
->execute();
$connection->schema()->createTable('url_alias', array(
  'fields' => array(
    'pid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'source' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'alias' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'pid',
  ),
  'indexes' => array(
    'alias_language_pid' => array(
      'alias',
      'language',
      'pid',
    ),
    'source_language_pid' => array(
      'source',
      'language',
      'pid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('users', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '60',
      'default' => '',
    ),
    'pass' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'mail' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '254',
      'default' => '',
    ),
    'theme' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'signature' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'signature_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'access' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'login' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'timezone' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '32',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'picture' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'init' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '254',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'uid',
  ),
  'unique keys' => array(
    'name' => array(
      'name',
    ),
  ),
  'indexes' => array(
    'access' => array(
      'access',
    ),
    'created' => array(
      'created',
    ),
    'mail' => array(
      'mail',
    ),
    'picture' => array(
      'picture',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('users')
->fields(array(
  'uid',
  'name',
  'pass',
  'mail',
  'theme',
  'signature',
  'signature_format',
  'created',
  'access',
  'login',
  'status',
  'timezone',
  'language',
  'picture',
  'init',
  'data',
))
->values(array(
  'uid' => '0',
  'name' => '',
  'pass' => '',
  'mail' => '',
  'theme' => '',
  'signature' => '',
  'signature_format' => NULL,
  'created' => '0',
  'access' => '0',
  'login' => '0',
  'status' => '0',
  'timezone' => NULL,
  'language' => '',
  'picture' => '0',
  'init' => '',
  'data' => NULL,
))
->values(array(
  'uid' => '1',
  'name' => 'admin',
  'pass' => '$S$DGmCQm4nPBPE6.9UDfr1IXup1xd/wbPq.cffPOYy9/GA26M.x4b8',
  'mail' => 'info@drupal7-webform.localhost',
  'theme' => '',
  'signature' => '',
  'signature_format' => NULL,
  'created' => '1600259167',
  'access' => '1600335159',
  'login' => '1600259231',
  'status' => '1',
  'timezone' => 'Europe/Budapest',
  'language' => '',
  'picture' => '0',
  'init' => 'info@drupal7-webform.localhost',
  'data' => 'b:0;',
))
->values(array(
  'uid' => '2',
  'name' => 'editor',
  'pass' => '$S$DaGDIOSdc3Tvzuycb1gV.dOdRvH59QSz3VBw1tcn2p0rfy4yowjQ',
  'mail' => 'editor@drupal7-webform.localhost',
  'theme' => '',
  'signature' => '',
  'signature_format' => 'plain_text',
  'created' => '1600259848',
  'access' => '1600328910',
  'login' => '1600259900',
  'status' => '1',
  'timezone' => 'Europe/Budapest',
  'language' => '',
  'picture' => '0',
  'init' => 'editor@drupal7-webform.localhost',
  'data' => NULL,
))
->values(array(
  'uid' => '3',
  'name' => 'user',
  'pass' => '$S$DX9FizG8t6mDKAt8npzbuSRqexXDLlzFWfQ.N6rN6Z74zJljWViU',
  'mail' => 'user@drupal7-webform.localhost',
  'theme' => '',
  'signature' => '',
  'signature_format' => 'plain_text',
  'created' => '1600259865',
  'access' => '1600327500',
  'login' => '1600327280',
  'status' => '1',
  'timezone' => 'Europe/Budapest',
  'language' => '',
  'picture' => '0',
  'init' => 'user@drupal7-webform.localhost',
  'data' => NULL,
))
->execute();
$connection->schema()->createTable('users_roles', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'rid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'uid',
    'rid',
  ),
  'indexes' => array(
    'rid' => array(
      'rid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('users_roles')
->fields(array(
  'uid',
  'rid',
))
->values(array(
  'uid' => '2',
  'rid' => '3',
))
->execute();
$connection->schema()->createTable('variable', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'value' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('variable')
->fields(array(
  'name',
  'value',
))
->values(array(
  'name' => 'additional_settings__active_tab_page',
  'value' => 's:13:"edit-workflow";',
))
->values(array(
  'name' => 'additional_settings__active_tab_webform_custom',
  'value' => 's:12:"edit-webform";',
))
->values(array(
  'name' => 'cache_class_cache_ctools_css',
  'value' => 's:14:"CToolsCssCache";',
))
->values(array(
  'name' => 'clean_url',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_webform',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'cron_key',
  'value' => 's:43:"SeRaqwl_MxycnZm1TeoOfJE-3jbpvv8j7CWIzR14aBY";',
))
->values(array(
  'name' => 'cron_last',
  'value' => 'i:1600325002;',
))
->values(array(
  'name' => 'css_js_query_string',
  'value' => 's:6:"qgr47d";',
))
->values(array(
  'name' => 'ctools_last_cron',
  'value' => 'i:1600325004;',
))
->values(array(
  'name' => 'date_default_timezone',
  'value' => 's:15:"Europe/Budapest";',
))
->values(array(
  'name' => 'drupal_private_key',
  'value' => 's:43:"fdNhvzRP44KQegFA312hKlbl0NR4xr1NhRi7InIUzuQ";',
))
->values(array(
  'name' => 'field_bundle_settings_node__webform',
  'value' => 'a:2:{s:10:"view_modes";a:0:{}s:12:"extra_fields";a:2:{s:4:"form";a:0:{}s:7:"display";a:1:{s:7:"webform";a:1:{s:6:"teaser";a:2:{s:6:"weight";s:2:"10";s:7:"visible";b:0;}}}}}',
))
->values(array(
  'name' => 'field_bundle_settings_node__webform_custom',
  'value' => 'a:2:{s:10:"view_modes";a:0:{}s:12:"extra_fields";a:2:{s:4:"form";a:1:{s:5:"title";a:1:{s:6:"weight";s:2:"-5";}}s:7:"display";a:1:{s:7:"webform";a:1:{s:6:"teaser";a:2:{s:6:"weight";s:1:"1";s:7:"visible";b:0;}}}}}',
))
->values(array(
  'name' => 'file_temporary_path',
  'value' => 's:4:"/tmp";',
))
->values(array(
  'name' => 'filter_fallback_format',
  'value' => 's:10:"plain_text";',
))
->values(array(
  'name' => 'install_profile',
  'value' => 's:7:"minimal";',
))
->values(array(
  'name' => 'install_task',
  'value' => 's:4:"done";',
))
->values(array(
  'name' => 'install_time',
  'value' => 'i:1600259231;',
))
->values(array(
  'name' => 'menu_expanded',
  'value' => 'a:0:{}',
))
->values(array(
  'name' => 'menu_masks',
  'value' => 'a:28:{i:0;i:501;i:1;i:250;i:2;i:245;i:3;i:125;i:4;i:123;i:5;i:122;i:6;i:121;i:7;i:63;i:8;i:62;i:9;i:61;i:10;i:60;i:11;i:45;i:12;i:44;i:13;i:31;i:14;i:30;i:15;i:24;i:16;i:22;i:17;i:21;i:18;i:15;i:19;i:14;i:20;i:11;i:21;i:10;i:22;i:7;i:23;i:6;i:24;i:5;i:25;i:3;i:26;i:2;i:27;i:1;}',
))
->values(array(
  'name' => 'node_options_page',
  'value' => 'a:2:{i:0;s:6:"status";i:1;s:7:"promote";}',
))
->values(array(
  'name' => 'node_options_webform_custom',
  'value' => 'a:1:{i:0;s:6:"status";}',
))
->values(array(
  'name' => 'node_preview_page',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'node_preview_webform_custom',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'node_submitted_page',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'node_submitted_webform_custom',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'path_alias_whitelist',
  'value' => 'a:0:{}',
))
->values(array(
  'name' => 'site_default_country',
  'value' => 's:2:"HU";',
))
->values(array(
  'name' => 'site_mail',
  'value' => 's:30:"info@drupal7-webform.localhost";',
))
->values(array(
  'name' => 'site_name',
  'value' => 's:16:"Drupal 7 Webform";',
))
->values(array(
  'name' => 'theme_default',
  'value' => 's:7:"garland";',
))
->values(array(
  'name' => 'theme_garland_settings',
  'value' => 'a:16:{s:11:"toggle_logo";i:1;s:11:"toggle_name";i:1;s:13:"toggle_slogan";i:1;s:24:"toggle_node_user_picture";i:1;s:27:"toggle_comment_user_picture";i:1;s:32:"toggle_comment_user_verification";i:1;s:14:"toggle_favicon";i:1;s:16:"toggle_main_menu";i:1;s:21:"toggle_secondary_menu";i:1;s:12:"default_logo";i:1;s:9:"logo_path";s:0:"";s:11:"logo_upload";s:0:"";s:15:"default_favicon";i:1;s:12:"favicon_path";s:0:"";s:14:"favicon_upload";s:0:"";s:13:"garland_width";s:5:"fluid";}',
))
->values(array(
  'name' => 'user_register',
  'value' => 'i:2;',
))
->values(array(
  'name' => 'webform_blocks',
  'value' => 'a:1:{s:14:"client-block-4";a:3:{s:7:"display";s:4:"form";s:11:"pages_block";s:1:"1";s:18:"confirmation_block";s:1:"0";}}',
))
->values(array(
  'name' => 'webform_node_page',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'webform_node_webform',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'webform_node_webform_custom',
  'value' => 'i:1;',
))
->execute();
$connection->schema()->createTable('views_display', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'id' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'display_title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'display_plugin' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'position' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'default' => '0',
    ),
    'display_options' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'vid',
    'id',
  ),
  'indexes' => array(
    'vid' => array(
      'vid',
      'position',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('views_view', array(
  'fields' => array(
    'vid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'description' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
      'default' => '',
    ),
    'tag' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
      'default' => '',
    ),
    'base_table' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'human_name' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
      'default' => '',
    ),
    'core' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'unique keys' => array(
    'name' => array(
      'name',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('watchdog', array(
  'fields' => array(
    'wid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'message' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'variables' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'severity' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'link' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
      'default' => '',
    ),
    'location' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'referer' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'wid',
  ),
  'indexes' => array(
    'type' => array(
      'type',
    ),
    'uid' => array(
      'uid',
    ),
    'severity' => array(
      'severity',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('webform', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'next_serial' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
      'unsigned' => TRUE,
    ),
    'confirmation' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'confirmation_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'redirect_url' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '2048',
      'default' => '<confirmation>',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '1',
    ),
    'block' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'allow_draft' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'auto_save' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'submit_notice' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '1',
    ),
    'confidential' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'submit_text' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'submit_limit' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '-1',
    ),
    'submit_interval' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '-1',
    ),
    'total_submit_limit' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '-1',
    ),
    'total_submit_interval' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '-1',
    ),
    'progressbar_bar' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'progressbar_page_number' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'progressbar_percent' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'progressbar_pagebreak_labels' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'progressbar_include_confirmation' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'progressbar_label_first' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'progressbar_label_confirmation' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'preview' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'preview_next_button_label' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'preview_prev_button_label' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'preview_title' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'preview_message' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'preview_message_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'preview_excluded_components' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('webform')
->fields(array(
  'nid',
  'next_serial',
  'confirmation',
  'confirmation_format',
  'redirect_url',
  'status',
  'block',
  'allow_draft',
  'auto_save',
  'submit_notice',
  'confidential',
  'submit_text',
  'submit_limit',
  'submit_interval',
  'total_submit_limit',
  'total_submit_interval',
  'progressbar_bar',
  'progressbar_page_number',
  'progressbar_percent',
  'progressbar_pagebreak_labels',
  'progressbar_include_confirmation',
  'progressbar_label_first',
  'progressbar_label_confirmation',
  'preview',
  'preview_next_button_label',
  'preview_prev_button_label',
  'preview_title',
  'preview_message',
  'preview_message_format',
  'preview_excluded_components',
))
->values(array(
  'nid' => '3',
  'next_serial' => '5',
  'confirmation' => '',
  'confirmation_format' => NULL,
  'redirect_url' => '<confirmation>',
  'status' => '1',
  'block' => '0',
  'allow_draft' => '0',
  'auto_save' => '0',
  'submit_notice' => '1',
  'confidential' => '0',
  'submit_text' => '',
  'submit_limit' => '-1',
  'submit_interval' => '-1',
  'total_submit_limit' => '-1',
  'total_submit_interval' => '-1',
  'progressbar_bar' => '1',
  'progressbar_page_number' => '0',
  'progressbar_percent' => '0',
  'progressbar_pagebreak_labels' => '1',
  'progressbar_include_confirmation' => '1',
  'progressbar_label_first' => 'Start',
  'progressbar_label_confirmation' => 'Complete',
  'preview' => '0',
  'preview_next_button_label' => '',
  'preview_prev_button_label' => '',
  'preview_title' => '',
  'preview_message' => '',
  'preview_message_format' => NULL,
  'preview_excluded_components' => '',
))
->values(array(
  'nid' => '4',
  'next_serial' => '5',
  'confirmation' => 'Webform (default "webform" #1) confirmation message',
  'confirmation_format' => 'plain_text',
  'redirect_url' => '<confirmation>',
  'status' => '1',
  'block' => '1',
  'allow_draft' => '0',
  'auto_save' => '0',
  'submit_notice' => '1',
  'confidential' => '0',
  'submit_text' => '',
  'submit_limit' => '1',
  'submit_interval' => '-1',
  'total_submit_limit' => '-1',
  'total_submit_interval' => '-1',
  'progressbar_bar' => '1',
  'progressbar_page_number' => '0',
  'progressbar_percent' => '0',
  'progressbar_pagebreak_labels' => '1',
  'progressbar_include_confirmation' => '1',
  'progressbar_label_first' => 'Start',
  'progressbar_label_confirmation' => 'Complete',
  'preview' => '0',
  'preview_next_button_label' => '',
  'preview_prev_button_label' => '',
  'preview_title' => '',
  'preview_message' => '',
  'preview_message_format' => 'filtered_html',
  'preview_excluded_components' => '',
))
->values(array(
  'nid' => '5',
  'next_serial' => '3',
  'confirmation' => '',
  'confirmation_format' => 'filtered_html',
  'redirect_url' => '<confirmation>',
  'status' => '1',
  'block' => '0',
  'allow_draft' => '0',
  'auto_save' => '0',
  'submit_notice' => '1',
  'confidential' => '0',
  'submit_text' => '',
  'submit_limit' => '1',
  'submit_interval' => '-1',
  'total_submit_limit' => '-1',
  'total_submit_interval' => '-1',
  'progressbar_bar' => '1',
  'progressbar_page_number' => '0',
  'progressbar_percent' => '0',
  'progressbar_pagebreak_labels' => '1',
  'progressbar_include_confirmation' => '1',
  'progressbar_label_first' => 'Start',
  'progressbar_label_confirmation' => 'Complete',
  'preview' => '0',
  'preview_next_button_label' => '',
  'preview_prev_button_label' => '',
  'preview_title' => '',
  'preview_message' => '',
  'preview_message_format' => 'filtered_html',
  'preview_excluded_components' => '',
))
->execute();
$connection->schema()->createTable('webform_component', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'cid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'pid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'form_key' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '128',
    ),
    'name' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '16',
    ),
    'value' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'extra' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'required' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'nid',
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('webform_component')
->fields(array(
  'nid',
  'cid',
  'pid',
  'form_key',
  'name',
  'type',
  'value',
  'extra',
  'required',
  'weight',
))
->values(array(
  'nid' => '3',
  'cid' => '1',
  'pid' => '0',
  'form_key' => 'title_as_textfield',
  'name' => 'Title (as textfield)',
  'type' => 'textfield',
  'value' => '',
  'extra' => "a:7:{s:11:\"description\";s:117:\"Required, no default value, no conditions.\r\nIf the title contains <code>fieldset</code>, then a fieldset will appear.\";s:13:\"title_display\";s:6:\"before\";s:17:\"description_above\";i:0;s:7:\"private\";i:0;s:15:\"wrapper_classes\";s:31:\"wrapper-class-1 wrapper-class-2\";s:11:\"css_classes\";s:25:\"item-class-1 item-class-2\";s:5:\"width\";s:3:\"100\";}",
  'required' => '1',
  'weight' => '0',
))
->values(array(
  'nid' => '3',
  'cid' => '2',
  'pid' => '0',
  'form_key' => 'date',
  'name' => 'Date',
  'type' => 'date',
  'value' => '',
  'extra' => 'a:7:{s:11:"description";s:45:"Optional, no default value, website timezone.";s:8:"timezone";s:4:"site";s:13:"title_display";s:6:"before";s:17:"description_above";i:0;s:7:"private";i:0;s:15:"wrapper_classes";s:0:"";s:14:"year_textfield";i:1;}',
  'required' => '0',
  'weight' => '1',
))
->values(array(
  'nid' => '3',
  'cid' => '3',
  'pid' => '0',
  'form_key' => 'email',
  'name' => 'E-mail',
  'type' => 'email',
  'value' => '[current-user:mail]',
  'extra' => 'a:8:{s:11:"description";s:93:"No label; user email as default; long format ("Example Name" <name@example.com>) can be used.";s:6:"format";s:4:"long";s:13:"title_display";s:4:"none";s:17:"description_above";i:0;s:7:"private";i:0;s:15:"wrapper_classes";s:0:"";s:11:"css_classes";s:0:"";s:11:"placeholder";s:15:"you@example.com";}',
  'required' => '0',
  'weight' => '2',
))
->values(array(
  'nid' => '3',
  'cid' => '4',
  'pid' => '0',
  'form_key' => 'file_attachment',
  'name' => 'File attachment',
  'type' => 'file',
  'value' => '',
  'extra' => 'a:6:{s:13:"title_display";s:6:"before";s:17:"description_above";i:0;s:7:"private";i:0;s:15:"wrapper_classes";s:0:"";s:11:"css_classes";s:0:"";s:9:"filtering";a:3:{s:4:"size";s:4:"2 MB";s:5:"types";a:20:{i:0;s:3:"gif";i:1;s:3:"jpg";i:2;s:4:"jpeg";i:3;s:3:"png";i:4;s:3:"eps";i:5;s:3:"txt";i:6;s:3:"rtf";i:7;s:4:"html";i:8;s:3:"pdf";i:9;s:3:"doc";i:10;s:4:"docx";i:11;s:3:"odt";i:12;s:3:"ppt";i:13;s:4:"pptx";i:14;s:3:"odp";i:15;s:3:"xls";i:16;s:4:"xlsx";i:17;s:3:"ods";i:18;s:3:"xml";i:19;s:2:"ps";}s:13:"addextensions";s:2:"ps";}}',
  'required' => '0',
  'weight' => '3',
))
->values(array(
  'nid' => '3',
  'cid' => '5',
  'pid' => '0',
  'form_key' => 'fieldset',
  'name' => 'Fieldset',
  'type' => 'fieldset',
  'value' => '',
  'extra' => 'a:3:{s:17:"description_above";i:0;s:7:"private";i:0;s:11:"css_classes";s:0:"";}',
  'required' => '0',
  'weight' => '4',
))
->values(array(
  'nid' => '3',
  'cid' => '6',
  'pid' => '5',
  'form_key' => 'hidden_value',
  'name' => 'Hidden value',
  'type' => 'hidden',
  'value' => 'hidden value of "hidden_value"',
  'extra' => 'a:3:{s:7:"private";i:0;s:11:"hidden_type";s:5:"value";s:8:"analysis";b:0;}',
  'required' => '0',
  'weight' => '5',
))
->values(array(
  'nid' => '3',
  'cid' => '7',
  'pid' => '0',
  'form_key' => 'text_markup',
  'name' => 'Text markup',
  'type' => 'markup',
  'value' => 'Some <strong>text</strong> with <code>filtered_html</code>, displayed only on the form.',
  'extra' => 'a:3:{s:6:"format";s:13:"filtered_html";s:7:"private";i:0;s:10:"display_on";s:4:"form";}',
  'required' => '0',
  'weight' => '5',
))
->values(array(
  'nid' => '3',
  'cid' => '8',
  'pid' => '0',
  'form_key' => 'number',
  'name' => 'Number',
  'type' => 'number',
  'value' => '',
  'extra' => 'a:22:{s:11:"description";s:31:"An integer between 10 and 3000.";s:13:"title_display";s:6:"before";s:17:"description_above";i:0;s:7:"private";i:0;s:15:"wrapper_classes";s:0:"";s:11:"css_classes";s:0:"";s:7:"integer";i:1;s:3:"min";s:2:"10";s:3:"max";s:4:"3000";s:4:"type";s:9:"textfield";s:12:"field_prefix";s:0:"";s:12:"field_suffix";s:0:"";s:8:"disabled";i:0;s:6:"unique";i:0;s:11:"placeholder";s:0:"";s:10:"attributes";a:0:{}s:8:"analysis";b:0;s:4:"step";s:0:"";s:8:"decimals";s:0:"";s:5:"point";s:1:".";s:9:"separator";s:1:",";s:11:"excludezero";i:0;}',
  'required' => '1',
  'weight' => '6',
))
->values(array(
  'nid' => '3',
  'cid' => '9',
  'pid' => '0',
  'form_key' => 'page_break',
  'name' => 'Page break',
  'type' => 'pagebreak',
  'value' => '',
  'extra' => 'a:3:{s:15:"next_page_label";s:23:"Next page button label ";s:15:"prev_page_label";s:27:"Previous page button label ";s:7:"private";i:0;}',
  'required' => '0',
  'weight' => '8',
))
->values(array(
  'nid' => '3',
  'cid' => '10',
  'pid' => '5',
  'form_key' => 'select_multi_nested',
  'name' => 'Select options (multiple, nested)',
  'type' => 'select',
  'value' => '',
  'extra' => "a:16:{s:5:\"items\";s:120:\"a|Option A\r\nb|Option B\r\n<Group A>\r\naa|Option AA\r\nab|Option AB\r\n<>\r\n<Group B>\r\nba|Option BA\r\nbb|Option BB\r\n<>\r\nc|Option C\";s:8:\"multiple\";i:1;s:13:\"title_display\";s:6:\"before\";s:17:\"description_above\";i:0;s:7:\"private\";i:0;s:15:\"wrapper_classes\";s:0:\"\";s:11:\"css_classes\";s:0:\"\";s:6:\"aslist\";i:1;s:12:\"empty_option\";s:0:\"\";s:7:\"optrand\";i:0;s:12:\"other_option\";N;s:10:\"other_text\";s:8:\"Other...\";s:11:\"description\";s:0:\"\";s:11:\"custom_keys\";b:0;s:14:\"options_source\";s:0:\"\";s:8:\"analysis\";b:1;}",
  'required' => '0',
  'weight' => '6',
))
->values(array(
  'nid' => '3',
  'cid' => '11',
  'pid' => '0',
  'form_key' => 'radios',
  'name' => 'Radios',
  'type' => 'select',
  'value' => 'wednesday',
  'extra' => "a:16:{s:11:\"description\";s:31:\"Select the best day of the week\";s:5:\"items\";s:108:\"tuesday|Tuesday\r\nwednesday|Wednesday\r\nthursday|Thursday\r\nfriday|Friday\r\nsaturday|Saturday\r\nsunday|Sunday\r\n\r\n\";s:8:\"multiple\";i:0;s:13:\"title_display\";s:6:\"before\";s:17:\"description_above\";i:0;s:7:\"private\";i:0;s:15:\"wrapper_classes\";s:0:\"\";s:11:\"css_classes\";s:0:\"\";s:6:\"aslist\";i:0;s:12:\"empty_option\";s:0:\"\";s:7:\"optrand\";i:0;s:12:\"other_option\";N;s:10:\"other_text\";s:8:\"Other...\";s:11:\"custom_keys\";b:0;s:14:\"options_source\";s:0:\"\";s:8:\"analysis\";b:1;}",
  'required' => '1',
  'weight' => '7',
))
->values(array(
  'nid' => '3',
  'cid' => '12',
  'pid' => '0',
  'form_key' => 'checkboxes',
  'name' => 'Checkboxes',
  'type' => 'select',
  'value' => '',
  'extra' => "a:16:{s:11:\"description\";s:46:\"Countries you want to travel to (only A and Z)\";s:5:\"items\";s:253:\"AF|Afghanistan\r\nAX|Aland Islands\r\nAL|Albania\r\nDZ|Algeria\r\nAS|American Samoa\r\nAD|Andorra\r\nAO|Angola\r\nAI|Anguilla\r\nAQ|Antarctica\r\nAG|Antigua and Barbuda\r\nAR|Argentina\r\nAM|Armenia\r\nAW|Aruba\r\nAU|Australia\r\nAT|Austria\r\nAZ|Azerbaijan\r\nZM|Zambia\r\nZW|Zimbabwe\r\n\";s:8:\"multiple\";i:1;s:13:\"title_display\";s:6:\"before\";s:17:\"description_above\";i:1;s:7:\"private\";i:0;s:15:\"wrapper_classes\";s:0:\"\";s:11:\"css_classes\";s:0:\"\";s:6:\"aslist\";i:0;s:12:\"empty_option\";s:0:\"\";s:7:\"optrand\";i:0;s:12:\"other_option\";N;s:10:\"other_text\";s:8:\"Other...\";s:11:\"custom_keys\";b:0;s:14:\"options_source\";s:0:\"\";s:8:\"analysis\";b:1;}",
  'required' => '0',
  'weight' => '9',
))
->values(array(
  'nid' => '3',
  'cid' => '13',
  'pid' => '0',
  'form_key' => 'textarea',
  'name' => 'Textarea',
  'type' => 'textarea',
  'value' => '',
  'extra' => 'a:13:{s:13:"title_display";s:6:"before";s:17:"description_above";i:0;s:7:"private";i:0;s:15:"wrapper_classes";s:0:"";s:11:"css_classes";s:0:"";s:9:"resizable";i:0;s:4:"cols";s:0:"";s:4:"rows";s:0:"";s:8:"disabled";i:0;s:11:"description";s:0:"";s:11:"placeholder";s:0:"";s:10:"attributes";a:0:{}s:8:"analysis";b:0;}',
  'required' => '0',
  'weight' => '10',
))
->values(array(
  'nid' => '3',
  'cid' => '14',
  'pid' => '0',
  'form_key' => 'time',
  'name' => 'Time',
  'type' => 'time',
  'value' => '',
  'extra' => 'a:11:{s:13:"title_display";s:6:"inline";s:17:"description_above";i:0;s:7:"private";i:0;s:15:"wrapper_classes";s:0:"";s:10:"hourformat";s:7:"24-hour";s:16:"minuteincrements";s:1:"1";s:8:"timezone";s:4:"user";s:10:"start_time";s:0:"";s:8:"end_time";s:0:"";s:11:"description";s:0:"";s:8:"analysis";b:0;}',
  'required' => '0',
  'weight' => '11',
))
->values(array(
  'nid' => '4',
  'cid' => '1',
  'pid' => '0',
  'form_key' => 'grid',
  'name' => 'Grid',
  'type' => 'grid',
  'value' => '',
  'extra' => "a:8:{s:11:\"description\";s:42:\"Please evaluate how Drupal fits your needs\";s:7:\"options\";s:61:\"hard|Hard\r\nneutral|Not too hard, but can be easier\r\neasy|Easy\";s:9:\"questions\";s:484:\"d7_sitebuild|How much you value Drupal 7 in terms of site building capabilities?\r\nd7_theming|How much you value Drupal 7 in terms of theme development?\r\nd7_backend|How much you value Drupal 7 in terms of module development?\r\nd9_sitebuild|How much you value Drupal 8 or Drupal 9 in terms of site building capabilities?\r\nd9_theming|How much you value Drupal 8 or Drupal 9 in terms of theme development?\r\nd9_backend|How much you value Drupal 8 or Drupal 9 in terms of module development?\";s:13:\"title_display\";s:6:\"before\";s:17:\"description_above\";i:1;s:7:\"private\";i:0;s:15:\"wrapper_classes\";s:0:\"\";s:6:\"sticky\";i:0;}",
  'required' => '0',
  'weight' => '0',
))
->values(array(
  'nid' => '5',
  'cid' => '1',
  'pid' => '0',
  'form_key' => 'brewing_styles',
  'name' => 'Brewing Styles',
  'type' => 'select',
  'value' => '',
  'extra' => "a:9:{s:11:\"description\";s:23:\"Brewing styles you like\";s:5:\"items\";s:101:\"drip_brew|Drip Brew\r\npour_over|Pour Over\r\ncold_brew|Cold Brew\r\nespresso|Espresso\r\nristretto|Ristretto\";s:8:\"multiple\";i:1;s:13:\"title_display\";s:6:\"before\";s:17:\"description_above\";i:1;s:7:\"private\";i:0;s:15:\"wrapper_classes\";s:0:\"\";s:11:\"css_classes\";s:0:\"\";s:6:\"aslist\";i:0;}",
  'required' => '0',
  'weight' => '0',
))
->values(array(
  'nid' => '5',
  'cid' => '2',
  'pid' => '0',
  'form_key' => 'drinks',
  'name' => 'Drinks',
  'type' => 'select',
  'value' => '',
  'extra' => "a:9:{s:11:\"description\";s:40:\"Please choose the coffee styles you like\";s:5:\"items\";s:384:\"espresso|Espresso (short black)\r\ndouble_espresso|Double Espresso (doppio)\r\nred_eye|Red Eye\r\nblack_eye|Black Eye\r\nlong_black|Long Black\r\nmacchiato|Macchiato\r\nlong_macchiato|Long Macchiato\r\ncortado|Cortado\r\nbreve|Breve\r\ncappuccino|Cappuccino\r\nflat_white|Flat White\r\ncafe_latte|Cafe Latte\r\nmocha|Mocha\r\nvienna|Vienna\r\naffogato|Affogato\r\ncafe_au_lait|Cafe au Lait\r\niced_coffee|Iced Coffee\";s:8:\"multiple\";i:1;s:13:\"title_display\";s:6:\"before\";s:17:\"description_above\";i:1;s:7:\"private\";i:0;s:15:\"wrapper_classes\";s:0:\"\";s:11:\"css_classes\";s:0:\"\";s:6:\"aslist\";i:0;}",
  'required' => '1',
  'weight' => '1',
))
->execute();
$connection->schema()->createTable('webform_conditional', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'rgid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'andor' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '128',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'nid',
    'rgid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('webform_conditional')
->fields(array(
  'nid',
  'rgid',
  'andor',
  'weight',
))
->values(array(
  'nid' => '3',
  'rgid' => '0',
  'andor' => NULL,
  'weight' => '-1',
))
->execute();
$connection->schema()->createTable('webform_conditional_actions', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'rgid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'aid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'target_type' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '128',
    ),
    'target' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '128',
    ),
    'invert' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'action' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '128',
    ),
    'argument' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'nid',
    'rgid',
    'aid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('webform_conditional_actions')
->fields(array(
  'nid',
  'rgid',
  'aid',
  'target_type',
  'target',
  'invert',
  'action',
  'argument',
))
->values(array(
  'nid' => '3',
  'rgid' => '0',
  'aid' => '0',
  'target_type' => 'component',
  'target' => '5',
  'invert' => '0',
  'action' => 'show',
  'argument' => '',
))
->execute();
$connection->schema()->createTable('webform_conditional_rules', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'rgid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'rid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'source_type' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '128',
    ),
    'source' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'operator' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '128',
    ),
    'value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'nid',
    'rgid',
    'rid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('webform_conditional_rules')
->fields(array(
  'nid',
  'rgid',
  'rid',
  'source_type',
  'source',
  'operator',
  'value',
))
->values(array(
  'nid' => '3',
  'rgid' => '0',
  'rid' => '0',
  'source_type' => 'component',
  'source' => '1',
  'operator' => 'contains',
  'value' => 'fieldset',
))
->execute();
$connection->schema()->createTable('webform_emails', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'eid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'email' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'subject' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'from_name' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'from_address' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'template' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'excluded_components' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'html' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'attachments' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'exclude_empty' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'extra' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '1',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'nid',
    'eid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('webform_emails')
->fields(array(
  'nid',
  'eid',
  'email',
  'subject',
  'from_name',
  'from_address',
  'template',
  'excluded_components',
  'html',
  'attachments',
  'exclude_empty',
  'extra',
  'status',
))
->values(array(
  'nid' => '5',
  'eid' => '1',
  'email' => 'info@drupal7-webform.localhost',
  'subject' => 'default',
  'from_name' => 'Coffee Questionnaire',
  'from_address' => 'default',
  'template' => 'default',
  'excluded_components' => '',
  'html' => '0',
  'attachments' => '0',
  'exclude_empty' => '0',
  'extra' => '',
  'status' => '1',
))
->execute();
$connection->schema()->createTable('webform_last_download', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'sid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'requested' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'nid',
    'uid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('webform_roles', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'rid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'nid',
    'rid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('webform_roles')
->fields(array(
  'nid',
  'rid',
))
->values(array(
  'nid' => '3',
  'rid' => '1',
))
->values(array(
  'nid' => '3',
  'rid' => '2',
))
->values(array(
  'nid' => '4',
  'rid' => '1',
))
->values(array(
  'nid' => '4',
  'rid' => '2',
))
->values(array(
  'nid' => '5',
  'rid' => '2',
))
->execute();
$connection->schema()->createTable('webform_submissions', array(
  'fields' => array(
    'sid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'serial' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'is_draft' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'highest_valid_page' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
    'submitted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'completed' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'modified' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'remote_addr' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '128',
    ),
  ),
  'primary key' => array(
    'sid',
  ),
  'unique keys' => array(
    'sid_nid' => array(
      'sid',
      'nid',
    ),
    'nid_serial' => array(
      'nid',
      'serial',
    ),
  ),
  'indexes' => array(
    'nid_uid_sid' => array(
      'nid',
      'uid',
      'sid',
    ),
    'nid_sid' => array(
      'nid',
      'sid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('webform_submissions')
->fields(array(
  'sid',
  'nid',
  'serial',
  'uid',
  'is_draft',
  'highest_valid_page',
  'submitted',
  'completed',
  'modified',
  'remote_addr',
))
->values(array(
  'sid' => '1',
  'nid' => '3',
  'serial' => '1',
  'uid' => '0',
  'is_draft' => '0',
  'highest_valid_page' => '0',
  'submitted' => '1600263958',
  'completed' => '1600263958',
  'modified' => '1600263958',
  'remote_addr' => '::1',
))
->values(array(
  'sid' => '2',
  'nid' => '3',
  'serial' => '2',
  'uid' => '0',
  'is_draft' => '0',
  'highest_valid_page' => '0',
  'submitted' => '1600264081',
  'completed' => '1600264081',
  'modified' => '1600264081',
  'remote_addr' => '::1',
))
->values(array(
  'sid' => '3',
  'nid' => '3',
  'serial' => '3',
  'uid' => '0',
  'is_draft' => '0',
  'highest_valid_page' => '0',
  'submitted' => '1600327212',
  'completed' => '1600327212',
  'modified' => '1600327212',
  'remote_addr' => '172.16.0.166',
))
->values(array(
  'sid' => '4',
  'nid' => '4',
  'serial' => '1',
  'uid' => '0',
  'is_draft' => '0',
  'highest_valid_page' => '0',
  'submitted' => '1600327251',
  'completed' => '1600327251',
  'modified' => '1600327251',
  'remote_addr' => '172.16.0.166',
))
->values(array(
  'sid' => '5',
  'nid' => '5',
  'serial' => '1',
  'uid' => '3',
  'is_draft' => '0',
  'highest_valid_page' => '0',
  'submitted' => '1600327319',
  'completed' => '1600327319',
  'modified' => '1600327319',
  'remote_addr' => '172.16.0.166',
))
->values(array(
  'sid' => '6',
  'nid' => '4',
  'serial' => '2',
  'uid' => '3',
  'is_draft' => '0',
  'highest_valid_page' => '0',
  'submitted' => '1600327404',
  'completed' => '1600327404',
  'modified' => '1600327404',
  'remote_addr' => '172.16.0.166',
))
->values(array(
  'sid' => '7',
  'nid' => '3',
  'serial' => '4',
  'uid' => '3',
  'is_draft' => '0',
  'highest_valid_page' => '0',
  'submitted' => '1600327527',
  'completed' => '1600327527',
  'modified' => '1600327527',
  'remote_addr' => '172.16.0.166',
))
->values(array(
  'sid' => '8',
  'nid' => '4',
  'serial' => '3',
  'uid' => '0',
  'is_draft' => '0',
  'highest_valid_page' => '0',
  'submitted' => '1600328002',
  'completed' => '1600328002',
  'modified' => '1600328002',
  'remote_addr' => '::1',
))
->values(array(
  'sid' => '9',
  'nid' => '4',
  'serial' => '4',
  'uid' => '2',
  'is_draft' => '0',
  'highest_valid_page' => '0',
  'submitted' => '1600328929',
  'completed' => '1600328929',
  'modified' => '1600328929',
  'remote_addr' => '127.0.0.1',
))
->values(array(
  'sid' => '10',
  'nid' => '5',
  'serial' => '2',
  'uid' => '1',
  'is_draft' => '0',
  'highest_valid_page' => '0',
  'submitted' => '1600335185',
  'completed' => '1600335185',
  'modified' => '1600335185',
  'remote_addr' => '::1',
))
->execute();
$connection->schema()->createTable('webform_submitted_data', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'sid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'cid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'no' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '0',
    ),
    'data' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'medium',
    ),
  ),
  'primary key' => array(
    'nid',
    'sid',
    'cid',
    'no',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
    'sid_nid' => array(
      'sid',
      'nid',
    ),
    'data' => array(
      array(
        'data',
        '64',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('webform_submitted_data')
->fields(array(
  'nid',
  'sid',
  'cid',
  'no',
  'data',
))
->values(array(
  'nid' => '3',
  'sid' => '1',
  'cid' => '1',
  'no' => '0',
  'data' => 'Example submission from an anonymous user',
))
->values(array(
  'nid' => '3',
  'sid' => '1',
  'cid' => '2',
  'no' => '0',
  'data' => '2018-10-23',
))
->values(array(
  'nid' => '3',
  'sid' => '1',
  'cid' => '3',
  'no' => '0',
  'data' => '',
))
->values(array(
  'nid' => '3',
  'sid' => '1',
  'cid' => '4',
  'no' => '0',
  'data' => '1',
))
->values(array(
  'nid' => '3',
  'sid' => '1',
  'cid' => '8',
  'no' => '0',
  'data' => '11',
))
->values(array(
  'nid' => '3',
  'sid' => '1',
  'cid' => '11',
  'no' => '0',
  'data' => 'sunday',
))
->values(array(
  'nid' => '3',
  'sid' => '1',
  'cid' => '12',
  'no' => '0',
  'data' => 'AF',
))
->values(array(
  'nid' => '3',
  'sid' => '1',
  'cid' => '12',
  'no' => '1',
  'data' => 'AL',
))
->values(array(
  'nid' => '3',
  'sid' => '1',
  'cid' => '12',
  'no' => '2',
  'data' => 'DZ',
))
->values(array(
  'nid' => '3',
  'sid' => '1',
  'cid' => '12',
  'no' => '3',
  'data' => 'AQ',
))
->values(array(
  'nid' => '3',
  'sid' => '1',
  'cid' => '12',
  'no' => '4',
  'data' => 'AG',
))
->values(array(
  'nid' => '3',
  'sid' => '1',
  'cid' => '12',
  'no' => '5',
  'data' => 'AR',
))
->values(array(
  'nid' => '3',
  'sid' => '1',
  'cid' => '12',
  'no' => '6',
  'data' => 'AU',
))
->values(array(
  'nid' => '3',
  'sid' => '1',
  'cid' => '12',
  'no' => '7',
  'data' => 'ZW',
))
->values(array(
  'nid' => '3',
  'sid' => '1',
  'cid' => '13',
  'no' => '0',
  'data' => 'Why I cannot choose Monday as my favorite weekday?',
))
->values(array(
  'nid' => '3',
  'sid' => '1',
  'cid' => '14',
  'no' => '0',
  'data' => '18:01:00',
))
->values(array(
  'nid' => '3',
  'sid' => '2',
  'cid' => '1',
  'no' => '0',
  'data' => 'Text with fieldset',
))
->values(array(
  'nid' => '3',
  'sid' => '2',
  'cid' => '2',
  'no' => '0',
  'data' => '',
))
->values(array(
  'nid' => '3',
  'sid' => '2',
  'cid' => '3',
  'no' => '0',
  'data' => 'me@somewhere.else',
))
->values(array(
  'nid' => '3',
  'sid' => '2',
  'cid' => '4',
  'no' => '0',
  'data' => '2',
))
->values(array(
  'nid' => '3',
  'sid' => '2',
  'cid' => '6',
  'no' => '0',
  'data' => 'hidden value of "hidden_value"',
))
->values(array(
  'nid' => '3',
  'sid' => '2',
  'cid' => '8',
  'no' => '0',
  'data' => '20',
))
->values(array(
  'nid' => '3',
  'sid' => '2',
  'cid' => '10',
  'no' => '0',
  'data' => 'a',
))
->values(array(
  'nid' => '3',
  'sid' => '2',
  'cid' => '10',
  'no' => '1',
  'data' => 'ba',
))
->values(array(
  'nid' => '3',
  'sid' => '2',
  'cid' => '10',
  'no' => '2',
  'data' => 'bb',
))
->values(array(
  'nid' => '3',
  'sid' => '2',
  'cid' => '11',
  'no' => '0',
  'data' => 'friday',
))
->values(array(
  'nid' => '3',
  'sid' => '2',
  'cid' => '12',
  'no' => '0',
  'data' => 'AQ',
))
->values(array(
  'nid' => '3',
  'sid' => '2',
  'cid' => '13',
  'no' => '0',
  'data' => '',
))
->values(array(
  'nid' => '3',
  'sid' => '2',
  'cid' => '14',
  'no' => '0',
  'data' => '',
))
->values(array(
  'nid' => '3',
  'sid' => '3',
  'cid' => '1',
  'no' => '0',
  'data' => 'Submission from an another anonymous user',
))
->values(array(
  'nid' => '3',
  'sid' => '3',
  'cid' => '2',
  'no' => '0',
  'data' => '2020-09-17',
))
->values(array(
  'nid' => '3',
  'sid' => '3',
  'cid' => '3',
  'no' => '0',
  'data' => 'another@email.address',
))
->values(array(
  'nid' => '3',
  'sid' => '3',
  'cid' => '4',
  'no' => '0',
  'data' => '3',
))
->values(array(
  'nid' => '3',
  'sid' => '3',
  'cid' => '8',
  'no' => '0',
  'data' => '244',
))
->values(array(
  'nid' => '3',
  'sid' => '3',
  'cid' => '11',
  'no' => '0',
  'data' => 'sunday',
))
->values(array(
  'nid' => '3',
  'sid' => '3',
  'cid' => '12',
  'no' => '0',
  'data' => 'AG',
))
->values(array(
  'nid' => '3',
  'sid' => '3',
  'cid' => '12',
  'no' => '1',
  'data' => 'AW',
))
->values(array(
  'nid' => '3',
  'sid' => '3',
  'cid' => '13',
  'no' => '0',
  'data' => 'FooBarBaz',
))
->values(array(
  'nid' => '3',
  'sid' => '3',
  'cid' => '14',
  'no' => '0',
  'data' => '09:22:00',
))
->values(array(
  'nid' => '3',
  'sid' => '7',
  'cid' => '1',
  'no' => '0',
  'data' => "User's submission",
))
->values(array(
  'nid' => '3',
  'sid' => '7',
  'cid' => '2',
  'no' => '0',
  'data' => '2020-01-23',
))
->values(array(
  'nid' => '3',
  'sid' => '7',
  'cid' => '3',
  'no' => '0',
  'data' => 'user@drupal7-webform.localhost',
))
->values(array(
  'nid' => '3',
  'sid' => '7',
  'cid' => '8',
  'no' => '0',
  'data' => '45',
))
->values(array(
  'nid' => '3',
  'sid' => '7',
  'cid' => '11',
  'no' => '0',
  'data' => 'wednesday',
))
->values(array(
  'nid' => '3',
  'sid' => '7',
  'cid' => '12',
  'no' => '0',
  'data' => 'AQ',
))
->values(array(
  'nid' => '3',
  'sid' => '7',
  'cid' => '12',
  'no' => '1',
  'data' => 'AW',
))
->values(array(
  'nid' => '3',
  'sid' => '7',
  'cid' => '13',
  'no' => '0',
  'data' => 'No file was attached.',
))
->values(array(
  'nid' => '3',
  'sid' => '7',
  'cid' => '14',
  'no' => '0',
  'data' => '20:04:00',
))
->values(array(
  'nid' => '4',
  'sid' => '4',
  'cid' => '1',
  'no' => 'd7_backend',
  'data' => 'neutral',
))
->values(array(
  'nid' => '4',
  'sid' => '4',
  'cid' => '1',
  'no' => 'd7_sitebuild',
  'data' => 'neutral',
))
->values(array(
  'nid' => '4',
  'sid' => '4',
  'cid' => '1',
  'no' => 'd7_theming',
  'data' => 'easy',
))
->values(array(
  'nid' => '4',
  'sid' => '4',
  'cid' => '1',
  'no' => 'd9_backend',
  'data' => 'easy',
))
->values(array(
  'nid' => '4',
  'sid' => '4',
  'cid' => '1',
  'no' => 'd9_sitebuild',
  'data' => 'neutral',
))
->values(array(
  'nid' => '4',
  'sid' => '4',
  'cid' => '1',
  'no' => 'd9_theming',
  'data' => 'easy',
))
->values(array(
  'nid' => '4',
  'sid' => '6',
  'cid' => '1',
  'no' => 'd7_backend',
  'data' => 'neutral',
))
->values(array(
  'nid' => '4',
  'sid' => '6',
  'cid' => '1',
  'no' => 'd7_sitebuild',
  'data' => 'neutral',
))
->values(array(
  'nid' => '4',
  'sid' => '6',
  'cid' => '1',
  'no' => 'd7_theming',
  'data' => 'easy',
))
->values(array(
  'nid' => '4',
  'sid' => '6',
  'cid' => '1',
  'no' => 'd9_backend',
  'data' => 'hard',
))
->values(array(
  'nid' => '4',
  'sid' => '6',
  'cid' => '1',
  'no' => 'd9_sitebuild',
  'data' => 'neutral',
))
->values(array(
  'nid' => '4',
  'sid' => '6',
  'cid' => '1',
  'no' => 'd9_theming',
  'data' => '',
))
->values(array(
  'nid' => '4',
  'sid' => '8',
  'cid' => '1',
  'no' => 'd7_backend',
  'data' => 'hard',
))
->values(array(
  'nid' => '4',
  'sid' => '8',
  'cid' => '1',
  'no' => 'd7_sitebuild',
  'data' => 'easy',
))
->values(array(
  'nid' => '4',
  'sid' => '8',
  'cid' => '1',
  'no' => 'd7_theming',
  'data' => 'neutral',
))
->values(array(
  'nid' => '4',
  'sid' => '8',
  'cid' => '1',
  'no' => 'd9_backend',
  'data' => 'hard',
))
->values(array(
  'nid' => '4',
  'sid' => '8',
  'cid' => '1',
  'no' => 'd9_sitebuild',
  'data' => 'hard',
))
->values(array(
  'nid' => '4',
  'sid' => '8',
  'cid' => '1',
  'no' => 'd9_theming',
  'data' => 'neutral',
))
->values(array(
  'nid' => '4',
  'sid' => '9',
  'cid' => '1',
  'no' => 'd7_backend',
  'data' => 'neutral',
))
->values(array(
  'nid' => '4',
  'sid' => '9',
  'cid' => '1',
  'no' => 'd7_sitebuild',
  'data' => 'easy',
))
->values(array(
  'nid' => '4',
  'sid' => '9',
  'cid' => '1',
  'no' => 'd7_theming',
  'data' => 'easy',
))
->values(array(
  'nid' => '4',
  'sid' => '9',
  'cid' => '1',
  'no' => 'd9_backend',
  'data' => 'easy',
))
->values(array(
  'nid' => '4',
  'sid' => '9',
  'cid' => '1',
  'no' => 'd9_sitebuild',
  'data' => 'easy',
))
->values(array(
  'nid' => '4',
  'sid' => '9',
  'cid' => '1',
  'no' => 'd9_theming',
  'data' => 'easy',
))
->values(array(
  'nid' => '5',
  'sid' => '5',
  'cid' => '1',
  'no' => '0',
  'data' => 'espresso',
))
->values(array(
  'nid' => '5',
  'sid' => '5',
  'cid' => '1',
  'no' => '1',
  'data' => 'ristretto',
))
->values(array(
  'nid' => '5',
  'sid' => '5',
  'cid' => '2',
  'no' => '0',
  'data' => 'espresso',
))
->values(array(
  'nid' => '5',
  'sid' => '5',
  'cid' => '2',
  'no' => '1',
  'data' => 'double_espresso',
))
->values(array(
  'nid' => '5',
  'sid' => '5',
  'cid' => '2',
  'no' => '2',
  'data' => 'macchiato',
))
->values(array(
  'nid' => '5',
  'sid' => '5',
  'cid' => '2',
  'no' => '3',
  'data' => 'cappuccino',
))
->values(array(
  'nid' => '5',
  'sid' => '5',
  'cid' => '2',
  'no' => '4',
  'data' => 'mocha',
))
->values(array(
  'nid' => '5',
  'sid' => '5',
  'cid' => '2',
  'no' => '5',
  'data' => 'vienna',
))
->values(array(
  'nid' => '5',
  'sid' => '10',
  'cid' => '1',
  'no' => '0',
  'data' => 'pour_over',
))
->values(array(
  'nid' => '5',
  'sid' => '10',
  'cid' => '1',
  'no' => '1',
  'data' => 'espresso',
))
->values(array(
  'nid' => '5',
  'sid' => '10',
  'cid' => '2',
  'no' => '0',
  'data' => 'macchiato',
))
->values(array(
  'nid' => '5',
  'sid' => '10',
  'cid' => '2',
  'no' => '1',
  'data' => 'long_macchiato',
))
->values(array(
  'nid' => '5',
  'sid' => '10',
  'cid' => '2',
  'no' => '2',
  'data' => 'cortado',
))
->values(array(
  'nid' => '5',
  'sid' => '10',
  'cid' => '2',
  'no' => '3',
  'data' => 'affogato',
))
->execute();
