<?php

/**
 * @file
  /**
 * @file
 * Custom views handler definition.
 *
 * Place this code in
 * /sites/all/[custom_module_name]/includes/views_handler_social_share_links_field.inc
 */

/**
 * Custom handler class.
 *
 * @ingroup views_field_handlers
 */
class views_handler_social_share_links_field extends views_handler_field {

  /**
   * {@inheritdoc}
   *
   * Perform any database or cache data retrieval here. In this example there is
   * none.
   */
  function query() {
    
  }

  /**
   * {@inheritdoc}
   *
   * Modify any end user views settings here. Debug $options to view the field
   * settings you can change.
   */
  function option_definition() {
    $options = parent::option_definition();
    return $options;
  }

  /**
   * {@inheritdoc}
   *
   * Make changes to the field settings form seen by the end user when adding
   * your field.
   */
  function options_form(&$form, &$form_state) {
    parent::options_form($form, $form_state);
  }

  /**
   * Render callback handler.
   *
   * Return the markup that will appear in the rendered field.
   */
  function render($data) {
    if ($data->_field_data['nid']['entity_type'] == 'node') {
      $node = node_load($data->nid);
      $share_box = '';
      $link = theme('social_share_links', array('node' => $node));
      $share_box = render($link);
      $output = '<div class ="share-box">';
      $output .= $share_box;
      $output .= '</div>';
    }
    else {
      $output = 'Se requiere un contenido de tipo nodo para las redes sociales';
    }
    return $output;
  }

}
