<?php

function custom_search_config_form($form, &$form_state) {
  drupal_add_js(drupal_get_path('module', 'custom_search') . '/js/custom_search_admin.js');
  $items_blocks = variable_get('custom_search_items_block', array());
  $id_block = arg(4);
  $edit = FALSE;
  if (is_numeric($id_block) && isset($items_blocks[$id_block])) {
    $id = $id_block;
    $edit = TRUE;
    $nombre = $items_blocks[$id]['nombre'];
    $submit = 'Guardar';
    $placeholder = $items_blocks[$id]['placeholder'];
    $buscar_drupal = $items_blocks[$id]['buscar_drupal'];
  }
  else {
    $id = variable_get('custom_search_blocks_actual_id', 1);
    $nombre = '';
    $submit = 'Agregar';
    $placeholder = '';
    $buscar_drupal = 1;
  }
  $items_blocks_created = FALSE;
  if (count($items_blocks) > 0) {
    $items_blocks_created = TRUE;
    $header = array('ID', 'Nombre block', 'Placeholder', 'Buscador drupal', 'Operaciones');
    foreach ($items_blocks as $key => $item) {
      $rows[] = array($key, $item['nombre'], $item['placeholder'], $item['buscar_drupal'], l('Editar', 'admin/config/custom_search/add_search_block/' . $key) . ' - ' . l('Agregar ó Editar Items', 'admin/config/custom_search/add_items_search_block/' . $key));
    }
    $table = theme('table', array('header' => $header, 'rows' => $rows));
  }
  if ($items_blocks_created) {
    $form['html'] = array(
      '#type' => 'markup',
      '#markup' => $table
    );
  }
  $form['id'] = array(
    '#type' => 'hidden',
    '#required' => TRUE,
    '#maxlength' => 255,
    '#default_value' => $id,
  );
  $form['nombre'] = array(
    '#type' => 'textfield',
    '#title' => 'Nombre bloque',
    '#required' => TRUE,
    '#maxlength' => 255,
    '#description' => 'Nombre del bloque',
    '#default_value' => $nombre
  );
  $form['placeholder'] = array(
    '#type' => 'textfield',
    '#title' => 'Placeholder u opción inicial',
    '#maxlength' => 255,
    '#description' => 'Texto a mostrar como placeholder u opción inicial si es select, si no tiene se pondra la primera opción.',
    '#default_value' => $placeholder
  );
  $form['buscar_drupal'] = array(
    '#type' => 'radios',
    '#title' => 'Habilitar opción busqueda en todo el sitio',
    '#options' => array(1 => 'Si', 0 => 'No'),
    '#description' => 'Indica si la opción de buscar en todo el sitio se carga en el select',
    '#required' => TRUE,
    '#default_value' => $buscar_drupal
  );

  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => $submit,
  );
  if ($edit) {
    $form['delete'] = array(
      '#type' => 'submit',
      '#submit' => array('custom_search_config_form_delete'),
      '#value' => 'Eliminar',
    );
  }

  return $form;
}

function custom_search_config_form_submit($form, &$form_state) {
  $items_blocks = variable_get('custom_search_items_block', array());
  $id = $form_state['values']['id'];
  $item_block['nombre'] = $form_state['values']['nombre'];
  $item_block['placeholder'] = $form_state['values']['placeholder'];
  $item_block['buscar_drupal'] = $form_state['values']['buscar_drupal'];
  $items_blocks[$id] = $item_block;
  variable_set('custom_search_items_block', $items_blocks);
  $id = variable_set('custom_search_blocks_actual_id', $id + 1);
  $message = 'Se actualizaron los bloques de busqueda';
  drupal_set_message($message);
  drupal_goto('admin/config/custom_search/add_search_block');
}

function custom_search_config_form_delete($form, &$form_state) {
  $id_block = $form_state['values']['id'];
  $items_blocks = variable_get('custom_search_items_block', array());
  $items = variable_get('custom_search_items_' . $id_block, array());
  foreach ($items as $k => $item) {
    variable_del('custom_search_config_precise_searchs_items_' . $id_block . '-' . $item['id']);
  }
  variable_del('custom_search_items_' . $id_block);
  unset($items_blocks[$id_block]);

  variable_set('custom_search_items_block', $items_blocks);
  $message = 'Se elimino el buscador con id = ' . $id_block;
  drupal_set_message($message);
  drupal_goto('admin/config/custom_search/add_search_block');
}

function custom_search_config_items_form($form, &$form_state) {
  $no_access = FALSE;
  $id_block = arg(4);
  if (is_numeric($id_block)) {
    $items_blocks = variable_get('custom_search_items_block', array());
    if (!isset($items_blocks[$id_block])) {
      $no_access = TRUE;
    }
  }
  else {
    $no_access = TRUE;
  }
  if ($no_access) {
    drupal_set_message('Debe seleccionar el bloque al que desea agregar o editar items');
    drupal_goto('admin/config/custom_search/add_search_block');
  }
  $items = variable_get('custom_search_items_' . $id_block, array());
  $items_created = FALSE;
  if (count($items) > 0) {
    $items_created = TRUE;
    $header = array('Pos', 'ID', 'Etiqueta', 'Tipo', 'Url', 'Peso', 'Operaciones');
    foreach ($items as $key => $item) {
      if ($item['tipo'] == 'select') {
        $links = l('Editar', 'admin/config/custom_search/add_items_search_block/' . $id_block . '/' . $item['id'] . '/edit');
        $links .= ' - ' . l('Agregar, Editar Items', 'admin/config/custom_search/add_precise_searchs/' . $id_block . '/' . $item['id']);
      }
      else {
        $links = l('Editar', 'admin/config/custom_search/add_items_search_block/' . $id_block . '/' . $item['id'] . '/edit');
      }
      $rows[] = array($key, $item['id'], $item['etiqueta'], $item['tipo'], $item['url'], $item['peso'], $links);
    }
    $table = theme('table', array('header' => $header, 'rows' => $rows));
  }
  if (is_numeric(arg(5)) && arg(5) > 0 && arg(6) == 'edit') {
    $action = 'edit';
    foreach ($items as $key => $value) {
      if ($value['id'] == arg(5)) {
        $id = $value['id'];
        $pos = $key;
      }
    }
    $etiqueta = $items[$pos]['etiqueta'];
    $tipo = $items[$pos]['tipo'];
    $url = $items[$pos]['url'];
    $peso = $items[$pos]['peso'];
    $label_btn = 'Guardar Cambios';
  }
  else {
    $action = 'add';
    $id = variable_get('custom_search_items_actual_id_' . $id_block, 1);
    $etiqueta = $url = '';
    $label_btn = 'Agregar';
    $tipo = 'url';
    $peso = 0;
  }
  $html = '<div class="title-table"><h2>Bloque - ' . $items_blocks[$id_block]['nombre'] . '</h2></div>';
  if ($items_created) {
    $html .= $table;
  }
  $form['html'] = array(
    '#type' => 'markup',
    '#markup' => $html
  );
  $form['id_block'] = array(
    '#type' => 'hidden',
    '#required' => TRUE,
    '#maxlength' => 255,
    '#default_value' => $id_block,
  );
  $form['id'] = array(
    '#type' => 'hidden',
    '#required' => TRUE,
    '#maxlength' => 255,
    '#default_value' => $id,
  );
  $form['actual_action'] = array(
    '#type' => 'hidden',
    '#required' => TRUE,
    '#maxlength' => 255,
    '#default_value' => $action,
  );
  $form['etiqueta'] = array(
    '#type' => 'textfield',
    '#title' => 'Etiqueta para select',
    '#required' => TRUE,
    '#maxlength' => 255,
    '#description' => 'Etiqueta a mostrar en el select',
    '#default_value' => $etiqueta,
  );

  $form['tipo'] = array(
    '#type' => 'radios',
    '#options' => array(
      'url' => 'Url',
      'select' => 'Select busqueda puntual',
    ),
    '#title' => 'Tipo de campo asociado a la busqueda',
    '#default_value' => $tipo
  );

  $form['url'] = array(
    '#type' => 'textfield',
    '#title' => 'URL',
    '#states' => array(
      'visible' => array(
        ':input[name="tipo"]' => array('value' => 'url'),
      ),
      'required' => array(
        ':input[name="tipo"]' => array('value' => 'url'),
      ),
    ),
    '#default_value' => $url
  );
  for ($i = -10; $i < 10; $i++) {
    $weight[$i] = $i;
  }
  $form['peso'] = array(
    '#type' => 'select',
    '#title' => 'peso',
    '#options' => $weight,
    '#required' => TRUE,
    '#default_value' => $peso,
  );
  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => $label_btn,
  );

  return $form;
}

function custom_search_config_items_form_submit($form, &$form_state) {
  $id_block = $form_state['values']['id_block'];
  $items = variable_get('custom_search_items_' . $id_block, array());
  $id = $form_state['values']['id'];
  $item['id'] = $id;
  $item['etiqueta'] = $form_state['values']['etiqueta'];
  $item['tipo'] = $form_state['values']['tipo'];
  $item['url'] = $form_state['values']['url'];
  $item['peso'] = $form_state['values']['peso'];
  if ($form_state['values']['actual_action'] == 'add') {
    $items[] = $item;
  }
  else {
    $key = custom_search_pos_bloque($items, $id);
    $items[$key] = $item;
  }

  $items = custom_search_ordernaArrayMulti($items, 'peso');
  variable_set('custom_search_items_' . $id_block, $items);
  if ($form_state['values']['actual_action'] == 'add') {
    $id = variable_set('custom_search_items_actual_id_' . $id_block, $id + 1);
    $message = 'Se agrego el item a las opciones de busqueda';
  }
  else {
    $message = 'Se modifico el item con id ' . $id;
    $form_state['redirect'] = 'admin/config/custom_search/add_items_search_block/' . $id_block;
  }
  drupal_set_message($message);
}

function custom_search_config_precise_searchs_form($form, & $form_state) {
  if (!isset($form_state['values']['id'])) {
    if (is_numeric(arg(4)) && arg(4) > 0 && is_numeric(arg(5)) && arg(5) > 0) {
      $no_acces = FALSE;
      $blocks = variable_get('custom_search_items_block', array());
      if (isset($blocks[arg(4)]['nombre'])) {
        $items_block = variable_get('custom_search_items_' . arg(4), array());
        $key = custom_search_pos_bloque($items_block, arg(5));
        if (isset($items_block[$key])) {
          $nombre_bloque = $blocks[arg(4)]['nombre'];
          $nombre_item = $items_block[$key]['etiqueta'];
        }
        else {
          $no_acces = TRUE;
        }
      }
      else {
        $no_acces = TRUE;
      }
    }
    else {
      $no_acces = TRUE;
    }
    if ($no_acces) {
      drupal_set_message('Debe seleccionar el item de bloque al que desea agregar o editar una busqueda puntual');
      drupal_goto('admin/config/custom_search/add_items_search_block');
    }
  }
  $id = arg(4) . '-' . arg(5);
  $items = variable_get('custom_search_config_precise_searchs_items_' . $id, array());
  $items_created = FALSE;
  if (count($items) > 0) {
    $items_created = TRUE;
    $header = array('Pos', 'ID', 'Etiqueta', 'Tipo busqueda', 'Url Get', 'Vista', 'Display', 'Argumento texto', 'Tipo', 'Vocabulario VID', 'Placeholder', 'Peso', 'Operaciones');
    foreach ($items as $key => $item) {
      $ids = explode('-', $item['id']);
      if ($item['tipo_busqueda'] == 'url') {
        $item['vista'] = $item['display'] = $item['arg_text'] = '';
      }
      $rows[] = array($key, $item['id'], $item['etiqueta'], $item['tipo_busqueda'], $item['url_busqueda'], $item['vista'], $item['display'], $item['arg_text'], $item['tipo'], $item['arg_tax'], $item['placeholder'], $item['peso'], l('Editar', 'admin/config/custom_search/add_precise_searchs/' . $ids[0] . '/' . $ids[1] . '/' . $ids[2] . '/edit'));
    }
    $table = theme('table', array('header' => $header, 'rows' => $rows));
  }
  $views = custom_search_get_views();
  $views_keys = array_keys($views);
  if (is_numeric(arg(6)) && arg(6) > 0 && arg(7) == 'edit') {
    $new_id = arg(4) . '-' . arg(5) . '-' . arg(6);
    $key = custom_search_pos_bloque($items, $new_id);
    $action = 'edit';
    $etiqueta = $items[$key]['etiqueta'];
    $tipo_busqueda = $items[$key]['tipo_busqueda'];
    $url_get = $items[$key]['url_busqueda'];
    $view = $items[$key]['vista'];
    $display = $items[$key]['display'];
    $arg_text = $items[$key]['arg_text'];
    $arg_tax = $items[$key]['arg_tax'];
    $placeholder = $items[$key]['placeholder'];
    $tipo = $items[$key]['tipo'];
    $peso = $items[$key]['peso'];
    $label_btn = 'Guardar Cambios';
  }
  else {
    $action = 'add';
    $etiqueta = $display = $arg_text = $placeholder = $url_get = '';
    $view = $views_keys[0];
    $arg_tax = 0;
    $tipo = 'text';
    $peso = 0;
    $actual = variable_get('custom_search_config_precise_searchs_actual_' . $id, 1);
    $new_id = $id . '-' . $actual;
    $label_btn = 'Agregar';
    $tipo_busqueda = 'view';
  }

  $html = '<div class="title-table"><h2>Busqueda - ' . $nombre_bloque . ' - ' . $nombre_item . '</h2></div>';
  if ($items_created) {
    $html .= $table;
  }
  $form['html'] = array(
    '#type' => 'markup',
    '#markup' => $html
  );

  $form['id'] = array(
    '#type' => 'hidden',
    '#required' => TRUE,
    '#maxlength' => 255,
    '#default_value' => $new_id,
  );
  $form['actual_action'] = array(
    '#type' => 'hidden',
    '#required' => TRUE,
    '#maxlength' => 255,
    '#default_value' => $action,
  );
  $form['etiqueta'] = array(
    '#type' => 'textfield',
    '#title' => 'Etiqueta para select',
    '#required' => TRUE,
    '#maxlength' => 255,
    '#description' => 'Etiqueta a mostrar en el select',
    '#default_value' => $etiqueta,
  );
  $form['tipo_busqueda'] = array(
    '#type' => 'radios',
    '#options' => array(
      'url' => 'URL GET',
      'view' => 'Vista',
    ),
    '#title' => 'Tipo busqueda',
    '#default_value' => $tipo_busqueda
  );
  $form['url_busqueda'] = array(
    '#type' => 'textfield',
    '#title' => 'URL GET',
    '#states' => array(
      'visible' => array(
        ':input[name="tipo_busqueda"]' => array('value' => 'url'),
      ),
      'required' => array(
        ':input[name="tipo_busqueda"]' => array('value' => 'url'),
      ),
    ),
    '#default_value' => $url_get,
    '#description' => 'Ubique los corchetes "{}" en la pocisión en donde va el parametro enviado por el usuario'
  );

  $form['vista'] = array(
    '#title' => 'Selecione la vista',
    '#type' => 'select',
    '#options' => $views,
    '#default_value' => $view,
    '#ajax' => array(
      'callback' => 'ajax_display_callback',
      'wrapper' => 'display_div',
    ),
    '#description' => 'Seleccione la vista',
    '#states' => array(
      'visible' => array(
        ':input[name="tipo_busqueda"]' => array('value' => 'view')
      ),
      'required' => array(
        ':input[name="tipo_busqueda"]' => array('value' => 'view')
      ),
    ),
  );
  $form['display'] = array(
    '#type' => 'select',
    '#title' => 'Seleccione el despliegue',
    '#options' => _custom_search_get_views_displays($view),
    '#prefix' => '<div id="display_div">',
    '#suffix' => '</div>',
    '#description' => 'Seleccione el despliegue que desea mostrar de la vista seleccionada',
    '#default_value' => $display,
    '#states' => array(
      'visible' => array(
        ':input[name="tipo_busqueda"]' => array('value' => 'view')
      ),
      'required' => array(
        ':input[name="tipo_busqueda"]' => array('value' => 'view')
      ),
    ),
  );
  $form['argumento_text'] = array(
    '#type' => 'textfield',
    '#title' => 'Argumento',
    '#maxlength' => 255,
    '#default_value' => $arg_text,
    '#description' => 'Argumento para la vista, si se agrega será el arg(1)',
    '#states' => array(
      'visible' => array(
        ':input[name="tipo_busqueda"]' => array('value' => 'view')
      ),
    ),
  );
  $form['tipo'] = array(
    '#type' => 'radios',
    '#options' => array(
      'no' => 'Sin campo adicional',
      'text' => 'Caja de texto',
      'tax' => 'Taxonomía',
    ),
    '#title' => 'Tipo de campo adicional expuesto para el usuario en la busqueda',
    '#default_value' => $tipo
  );
  $form['placeholder'] = array(
    '#type' => 'textfield',
    '#title' => 'Placeholder',
    '#maxlength' => 255,
    '#default_value' => $placeholder,
    '#description' => 'Placeholder a mostrar en el campo expuesto adicional',
    '#states' => array(
      'visible' => array(
        ':input[name="tipo"]' => array(array('value' => 'text'), array('value' => 'tax'))
      ),
      'required' => array(
        ':input[name="tipo"]' => array(array('value' => 'text'), array('value' => 'tax'))
      ),
    ),
  );
  $vocabularies = custom_search_get_vocabularies();
  $form['argumento_taxonomy'] = array(
    '#title' => 'Selecione el vocabulario',
    '#type' => 'select',
    '#options' => $vocabularies,
    '#default_value' => $arg_tax,
    '#description' => 'Argumento de táxonomia, si se ha agregado argumento de texto será el arg(2) de lo contrario será el arg(1)',
    '#states' => array(
      'visible' => array(
        ':input[name="tipo"]' => array('value' => 'tax'),
      ),
      'required' => array(
        ':input[name="tipo"]' => array('value' => 'tax'),
      ),
    ),
  );
  for ($i = -10; $i < 10; $i++) {
    $weight[$i] = $i;
  }
  $form['peso'] = array(
    '#type' => 'select',
    '#title' => 'peso',
    '#options' => $weight,
    '#required' => TRUE,
    '#default_value' => $peso,
  );
  if (!empty($form_state['values']['vista'])) {
    $form['display']['#options'] = _custom_search_get_views_displays($form_state['values']['vista']);
  }

  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => $label_btn,
  );

  return $form;
}

function ajax_display_callback($form, $form_state) {
  return $form['display'];
}

function custom_search_config_precise_searchs_form_submit($form, &$form_state) {
  $id = $form_state['values']['id'];
  $ids = explode('-', $id);
  $items = variable_get('custom_search_config_precise_searchs_items_' . $ids[0] . '-' . $ids[1], array());
  $item['id'] = $id;
  $item['tipo_busqueda'] = $form_state['values']['tipo_busqueda'];
  $item['url_busqueda'] = $form_state['values']['url_busqueda'];
  $item['etiqueta'] = $form_state['values']['etiqueta'];
  $item['vista'] = $form_state['values']['vista'];
  $item['display'] = $form_state['values']['display'];
  $item['arg_text'] = $form_state['values']['argumento_text'];
  $item['arg_tax'] = $form_state['values']['argumento_taxonomy'];
  $item['tipo'] = $form_state['values']['tipo'];
  $item['placeholder'] = $form_state['values']['placeholder'];
  $item['peso'] = $form_state['values']['peso'];

  if ($form_state['values']['actual_action'] == 'add') {
    $items[] = $item;
    $message = 'Se agrego el item a las opciones de busqueda';
  }
  else {
    $key = custom_search_pos_bloque($items, $id);
    $items[$key] = $item;
    $message = 'Se modifico el item con id ' . $id;
  }

  $form_state['redirect'] = 'admin/config/custom_search/add_precise_searchs/' . $ids[0] . '/' . $ids[1];
  $items = custom_search_ordernaArrayMulti($items, 'peso');
  variable_set('custom_search_config_precise_searchs_actual_' . $ids[0] . '-' . $ids[1], $ids[2] + 1);
  variable_set('custom_search_config_precise_searchs_items_' . $ids[0] . '-' . $ids[1], $items);
  drupal_set_message($message);
}

function custom_search_ordernaArrayMulti($Array, $field, $inverse = FALSE) {
  $position = array();
  $newRow = array();
  foreach ($Array as $key => $row) {
    $position[$key] = $row[$field];
    $newRow[$key] = $row;
  }
  if ($inverse) {
    arsort($position);
  }
  else {
    asort($position);
  }
  $returnArray = array();
  foreach ($position as $key => $pos) {
    $returnArray[] = $newRow[$key];
  }
  return $returnArray;
}
