<?php
/**
 * @file
 * Default theme implementation to provide an HTML container for comments.
 *
 * Available variables:
 * - $content: The array of content-related elements for the node. Use
 *   render($content) to print them all, or
 *   print a subset such as render($content['comment_form']).
 * - $classes: String of classes that can be used to style contextually through
 *   CSS. It can be manipulated through the variable $classes_array from
 *   preprocess functions. The default value has the following:
 *   - comment-wrapper: The current template type, i.e., "theming hook".
 * - $title_prefix (array): An array containing additional output populated by
 *   modules, intended to be displayed in front of the main title tag that
 *   appears in the template.
 * - $title_suffix (array): An array containing additional output populated by
 *   modules, intended to be displayed after the main title tag that appears in
 *   the template.
 *
 * The following variables are provided for contextual information.
 * - $node: Node object the comments are attached to.
 * The constants below the variables show the possible values and should be
 * used for comparison.
 * - $display_mode
 *   - COMMENT_MODE_FLAT
 *   - COMMENT_MODE_THREADED
 *
 * Other variables:
 * - $classes_array: Array of html class attribute values. It is flattened
 *   into a string within the variable $classes.
 *
 * @see template_preprocess_comment_wrapper()
 *
 * @ingroup themeable
 */
?>
<?php
$block = module_invoke('print_ui', 'block_view', 'print-links');
$block_print = $block['content'];
$block = module_invoke('text_resize', 'block_view', '0');
$block_resize = $block['content'];
//$block = module_invoke('menu', 'block_view', 'menu-redes-sociales');
$block_redes = get_redes_sociales_custom_block();
$cant_comments = count($content['comments']) - 2;
//drupal_add_js(drupal_get_path('theme', 'asocolderma').'/js/comment_validate.js');
?>

<div id="comments" class="<?php print $classes; ?>"<?php print $attributes; ?>>
  <div class="tools-comments"><span class="print"><?php print $block_print ?></span><span class="resize"><?php print $block_resize ?></span>
    <?php if ($cant_comments > 0) { ?>
      <span class="cant_comments">
        <span class="value_cant_comments">
          <?php print $cant_comments ?>
        </span>
        <span class="label_cant_comments"> Comentarios</span>
      </span>
    <?php } ?>
    <span class="social"><?php print render($block_redes) ?></span></div>
  <?php if ($content['comment_form']){ ?>
                  <!--h2 class="title comment-form"><?php print t('Add new comment'); ?></h2-->
    <?php 
    global $user;
    $user = user_load($user->uid);
    $picture = theme(
      'image_style', array(
      'style_name' => '70x100',
      'path' => !empty($user->picture->uri) ? $user->picture->uri : variable_get('user_picture_default'),
      'attributes' => array(
      'class' => 'img-user-comment',
      ),
        )
    );
    ?>

    <?php print $picture ?>
    <span class="link-recomendar"><a href="#"> Recomendar </a></span><span class="link-ordenar"><a href="#"> Ordenar por los mejores </a></span>
    <?php print render($content['comment_form']); ?>
  <?php } ?>
</div>
<?php if ($cant_comments > 0) { ?>
  <div class="all-comments"><a class="link-all-comments" href="#">Ver todos los comentarios</a></div>
<?php } ?>
<?php if ($content['comments'] && $node->type != 'forum'): ?>
  <?php print render($title_prefix); ?>
  <h2 class="title"><?php print t('Comments'); ?></h2>
  <?php print render($title_suffix); ?>
<?php endif; ?>
<div class="all-comments-box" style="display:none">
  <?php print render($content['comments']); ?>
</div>

