<?php
/**
 * @file
 * Default theme implementation to display a single Drupal page.
 *
 * The doctype, html, head and body tags are not in this template. Instead they
 * can be found in the html.tpl.php template in this directory.
 *
 * Available variables:
 *
 * General utility variables:
 * - $base_path: The base URL path of the Drupal installation. At the very
 *   least, this will always default to /.
 * - $directory: The directory the template is located in, e.g. modules/system
 *   or themes/bartik.
 * - $is_front: TRUE if the current page is the front page.
 * - $logged_in: TRUE if the user is registered and signed in.
 * - $is_admin: TRUE if the user has permission to access administration pages.
 *
 * Site identity:
 * - $front_page: The URL of the front page. Use this instead of $base_path,
 *   when linking to the front page. This includes the language domain or
 *   prefix.
 * - $logo: The path to the logo image, as defined in theme configuration.
 * - $site_name: The name of the site, empty when display has been disabled
 *   in theme settings.
 * - $site_slogan: The slogan of the site, empty when display has been disabled
 *   in theme settings.
 *
 * Navigation:
 * - $main_menu (array): An array containing the Main menu links for the
 *   site, if they have been configured.
 * - $secondary_menu (array): An array containing the Secondary menu links for
 *   the site, if they have been configured.
 * - $breadcrumb: The breadcrumb trail for the current page.
 *
 * Page content (in order of occurrence in the default page.tpl.php):
 * - $title_prefix (array): An array containing additional output populated by
 *   modules, intended to be displayed in front of the main title tag that
 *   appears in the template.
 * - $title: The page title, for use in the actual HTML content.
 * - $title_suffix (array): An array containing additional output populated by
 *   modules, intended to be displayed after the main title tag that appears in
 *   the template.
 * - $messages: HTML for status and error messages. Should be displayed
 *   prominently.
 * - $tabs (array): Tabs linking to any sub-pages beneath the current page
 *   (e.g., the view and edit tabs when displaying a node).
 * - $action_links (array): Actions local to the page, such as 'Add menu' on the
 *   menu administration interface.
 * - $feed_icons: A string of all feed icons for the current page.
 * - $node: The node object, if there is an automatically-loaded node
 *   associated with the page, and the node ID is the second argument
 *   in the page's path (e.g. node/12345 and node/12345/revisions, but not
 *   comment/reply/12345).
 *
 * Regions:
 * - $page['help']: Dynamic help text, mostly for admin pages.
 * - $page['highlighted']: Items for the highlighted content region.
 * - $page['content']: The main content of the current page.
 * - $page['sidebar_first']: Items for the first sidebar.
 * - $page['sidebar_second']: Items for the second sidebar.
 * - $page['header']: Items for the header region.
 * - $page['footer']: Items for the footer region.
 *
 * @see bootstrap_preprocess_page()
 * @see template_preprocess()
 * @see template_preprocess_page()
 * @see bootstrap_process_page()
 * @see template_process()
 * @see html.tpl.php
 *
 * @ingroup themeable
 */
?>
<?php
$domain = domain_get_domain();
?>
<header id="navbar" role="banner" class="<?php print $navbar_classes; ?> domain-<?php print $domain['domain_id'] ?>">

  <div class="top-header">
    <div class="header-wrapper">
      <?php print render($page['top_header']); ?>
      <?php $block = module_invoke('custom_layouts', 'block_view', 'user_picture_form'); ?>
      <div class="user-box"><?php print drupal_render($block['content']); ?></div>
    </div>
  </div>

  <div class="header">
    <div class="<?php print $container_class; ?>">
      <div class="navbar-header">
        <!-- .btn-navbar is used as the toggle for collapsed navbar content -->
        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
          <span class="sr-only">Toggle navigation</span>
          <span class="icon-bar"></span>
          <span class="icon-bar"></span>
          <span class="icon-bar"></span>
        </button>
        <?php if (!empty($site_name)): ?>
          <a class="name navbar-brand"  title="<?php print t('Home'); ?>">
            <?php if ($logo): ?>
              <img src="<?php print $logo; ?>" alt="<?php print t('Home'); ?>" />
            <?php endif; ?>
          </a>
        <?php endif; ?>
      </div>

      <?php if (!empty($primary_nav) || !empty($secondary_nav)): ?>
        <div class="navbar-collapse collapse">
          <nav role="navigation">
            <?php if (!empty($secondary_nav)): ?>
              <?php print render($secondary_nav); ?>
            <?php endif; ?>
            <?php if (!empty($primary_nav)): ?>
              <?php print render($primary_nav); ?>
            <?php endif; ?>
          </nav>
        </div>
      <?php endif; ?>

      <?php print render($page['header']); ?>
    </div>    
  </div>
</header>

<div class="main-container <?php print $container_class; ?>">
  <div class="row">
    <div class="col-md-12">
      <div class="left-section col-md-2">
        <?php print render($page['left_region']); ?>
      </div>    

      <div class="content-wrapper col-md-10">
        <div class="menu-top-region col-md-12">
          <?php print render($page['menu_top_region']); ?>
        </div>
        <div class="top-region col-md-12">
          <?php print render($page['top_region']); ?>
          <?php if (!empty($title)): ?>
            <h1 class="page-header"><?php print $title; ?></h1>
          <?php endif; ?>
          <div id="banner-header"></div>   
          <?php
          if (!empty($breadcrumb)): print $breadcrumb;
          endif;
          ?>
        </div>

        <div class="col-md-8 center-content">
          <section<?php print $content_column_class; ?>>            
            <a id="main-content"></a>
            <?php print render($title_prefix); ?>
            <?php print render($title_suffix); ?>   
            <?php if ($messages) { ?>
              <div class="messages-box">
                <div class="content-messages">
                  <div class="top-messages">
                    <span>Mensaje de alerta</span>
                    <a href="#" class="link-close-messages"></a>
                  </div>
                  <?php print $messages; ?>
                </div>       
              </div>
            <?php } ?>
            <?php if (!empty($tabs)): ?>
              <?php print render($tabs); ?>
            <?php endif; ?>
            <?php if (!empty($action_links)): ?>
              <ul class="action-links"><?php print render($action_links); ?></ul>
            <?php endif; ?>
            <div id="content_top">

              <?php print render($page['content_top']); ?>
            </div>  
            <?php $url = "h" . ($_SERVER['REQUEST_URI']); ?>
            <div id="content_block" <?php if ($url == "h/node/add/articulo-revista") { ?>class="hide_login"<?php }//    ?> >
              <?php print render($page['content']); ?>
            </div>
            <div class="left-col">
              <?php print render($page['content_left']); ?>
            </div>
            <div class="right-col">
              <?php print render($page['content_right']); ?>
            </div>
            <div class="content-bottom col-md-12">
              <?php print render($page['content_bottom']); ?>
            </div>  
          </section>
        </div>


        <?php if (!empty($page['sidebar'])): ?>
          <aside class="col-md-4" role="complementary">
            <?php print render($page['sidebar']); ?>
          </aside>  <!-- /#sidebar -->
        <?php endif; ?>

        <div class="bottom-region col-md-12">
          <?php print render($page['bottom_region']); ?>
        </div>  


        <footer class="footer col-md-12">
          <a class="anchor" id="registerMail"></a>
          <div class="big-footer">
            <div class="col-md-8">
              <?php print render($page['footer_left']); ?>
            </div>
            <div class="col-md-4">
              <?php print render($page['footer_right']); ?>
            </div>
          </div>
          <div class="footer-bottom">
            <?php print render($page['footer_bottom']); ?>
          </div>




          <div class="pauta-desktop pauta-mosca">
            <?php
            if ($domain['domain_id'] == 1) { // Asocolderma pacientes
              if (user_is_logged_in()) {
                $block = module_invoke('openads', 'block_view', 25);
              }
              else {
                $block = module_invoke('openads', 'block_view', 27);
              }
            }
            elseif ($domain['domain_id'] == 2) { // Asocolderma congreso
              $block = module_invoke('openads', 'block_view', 29);
            }
            elseif ($domain['domain_id'] == 3) { // Asocolderma revista
              $block = module_invoke('openads', 'block_view', 31);
            }
            if (isset($block['content'])) {
              print $block['content'];
            }
            else {
              print '';
            }
            ?>
          </div>
          <div class="pauta-movil pauta-mosca">
            <?php
            if ($domain['domain_id'] == 1) { // Asocolderma pacientes
              if (user_is_logged_in()) {
                $block = module_invoke('openads', 'block_view', 26);
              }
              else {
                $block = module_invoke('openads', 'block_view', 28);
              }
            }
            elseif ($domain['domain_id'] == 2) { // Asocolderma congreso
              $block = module_invoke('openads', 'block_view', 30);
            }
            elseif ($domain['domain_id'] == 3) { // Asocolderma revista
              $block = module_invoke('openads', 'block_view', 32);
            }
            if (isset($block['content'])) {
              print $block['content'];
            }
            else {
              print '';
            }
            ?>
          </div>


        </footer>  
      </div>
    </div>
  </div>
</div>
<script type="text/javascript">
  /*popUp Go to Dermatologos item , Menu principal  ↓*/
  jQuery(document).ready(function ($) {
<?php
global $user;
if (in_array("anonymous user", $user->roles)) {
  ?>
      $(".go_dermatologos").click(function (event) {
        event.preventDefault();
        var finalURL = $(this).attr("href");
        setTimeout(function () {
          // jQuery('#appendSubmit').append(jQuery('#edit-actions'));
          // jQuery('#colorbox').css('top', '0');
          var elements = jQuery(".popup_ingreso_derma #login_popup");
          console.log("rayos 1 " + jQuery(".popup_ingreso_derma #login_popup"));
          for (var i = 0; i < elements.length; i++) {
            // console.log(i);
            elements[i].addEventListener('click', function (event) {
              event.preventDefault();
              var finalURL = jQuery(this).attr("href");
              jQuery('.ajax-register-links.inline li a').first().trigger('click');
              jQuery('#colorbox').addClass('colorbox_ayuda');
              setTimeout(function () {
                jQuery('#colorbox').css('top', '0');
                jQuery('#colorbox').hide();
              }, 500);
            });
          }
        }, 1500);
        $.colorbox({
          html: '<div class="popup_ingreso_derma"><h1>Ingreso sección Dermatólogos</h1><span>Esta sección es exclusiva para médicos dermatólogos miembros de AsoColDerma. Si usted es médico dermatólogo y desea afiliarse, <a href="/requisitos-para-afiliarse">Conozca aquí los requisitos para hacerlo</a><br><br>Los contenidos aquí publicados están destinados a personal médico y pueden causar sensibilidad en pacientes o personas que no cumplan con este requisito.</span><ul><li><a id="login_popup" href="/user/login">Soy dermatólogo Asociado</a></li><li><a id="continue_session_logged" href="javascript:void(0);">Entendido, deseo continuar</a></li></ul></div>',
          href: finalURL,
          maxWidth: "800px",
          preloading: true,
          onLoad: true
        });
      });
<?php } ?>

    jQuery("#ayuda_login p a").click(function (event) {
      event.preventDefault();
      var finalURL = jQuery(this).attr("href");
      jQuery.get(jQuery(this).attr("href"), function (data) {
        jQuery.colorbox({
          html: jQuery(data).find('#ajax-register-user-login-wrapper'),
          href: finalURL,
          preloading: true,
          onLoad: true,
          maxWidth: "800px",
        });
      });
      jQuery('#colorbox').addClass('colorbox_ayuda');
      setTimeout(function () {
        jQuery('#colorbox').css('top', '0');
      }, 500);
    });
    // enfermedades dermatologicas
    // Cuando el filtro de la pagina cambia, automaticamente corre el boton "apply" =>
    function refresh_clic_trigger() {
      jQuery('#content_top #views-exposed-form-enfermedades-dermatologicas-page-2 .views-exposed-widget .form-select, #content_top .views-exposed-widget input:checkbox').change(function () {        
        jQuery('#content_top .views-exposed-widget button:submit').trigger('click');
      });
      jQuery('#content_top #views-exposed-form-comite-editorial-page-5 .views-exposed-widget .form-select, #content_top .views-exposed-widget input:checkbox').change(function () {
        if (jQuery('#edit-field-servicios-y-especialidades-tid').val() == '0') {
          jQuery('#edit-field-servicios-y-especialidades-tid').val('All');
          jQuery('#edit-field-condicional-value').val('1');
        } else {
          jQuery('#edit-field-condicional-value').val('All');
        }
        jQuery('#content_top .views-exposed-widget button:submit').trigger('click');
      });
      jQuery('.btn-search a').click(function () {
        jQuery('#content_top .views-exposed-form #edit-title-wrapper input#edit-title').val(jQuery('#search-title').val());
        jQuery('#content_top .views-exposed-widget button:submit').trigger('click');
      });


    }
    refresh_clic_trigger();
    // Cuando el filtro de la pagina cambia, automaticamente corre el boton "apply" <=
    // Moviendo filtro a content-top en enfermedades dermatologicas
    if (jQuery('#content_block .clase-unica1').length == 1) {

      //jQuery('#content_top .contextual-links-region #edit-title-wrapper input#edit-title').attr('placeholder', 'Nombre de la enfermedad'); // Placeholder
      //jQuery('#content_top .contextual-links-region #edit-title-wrapper').clone().prependTo(jQuery('#content_block .region-content #block-system-main')); // clonando filtros     
      jQuery('#content_top .views-exposed-form #edit-title-wrapper').hide();
      jQuery('#content_block .region-content .head-search-enfermedades .search-box-enfermedades').prepend('<span class="label-search"><label class="lb-search-title">¿Qu&eacute enfermedad de la piel buscas?</label></span><span class="box-search"><input class="form-text" type="text" id="search-title" placeholder="Nombre de la enfermedad"> </span><span class="btn-search"><a href="#">Buscar</a></span>');

      //jQuery('#content_block .contextual-links-region #edit-title-wrapper').siblings('div').not('div.views-submit-button').remove(); // eliminando siblings
      //jQuery('#content_top .contextual-links-region #edit-title-wrapper').remove(); // eliminando filtro title
      jQuery('#content_top').append(jQuery('#content_block .view-header')); // moviendo buscador ABC

      refresh_clic_trigger();
    }
    // Moviendo filtro a content-top en preguntas_frecuentes 
    if (jQuery('#content_block .clase-unica2').length == 1) {
      jQuery('#content_block .view-filters').appendTo(jQuery('#content_top')); // moviendo filtros
      jQuery('#content_top .view-filters input#edit-title').attr('placeholder', 'Nombre de la enfermedad'); // Placeholder
      refresh_clic_trigger();
    }
    // Moviendo filtro a content-top en directorio_dermatologos 
    if (jQuery('#content_block .clase-unica3').length == 1) {
      jQuery('#content_block .view-filters').appendTo(jQuery('#content_top')); // moviendo filtros
      jQuery('#content_top .view-filters input#edit-field-nombres-value').attr('placeholder', 'Nombre o apellido del dermatólogo'); // Placeholder
      refresh_clic_trigger();
    }

    // Cambiando HTML botones imagenes consultorio
<?php
if (arg(2) == "datos_publicos") {
  ?>
      jQuery('#edit-field-imagen-consultorio-1-und-0-browse-button').html("Subir foto 1");
      jQuery('#edit-field-imagen-consultorio-2-und-0-browse-button').html("Subir foto 2");
      jQuery('#open_g_map').click(function (event) {
        event.preventDefault();
        jQuery('#mapa-group').removeClass("hidden");
        jQuery.colorbox({
          html: jQuery('#mapa-group'),
          href: "/",
          preloading: true,
          maxWidth: "800px",
          onLoad: true,
          onCleanup: function () {
            console.log("pre close");
            jQuery('#mapa-group').addClass("hidden");
            jQuery('#user-profile-form').append(jQuery('#mapa-group'));
          },
          onClosed: function () {
            console.log("close");
            jQuery('#mapa-group').addClass("hidden");
          },
        });
      });
      /*jQuery.colorbox({
       html: jQuery('#gmap-auto3map-gmap0'),
       href: "/",
       preloading: true,
       onLoad: true,
       onClosed: function(){
       console.log("close");
       },
       });*/
<?php } ?>

  });
  function refresh_click_go_submit_again() {
    var elements = jQuery("#go_submit_again");
    // console.log(elements.length);
    for (var i = 0; i < elements.length; i++) {
      // console.log(i);
      elements[i].addEventListener('click', function () {
        event.preventDefault();
        var formData = localStorage.getItem("formData");
        console.log("formData es : " + formData);
        jQuery('.ajax-register-links.inline li a').first().trigger('click');
        setTimeout(function () {
          jQuery('#colorbox').css('top', '0');
          jQuery('#cboxClose').fadeOut('slow');
          delete localStorage.formData;
        }, 500);
      });
    }
  }

  function refresh_click_2() {
    var elements = jQuery("#go_submit2");
    for (var i = 0; i < elements.length; i++) {
      elements[i].addEventListener('click', function () {
        event.preventDefault();
        jQuery('#cboxClose').trigger('click');
      });
    }
  }
  /*popUp Go to Dermatologos item , Menu principal  ↑*/
</script>


