<?php

/**
 * @file
 * Default simple view template to all the fields as a row.
 *
 * - $view: The view in use.
 * - $fields: an array of $field objects. Each one contains:
 *   - $field->content: The output of the field.
 *   - $field->raw: The raw data for the field, if it exists. This is NOT output safe.
 *   - $field->class: The safe class id to use.
 *   - $field->handler: The Views field handler object controlling this field. Do not use
 *     var_export to dump this object, as it can't handle the recursion.
 *   - $field->inline: Whether or not the field should be inline.
 *   - $field->inline_html: either div or span based on the above flag.
 *   - $field->wrapper_prefix: A complete wrapper containing the inline_html to use.
 *   - $field->wrapper_suffix: The closing tag for the wrapper.
 *   - $field->separator: an optional separator that may appear before a field.
 *   - $field->label: The wrap label text to use.
 *   - $field->label_html: The full HTML of the label to use including
 *     configured element type.
 * - $row: The raw result object from the query, with all data it fetched.
 *
 * @ingroup views_templates
 */
$target = '';
$path = str_replace(
	array('<span class="field-content">','</span>'),
	'',
	$fields['path']->content
);
$external_link = str_replace(
	array('<div class="field-content">','</div>'),
	'',
	$fields['field_enlace_externo']->content
);
if( trim($external_link) != '' ){
	$path = $external_link;
	$target = '_blank';
}
?>
<div class="views-field views-field-field-image">
	<a href="<?php echo $path; ?>" target="<?php echo $target; ?>">
		<?php echo $fields['field_image']->content; ?>
	</a>
</div>  
<div class="views-field views-field-nothing">
	<span class="field-content">
		<div class="title-block">
			<a href="<?php echo $path; ?>" target="<?php echo $target; ?>">
				<?php echo $fields['title']->content; ?>
			</a>
		</div>
		<div class="descrip-block">
			<div class="views-field views-field-field-fuente">
				<div class="field-content"><?php echo $fields['field_fuente']->content; ?></div>
			</div>
		</div>
	</span>
</div>
